/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.platform;

import com.almostreliable.merequester.Registration;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.network.DragAndDropPacket;
import com.almostreliable.merequester.network.PacketHandler;
import com.almostreliable.merequester.network.RequestUpdatePacket;
import com.almostreliable.merequester.network.RequesterSyncPacket;
import com.almostreliable.merequester.platform.Config;
import java.util.List;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.PacketDistributor;

public final class Platform {
    private Platform() {
    }

    public static void initConfig() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
    }

    public static int getRequestLimit() {
        return (Integer)Config.COMMON.requests.get();
    }

    public static double getIdleEnergy() {
        return (Double)Config.COMMON.idleEnergy.get();
    }

    public static boolean requireChannel() {
        return (Boolean)Config.COMMON.requireChannel.get();
    }

    public static CreativeModeTab createTab() {
        return CreativeModeTab.builder().m_257941_((Component)Utils.translate("itemGroup", "tab", new Object[0])).m_257737_(() -> Registration.REQUESTER.stack()).m_257794_().m_257652_();
    }

    public static void sendRequestUpdate(long requesterId, int requestIndex, boolean state) {
        PacketHandler.CHANNEL.sendToServer((Object)new RequestUpdatePacket(requesterId, requestIndex, state));
    }

    public static void sendRequestUpdate(long requesterId, int requestIndex, long amount, long batch) {
        PacketHandler.CHANNEL.sendToServer((Object)new RequestUpdatePacket(requesterId, requestIndex, amount, batch));
    }

    public static void sendDragAndDrop(long requesterId, int requestIndex, ItemStack item) {
        PacketHandler.CHANNEL.sendToServer((Object)new DragAndDropPacket(requesterId, requestIndex, item));
    }

    public static void sendClearData(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)RequesterSyncPacket.clearData());
        }
    }

    public static void sendInventoryData(Player player, long requesterId, CompoundTag data) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)RequesterSyncPacket.inventory(requesterId, data));
        }
    }

    public static List<Renderable> getRenderables(Screen screen) {
        return screen.f_169369_;
    }
}

