/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.byte_panel;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.WaterloggedMultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BlockFaceUtils;
import com.copycatsplus.copycats.utility.MathUtils;
import com.google.common.collect.ImmutableMap;
import com.mojang.math.OctahedralGroup;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatBytePanelBlock
extends WaterloggedMultiStateCopycatBlock
implements ISpecialBlockItemRequirement {
    public static BooleanProperty BOTTOM_LEFT = BooleanProperty.m_61465_((String)"bottom_left");
    public static BooleanProperty BOTTOM_RIGHT = BooleanProperty.m_61465_((String)"bottom_right");
    public static BooleanProperty TOP_LEFT = BooleanProperty.m_61465_((String)"top_left");
    public static BooleanProperty TOP_RIGHT = BooleanProperty.m_61465_((String)"top_right");
    public static DirectionProperty FACING = BlockStateProperties.f_61372_;
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    private final ImmutableMap<FaceData, VoxelShape> partialFaceCache;

    public CopycatBytePanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BOTTOM_LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM_RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP_LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP_RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.DOWN));
        this.shapesCache = this.m_152458_(CopycatBytePanelBlock::calculateMultiFaceShape);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BOTTOM_LEFT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM_RIGHT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TOP_LEFT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TOP_RIGHT, (Comparable)Boolean.valueOf(true));
        for (String property : this.storageProperties()) {
            for (Direction facing : FACING.m_6908_()) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)facing);
                for (Direction face : Direction.values()) {
                    builder.put((Object)new FaceData(property, facing, face), (Object)BlockFaceUtils.getPartialFaceShape(null, state, property, face));
                }
            }
        }
        this.partialFaceCache = builder.build();
    }

    @Override
    public String defaultProperty() {
        return BOTTOM_LEFT.m_61708_();
    }

    @Override
    public Vec3i vectorScale(BlockState state) {
        return new Vec3i(2, 2, 2).m_5487_(((Direction)state.m_61143_((Property)FACING)).m_122434_(), -1);
    }

    @Override
    public boolean partExists(BlockState state, String property) {
        if (property.equals(BOTTOM_LEFT.m_61708_())) {
            return (Boolean)state.m_61143_((Property)BOTTOM_LEFT);
        }
        if (property.equals(BOTTOM_RIGHT.m_61708_())) {
            return (Boolean)state.m_61143_((Property)BOTTOM_RIGHT);
        }
        if (property.equals(TOP_LEFT.m_61708_())) {
            return (Boolean)state.m_61143_((Property)TOP_LEFT);
        }
        if (property.equals(TOP_RIGHT.m_61708_())) {
            return (Boolean)state.m_61143_((Property)TOP_RIGHT);
        }
        return false;
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(BOTTOM_LEFT, BOTTOM_RIGHT, TOP_LEFT, TOP_RIGHT).stream().map(Property::m_61708_).collect(Collectors.toSet());
    }

    @Override
    public int getColorIndex(String property) {
        if (property.equals(BOTTOM_LEFT.m_61708_())) {
            return 0;
        }
        if (property.equals(BOTTOM_RIGHT.m_61708_())) {
            return 1;
        }
        if (property.equals(TOP_LEFT.m_61708_())) {
            return 1;
        }
        if (property.equals(TOP_RIGHT.m_61708_())) {
            return 0;
        }
        throw new RuntimeException("Invalid property: " + property);
    }

    @Override
    public String getPropertyFromInteraction(BlockState state, BlockGetter level, Vec3i hitLocation, BlockPos blockPos, Direction facing, Vec3 unscaledHit) {
        Direction blockFacing = (Direction)state.m_61143_((Property)FACING);
        Direction horizontal = CopycatBytePanelBlock.getHorizontal(blockFacing);
        Direction vertical = CopycatBytePanelBlock.getVertical(blockFacing);
        int horizontalHit = Mth.m_14045_((int)hitLocation.m_123304_(horizontal.m_122434_()), (int)0, (int)1);
        if (horizontal.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            horizontalHit = 1 - horizontalHit;
        }
        int verticalHit = Mth.m_14045_((int)hitLocation.m_123304_(vertical.m_122434_()), (int)0, (int)1);
        if (vertical.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            verticalHit = 1 - verticalHit;
        }
        return CopycatBytePanelBlock.getProperty(horizontalHit, verticalHit);
    }

    @Override
    public Vec3i getVectorFromProperty(BlockState state, String property) {
        Direction blockFacing = (Direction)state.m_61143_((Property)FACING);
        Direction horizontal = CopycatBytePanelBlock.getHorizontal(blockFacing);
        Direction vertical = CopycatBytePanelBlock.getVertical(blockFacing);
        Vector2i vector = CopycatBytePanelBlock.getVector(property);
        return Vec3i.f_123288_.m_5487_(horizontal.m_122434_(), horizontal.m_122421_() == Direction.AxisDirection.NEGATIVE ? 1 - vector.x : vector.x).m_5487_(vertical.m_122434_(), vertical.m_122421_() == Direction.AxisDirection.NEGATIVE ? 1 - vector.y : vector.y);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{BOTTOM_LEFT, BOTTOM_RIGHT, TOP_LEFT, TOP_RIGHT, FACING}));
    }

    private static VoxelShape calculateMultiFaceShape(BlockState pState) {
        VoxelShape shape = Shapes.m_83040_();
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        CopycatBytePanelBlock block = (CopycatBytePanelBlock)pState.m_60734_();
        Vec3 size = MathUtils.replaceAxis(new Vec3(8.0, 8.0, 8.0), facing.m_122434_(), 3.0);
        Direction horizontal = CopycatBytePanelBlock.getHorizontal(facing);
        Direction vertical = CopycatBytePanelBlock.getVertical(facing);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (!block.partExists(pState, CopycatBytePanelBlock.getProperty(i, j))) continue;
                double h = horizontal.m_122421_() == Direction.AxisDirection.POSITIVE ? (double)(i * 8) : (double)(8 - i * 8);
                double v = vertical.m_122421_() == Direction.AxisDirection.POSITIVE ? (double)(j * 8) : (double)(8 - j * 8);
                double d = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? 13.0 : 0.0;
                Vec3 min = MathUtils.replaceAxis(MathUtils.replaceAxis(MathUtils.replaceAxis(Vec3.f_82478_, horizontal.m_122434_(), h), vertical.m_122434_(), v), facing.m_122434_(), d);
                Vec3 max = min.m_82549_(size);
                shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)min.f_82479_, (double)min.f_82480_, (double)min.f_82481_, (double)max.f_82479_, (double)max.f_82480_, (double)max.f_82481_), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return shape.m_83296_();
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Objects.requireNonNull((VoxelShape)this.shapesCache.get((Object)pState));
    }

    @Override
    public VoxelShape getPartialFaceShape(BlockGetter level, BlockState state, String property, Direction face) {
        if (!this.partExists(state, property)) {
            return Shapes.m_83040_();
        }
        return Objects.requireNonNull((VoxelShape)this.partialFaceCache.getOrDefault((Object)new FaceData(property, (Direction)state.m_61143_((Property)FACING), face), (Object)Shapes.m_83040_()));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return switch (pType) {
            case PathComputationType.LAND -> true;
            default -> false;
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        BlockState interactionState = state.m_60713_((Block)this) ? state : (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
        String property = this.getPropertyFromInteraction(interactionState, (BlockGetter)context.m_43725_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), false);
        if (state.m_60713_((Block)this)) {
            if (!((Boolean)state.m_61143_((Property)CopycatBytePanelBlock.fromProperty(property))).booleanValue()) {
                return (BlockState)state.m_61124_((Property)CopycatBytePanelBlock.fromProperty(property), (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return (BlockState)((BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)CopycatBytePanelBlock.fromProperty(property), (Comparable)Boolean.valueOf(true));
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext context) {
        ItemStack itemstack = context.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        String property = this.getPropertyFromInteraction(state, (BlockGetter)context.m_43725_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), false);
        return (Boolean)state.m_61143_((Property)CopycatBytePanelBlock.fromProperty(property)) == false;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        this.onWrenched(state, context);
        int byteCount = 0;
        for (String property : this.storageProperties()) {
            if (!((Boolean)state.m_61143_((Property)CopycatBytePanelBlock.fromProperty(property))).booleanValue()) continue;
            ++byteCount;
        }
        if (byteCount <= 1) {
            return super.onSneakWrenched(state, context);
        }
        String property = this.getPropertyFromInteraction(state, (BlockGetter)context.m_43725_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), true);
        Level level = context.m_43725_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            Player player = context.m_43723_();
            BlockPos pos = context.m_8083_();
            if (player != null) {
                List drops = Block.m_49874_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CopycatBytePanelBlock.fromProperty(property), (Comparable)Boolean.valueOf(true))), (ServerLevel)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                if (!player.m_7500_()) {
                    for (ItemStack drop : drops) {
                        player.m_150109_().m_150079_(drop);
                    }
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)CopycatBytePanelBlock.fromProperty(property), (Comparable)Boolean.valueOf(false))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound((Level)world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return IMultiStateCopycatBlock.getRequiredItemsForParts(state, BOTTOM_LEFT, BOTTOM_RIGHT, TOP_LEFT, TOP_RIGHT);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    private static BlockState flipFaceVertical(BlockState state) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)TOP_LEFT, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM_LEFT)))).m_61124_((Property)TOP_RIGHT, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM_RIGHT)))).m_61124_((Property)BOTTOM_LEFT, (Comparable)((Boolean)state.m_61143_((Property)TOP_LEFT)))).m_61124_((Property)BOTTOM_RIGHT, (Comparable)((Boolean)state.m_61143_((Property)TOP_RIGHT)));
    }

    private static void flipFaceVertical(IMultiStateCopycatBlockEntity be) {
        be.getMaterialItemStorage().remapStorage(key -> {
            if (key.equals(BOTTOM_LEFT.m_61708_())) {
                return TOP_LEFT.m_61708_();
            }
            if (key.equals(BOTTOM_RIGHT.m_61708_())) {
                return TOP_RIGHT.m_61708_();
            }
            if (key.equals(TOP_LEFT.m_61708_())) {
                return BOTTOM_LEFT.m_61708_();
            }
            if (key.equals(TOP_RIGHT.m_61708_())) {
                return BOTTOM_RIGHT.m_61708_();
            }
            return key;
        });
    }

    private static BlockState flipFaceHorizontal(BlockState state) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BOTTOM_LEFT, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM_RIGHT)))).m_61124_((Property)BOTTOM_RIGHT, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM_LEFT)))).m_61124_((Property)TOP_LEFT, (Comparable)((Boolean)state.m_61143_((Property)TOP_RIGHT)))).m_61124_((Property)TOP_RIGHT, (Comparable)((Boolean)state.m_61143_((Property)TOP_LEFT)));
    }

    private static void flipFaceHorizontal(IMultiStateCopycatBlockEntity be) {
        be.getMaterialItemStorage().remapStorage(key -> {
            if (key.equals(BOTTOM_RIGHT.m_61708_())) {
                return BOTTOM_LEFT.m_61708_();
            }
            if (key.equals(BOTTOM_LEFT.m_61708_())) {
                return BOTTOM_RIGHT.m_61708_();
            }
            if (key.equals(TOP_RIGHT.m_61708_())) {
                return TOP_LEFT.m_61708_();
            }
            if (key.equals(TOP_LEFT.m_61708_())) {
                return TOP_RIGHT.m_61708_();
            }
            return key;
        });
    }

    private static BlockState rotateFaceCounterClockwise(BlockState state) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BOTTOM_LEFT, (Comparable)((Boolean)state.m_61143_((Property)TOP_LEFT)))).m_61124_((Property)TOP_LEFT, (Comparable)((Boolean)state.m_61143_((Property)TOP_RIGHT)))).m_61124_((Property)TOP_RIGHT, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM_RIGHT)))).m_61124_((Property)BOTTOM_RIGHT, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM_LEFT)));
    }

    private static void rotateFaceCounterClockwise(IMultiStateCopycatBlockEntity be) {
        be.getMaterialItemStorage().remapStorage(key -> {
            if (key.equals(TOP_LEFT.m_61708_())) {
                return BOTTOM_LEFT.m_61708_();
            }
            if (key.equals(TOP_RIGHT.m_61708_())) {
                return TOP_LEFT.m_61708_();
            }
            if (key.equals(BOTTOM_RIGHT.m_61708_())) {
                return TOP_RIGHT.m_61708_();
            }
            if (key.equals(BOTTOM_LEFT.m_61708_())) {
                return BOTTOM_RIGHT.m_61708_();
            }
            return key;
        });
    }

    private static BlockState rotateFaceClockwise(BlockState state) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BOTTOM_LEFT, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM_RIGHT)))).m_61124_((Property)BOTTOM_RIGHT, (Comparable)((Boolean)state.m_61143_((Property)TOP_RIGHT)))).m_61124_((Property)TOP_RIGHT, (Comparable)((Boolean)state.m_61143_((Property)TOP_LEFT)))).m_61124_((Property)TOP_LEFT, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM_LEFT)));
    }

    private static void rotateFaceClockwise(IMultiStateCopycatBlockEntity be) {
        be.getMaterialItemStorage().remapStorage(key -> {
            if (key.equals(BOTTOM_RIGHT.m_61708_())) {
                return BOTTOM_LEFT.m_61708_();
            }
            if (key.equals(TOP_RIGHT.m_61708_())) {
                return BOTTOM_RIGHT.m_61708_();
            }
            if (key.equals(TOP_LEFT.m_61708_())) {
                return TOP_RIGHT.m_61708_();
            }
            if (key.equals(BOTTOM_LEFT.m_61708_())) {
                return TOP_LEFT.m_61708_();
            }
            return key;
        });
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        Direction facing;
        if (transform.mirror != null && transform.mirror != Mirror.NONE) {
            facing = (Direction)state.m_61143_((Property)FACING);
            if (transform.mirror.m_54842_() == OctahedralGroup.INVERT_Y) {
                state = CopycatBytePanelBlock.flipFaceVertical(state);
                if (facing.m_122434_().m_122478_()) {
                    state = (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
                }
            } else {
                state = facing.m_122434_().m_122479_() && transform.mirror.m_54842_().m_56526_(facing.m_122434_()) ? (BlockState)CopycatBytePanelBlock.flipFaceHorizontal(state).m_61124_((Property)FACING, (Comparable)facing.m_122424_()) : (facing.m_122434_().m_122479_() ? CopycatBytePanelBlock.flipFaceHorizontal(state) : (transform.mirror.m_54842_().m_56526_(Direction.Axis.X) ? CopycatBytePanelBlock.flipFaceHorizontal(state) : (transform.mirror.m_54842_().m_56526_(Direction.Axis.Z) ? CopycatBytePanelBlock.flipFaceVertical(state) : (BlockState)CopycatBytePanelBlock.flipFaceVertical(state).m_61124_((Property)FACING, (Comparable)facing.m_122424_()))));
            }
        }
        if (transform.rotationAxis != null && transform.rotation != Rotation.NONE) {
            facing = (Direction)state.m_61143_((Property)FACING);
            if (transform.rotationAxis.m_122478_() && facing.m_122434_().m_122479_()) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)transform.rotateFacing(facing));
            } else if (transform.rotationAxis == facing.m_122434_()) {
                if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                    for (int i = 0; i < transform.rotation.ordinal(); ++i) {
                        state = CopycatBytePanelBlock.rotateFaceClockwise(state);
                    }
                } else {
                    for (int i = 0; i < transform.rotation.ordinal(); ++i) {
                        state = CopycatBytePanelBlock.rotateFaceCounterClockwise(state);
                    }
                }
            } else if (facing.m_122434_().m_122478_()) {
                if (transform.rotation == Rotation.CLOCKWISE_180) {
                    state = transform.rotationAxis == Direction.Axis.X ? CopycatBytePanelBlock.flipFaceVertical(state) : CopycatBytePanelBlock.flipFaceHorizontal(state);
                    state = CopycatBytePanelBlock.flipFaceVertical(state);
                } else {
                    state = transform.rotationAxis == Direction.Axis.X ? (facing == Direction.DOWN && transform.rotation == Rotation.CLOCKWISE_90 || facing == Direction.UP && transform.rotation == Rotation.COUNTERCLOCKWISE_90 ? (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.SOUTH) : (BlockState)CopycatBytePanelBlock.flipFaceHorizontal(CopycatBytePanelBlock.flipFaceVertical(state)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)) : (facing == Direction.DOWN ? (transform.rotation == Rotation.CLOCKWISE_90 ? (BlockState)CopycatBytePanelBlock.rotateFaceCounterClockwise(state).m_61124_((Property)FACING, (Comparable)Direction.WEST) : (BlockState)CopycatBytePanelBlock.rotateFaceClockwise(state).m_61124_((Property)FACING, (Comparable)Direction.EAST)) : (transform.rotation == Rotation.CLOCKWISE_90 ? (BlockState)CopycatBytePanelBlock.rotateFaceCounterClockwise(state).m_61124_((Property)FACING, (Comparable)Direction.EAST) : (BlockState)CopycatBytePanelBlock.rotateFaceClockwise(state).m_61124_((Property)FACING, (Comparable)Direction.WEST)));
                }
            } else {
                state = transform.rotation == Rotation.CLOCKWISE_180 ? (BlockState)CopycatBytePanelBlock.flipFaceVertical(state).m_61124_((Property)FACING, (Comparable)facing.m_122424_()) : (transform.rotationAxis == Direction.Axis.X ? (facing == Direction.SOUTH ? (transform.rotation == Rotation.CLOCKWISE_90 ? (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.UP) : (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.DOWN)) : (transform.rotation == Rotation.CLOCKWISE_90 ? (BlockState)CopycatBytePanelBlock.flipFaceHorizontal(CopycatBytePanelBlock.flipFaceVertical(state)).m_61124_((Property)FACING, (Comparable)Direction.DOWN) : (BlockState)CopycatBytePanelBlock.flipFaceHorizontal(CopycatBytePanelBlock.flipFaceVertical(state)).m_61124_((Property)FACING, (Comparable)Direction.UP))) : (facing == Direction.EAST ? (transform.rotation == Rotation.CLOCKWISE_90 ? (BlockState)CopycatBytePanelBlock.rotateFaceCounterClockwise(state).m_61124_((Property)FACING, (Comparable)Direction.DOWN) : (BlockState)CopycatBytePanelBlock.rotateFaceClockwise(state).m_61124_((Property)FACING, (Comparable)Direction.UP)) : (transform.rotation == Rotation.CLOCKWISE_90 ? (BlockState)CopycatBytePanelBlock.rotateFaceCounterClockwise(state).m_61124_((Property)FACING, (Comparable)Direction.UP) : (BlockState)CopycatBytePanelBlock.rotateFaceClockwise(state).m_61124_((Property)FACING, (Comparable)Direction.DOWN))));
            }
        }
        return state;
    }

    @Override
    public void transformStorage(BlockState state, IMultiStateCopycatBlockEntity be, StructureTransform transform) {
        Direction facing;
        if (transform.mirror != null && transform.mirror != Mirror.NONE) {
            facing = (Direction)state.m_61143_((Property)FACING);
            if (transform.mirror.m_54842_() == OctahedralGroup.INVERT_Y) {
                CopycatBytePanelBlock.flipFaceVertical(be);
            } else if (facing.m_122434_().m_122479_() && transform.mirror.m_54842_().m_56526_(facing.m_122434_())) {
                CopycatBytePanelBlock.flipFaceHorizontal(be);
            } else if (facing.m_122434_().m_122479_()) {
                CopycatBytePanelBlock.flipFaceHorizontal(be);
            } else if (transform.mirror.m_54842_().m_56526_(Direction.Axis.X)) {
                CopycatBytePanelBlock.flipFaceHorizontal(be);
            } else if (transform.mirror.m_54842_().m_56526_(Direction.Axis.Z)) {
                CopycatBytePanelBlock.flipFaceVertical(be);
            } else {
                CopycatBytePanelBlock.flipFaceVertical(be);
            }
        }
        if (transform.rotationAxis != null && transform.rotation != Rotation.NONE) {
            facing = (Direction)state.m_61143_((Property)FACING);
            if (!transform.rotationAxis.m_122478_() || !facing.m_122434_().m_122479_()) {
                if (transform.rotationAxis == facing.m_122434_()) {
                    if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                        for (int i = 0; i < transform.rotation.ordinal(); ++i) {
                            CopycatBytePanelBlock.rotateFaceClockwise(be);
                        }
                    } else {
                        for (int i = 0; i < transform.rotation.ordinal(); ++i) {
                            CopycatBytePanelBlock.rotateFaceCounterClockwise(be);
                        }
                    }
                } else if (facing.m_122434_().m_122478_()) {
                    if (transform.rotation == Rotation.CLOCKWISE_180) {
                        if (transform.rotationAxis == Direction.Axis.X) {
                            CopycatBytePanelBlock.flipFaceVertical(be);
                        } else {
                            CopycatBytePanelBlock.flipFaceHorizontal(be);
                        }
                        CopycatBytePanelBlock.flipFaceVertical(be);
                    } else if (transform.rotationAxis == Direction.Axis.X) {
                        if (!(facing == Direction.UP && transform.rotation == Rotation.CLOCKWISE_90 || facing == Direction.DOWN && transform.rotation == Rotation.COUNTERCLOCKWISE_90)) {
                            CopycatBytePanelBlock.flipFaceVertical(be);
                            CopycatBytePanelBlock.flipFaceHorizontal(be);
                        }
                    } else if (transform.rotation == Rotation.CLOCKWISE_90) {
                        CopycatBytePanelBlock.rotateFaceCounterClockwise(be);
                    } else {
                        CopycatBytePanelBlock.rotateFaceClockwise(be);
                    }
                } else if (transform.rotation == Rotation.CLOCKWISE_180) {
                    CopycatBytePanelBlock.flipFaceVertical(be);
                } else if (transform.rotationAxis == Direction.Axis.X) {
                    if (facing != Direction.SOUTH) {
                        CopycatBytePanelBlock.flipFaceVertical(be);
                        CopycatBytePanelBlock.flipFaceHorizontal(be);
                    }
                } else if (transform.rotation == Rotation.CLOCKWISE_90) {
                    CopycatBytePanelBlock.rotateFaceCounterClockwise(be);
                } else {
                    CopycatBytePanelBlock.rotateFaceClockwise(be);
                }
            }
        }
    }

    public static BooleanProperty fromProperty(String property) {
        if (property.equals(BOTTOM_LEFT.m_61708_())) {
            return BOTTOM_LEFT;
        }
        if (property.equals(BOTTOM_RIGHT.m_61708_())) {
            return BOTTOM_RIGHT;
        }
        if (property.equals(TOP_LEFT.m_61708_())) {
            return TOP_LEFT;
        }
        if (property.equals(TOP_RIGHT.m_61708_())) {
            return TOP_RIGHT;
        }
        throw new RuntimeException("Invalid property: " + property);
    }

    public static String getProperty(int horizontal, int vertical) {
        if (horizontal == 0 && vertical == 0) {
            return BOTTOM_RIGHT.m_61708_();
        }
        if (horizontal == 1 && vertical == 0) {
            return BOTTOM_LEFT.m_61708_();
        }
        if (horizontal == 0 && vertical == 1) {
            return TOP_RIGHT.m_61708_();
        }
        if (horizontal == 1 && vertical == 1) {
            return TOP_LEFT.m_61708_();
        }
        throw new RuntimeException("Invalid horizontal and vertical values: " + horizontal + ", " + vertical);
    }

    public static Vector2i getVector(String property) {
        if (property.equals(BOTTOM_RIGHT.m_61708_())) {
            return new Vector2i(0, 0);
        }
        if (property.equals(BOTTOM_LEFT.m_61708_())) {
            return new Vector2i(1, 0);
        }
        if (property.equals(TOP_RIGHT.m_61708_())) {
            return new Vector2i(0, 1);
        }
        if (property.equals(TOP_LEFT.m_61708_())) {
            return new Vector2i(1, 1);
        }
        throw new RuntimeException("Invalid property: " + property);
    }

    public static Direction getHorizontal(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> Direction.EAST;
            case Direction.UP -> Direction.EAST;
            case Direction.NORTH -> Direction.WEST;
            case Direction.SOUTH -> Direction.EAST;
            case Direction.EAST -> Direction.NORTH;
            case Direction.WEST -> Direction.SOUTH;
        };
    }

    public static Direction getVertical(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> Direction.SOUTH;
            case Direction.UP -> Direction.NORTH;
            case Direction.NORTH -> Direction.UP;
            case Direction.SOUTH -> Direction.UP;
            case Direction.EAST -> Direction.UP;
            case Direction.WEST -> Direction.UP;
        };
    }

    public record FaceData(String property, Direction facing, Direction direction) {
    }
}

