/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.category;

import com.google.common.collect.ImmutableList;
import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.config.Config;
import io.github.mortuusars.sootychimneys.integration.jei.JeiRecipeTypes;
import io.github.mortuusars.sootychimneys.integration.jei.recipe.SootScrapingWithLootTablesJeiRecipe;
import io.github.mortuusars.sootychimneys.integration.jei.renderer.ScalableItemStackRenderer;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SootScrapingWithLootTablesRecipeCategory
implements IRecipeCategory<SootScrapingWithLootTablesJeiRecipe> {
    public static final int BG_WIDTH = 153;
    public static final int BG_HEIGHT = 65;
    private final List<Component> BYPRODUCT_ITEMS_INFO = ImmutableList.of((Object)Component.m_237115_((String)"jei.sootychimneys.category.soot_scraping.soot_items_info"));
    private final Component title = Component.m_237115_((String)"jei.sootychimneys.category.soot_scraping");
    private final IDrawable background;
    private final IDrawableStatic icon;
    private final IDrawableStatic byproductInfo;
    private final int byproductXPos = 70;
    private final int byproductYPos = 37;

    public SootScrapingWithLootTablesRecipeCategory(IGuiHelper helper) {
        ResourceLocation texture = SootyChimneys.resource("textures/gui/jei/soot_scraping.png");
        this.background = helper.createDrawable(texture, 0, 0, 153, 65);
        this.icon = helper.drawableBuilder(SootyChimneys.resource("textures/gui/jei/soot_scraping_icon.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.byproductInfo = helper.createDrawable(texture, 153, 0, 14, 25);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SootScrapingWithLootTablesJeiRecipe recipe, @NotNull IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 9, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).addItemStack(recipe.getIngredientChimney())).setSlotName("DirtyChimney");
        builder.addSlot(RecipeIngredientRole.CATALYST, 44, 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, recipe.getTools());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 104, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).addItemStack(recipe.getResultChimney())).setSlotName("CleanChimney");
    }

    public void draw(@NotNull SootScrapingWithLootTablesJeiRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (((Boolean)Config.DISPLAY_JEI_SCRAPING_BYPRODUCTS_INFO.get()).booleanValue()) {
            this.byproductInfo.draw(guiGraphics, 70, 37);
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull SootScrapingWithLootTablesJeiRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (((Boolean)Config.DISPLAY_JEI_SCRAPING_BYPRODUCTS_INFO.get()).booleanValue() && mouseX >= 70.0 && mouseX < (double)(70 + this.byproductInfo.getWidth()) && mouseY >= 37.0 && mouseY < (double)(37 + this.byproductInfo.getHeight())) {
            return this.BYPRODUCT_ITEMS_INFO;
        }
        return Collections.emptyList();
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public RecipeType<SootScrapingWithLootTablesJeiRecipe> getRecipeType() {
        return JeiRecipeTypes.SOOT_SCRAPING_LOOT_TABLES;
    }
}

