/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.net;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.net.AbstractIdentifiableRequestPacket;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkChannel;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class NetworkManagerBase {
    public static final int NETWORK_CALLBACK_TIMEOUT = 30000;
    public final NetworkChannel CHANNEL;
    @Deprecated(forRemoval=true)
    private static final Map<UUID, NetworkCallback> networkCallbacks = new HashMap<UUID, NetworkCallback>();

    public <T extends IPacketBase<T>> NetworkManagerBase(String modid, String networkChannel, Collection<Class<? extends IPacketBase<?>>> classes) {
        this.CHANNEL = NetworkChannel.create((ResourceLocation)new ResourceLocation(modid, networkChannel));
        classes.forEach(c -> {
            try {
                Class clazz = c;
                IPacketBase packet = (IPacketBase)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.CHANNEL.register(clazz, packet::encode, packet::decode, packet::handle);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                DragonLib.LOGGER.error("Unable to register packet.", (Throwable)e);
            }
        });
    }

    @Deprecated(forRemoval=true)
    public <T extends AbstractIdentifiableRequestPacket<T>> void sendAndAwait(T requestPacket, BiConsumer<CompoundTag, Long> callback) {
        UUID id;
        while (networkCallbacks.containsKey(id = UUID.randomUUID())) {
        }
        networkCallbacks.put(id, new NetworkCallback(System.currentTimeMillis(), callback));
        requestPacket.id = id;
        this.CHANNEL.sendToServer(requestPacket);
    }

    @Deprecated(forRemoval=true)
    public static void executeCallback(UUID id, CompoundTag nbt, long time) {
        if (networkCallbacks.containsKey(id)) {
            networkCallbacks.remove(id).callback().accept(nbt, time);
        }
    }

    @Deprecated(forRemoval=true)
    public void clearCallbacks() {
        networkCallbacks.clear();
    }

    @Deprecated(forRemoval=true)
    public static void callbackListenerTick() {
        networkCallbacks.entrySet().removeIf(t -> ((NetworkCallback)t.getValue()).creationTime() < System.currentTimeMillis() - 30000L);
    }

    @Deprecated(forRemoval=true)
    private record NetworkCallback(long creationTime, BiConsumer<CompoundTag, Long> callback) {
    }
}

