/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.data;

import de.mrjulsen.mcdragonlib.DragonLib;
import dev.architectury.platform.Platform;
import java.util.Arrays;
import net.minecraftforge.api.distmarker.Dist;

public enum EnvSide {
    SERVER(0, "server"),
    CLIENT(1, "client"),
    BOTH(99, "both");

    byte index;
    String name;

    private EnvSide(byte index, String name) {
        this.index = index;
        this.name = name;
    }

    public byte getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public static EnvSide getByIndex(int index) {
        return Arrays.stream(EnvSide.values()).filter(x -> x.getIndex() == index).findFirst().orElse(SERVER);
    }

    public static EnvSide current() {
        boolean env;
        boolean hasServer = DragonLib.hasServer();
        boolean bl = env = Platform.getEnv() == Dist.CLIENT;
        return hasServer && env ? BOTH : (hasServer ? SERVER : CLIENT);
    }
}

