/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DLListBox<T>
extends DLWidgetContainer
implements Collection<DLListBoxItem<T>> {
    private int itemHeight = 16;
    private boolean multiselect;
    private Consumer<DLListBox<T>> onSelectionChanged;
    private Consumer<DLListBox<T>> onItemsChanged;
    private final DLVerticalScrollBar scrollBar;
    private final DLListBoxContainer<T> container;

    public DLListBox(int x, int y, int width, int height, boolean multiselect) {
        super(x, y, width, height);
        this.multiselect = multiselect;
        this.scrollBar = this.addRenderableWidget(new DLVerticalScrollBar(this.getX() + this.getWidth() - 9, this.getY() + 1, 8, this.getHeight() - 2, GuiAreaDefinition.of(this)));
        this.container = this.addRenderableWidget(new DLListBoxContainer(this.getX() + 1, this.getY() + 1, this.getWidth() - 10, this.getHeight() - 2));
        this.scrollBar.setScreenSize(this.getHeight());
        this.scrollBar.setMaxScroll(0);
        this.scrollBar.setStepSize(8);
        this.scrollBar.setAutoScrollerSize(true);
        this.scrollBar.withOnValueChanged(bar -> this.container.setYScrollOffset(bar.getScrollValue()));
    }

    public DLListBox<T> withItemHeight(int height) {
        this.itemHeight = height;
        return this;
    }

    public DLListBox<T> withOnSelectionChangedEvent(Consumer<DLListBox<T>> onSelectionChanged) {
        this.onSelectionChanged = onSelectionChanged;
        return this;
    }

    public DLListBox<T> withOnItemsChangedEvent(Consumer<DLListBox<T>> onItemsChanged) {
        this.onItemsChanged = onItemsChanged;
        return this;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public boolean allowsMultiselect() {
        return this.multiselect;
    }

    public void setMultiselectable(boolean b) {
        this.multiselect = b;
    }

    public DLVerticalScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public List<DLListBoxItem<T>> getSelectedItems() {
        return this.container.m_6702_().stream().filter(x -> {
            DLListBoxItem item;
            return x instanceof DLListBoxItem && (item = (DLListBoxItem)x).isSelected();
        }).map(x -> (DLListBoxItem)x).toList();
    }

    public int getSelectedCount() {
        return this.getSelectedItems().size();
    }

    public Collection<DLListBoxItem<T>> getItems() {
        return this.container.m_6702_().stream().filter(x -> x instanceof DLListBoxItem).map(x -> (DLListBoxItem)x).toList();
    }

    @Override
    public int size() {
        return this.getItems().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.getItems().contains(o);
    }

    @Override
    public Iterator<DLListBoxItem<T>> iterator() {
        return this.getItems().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getItems().toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        return this.getItems().toArray(a);
    }

    public DLListBoxItem<T> add(DLListBoxItemBuilder<T> builder) {
        DLListBoxItem<T> item = this.container.addRenderableWidget(builder.build(this));
        DLUtils.doIfNotNull(this.onItemsChanged, x -> x.accept(this));
        this.scrollBar.setMaxScroll(this.itemHeight * this.size() + 2);
        return item;
    }

    @Override
    @Deprecated(forRemoval=true)
    public boolean add(DLListBoxItem<T> e) {
        throw new IllegalAccessError("You cannot add a DLListBoxItems directly. Use the DLListBoxItemBuilder instead.");
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof DLListBoxItem) {
            DLListBoxItem l = (DLListBoxItem)o;
            this.container.removeWidget((GuiEventListener)l);
            DLUtils.doIfNotNull(this.onItemsChanged, x -> x.accept(this));
            this.scrollBar.setMaxScroll(this.itemHeight * this.size() + 2);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(x -> this.contains(x));
    }

    @Override
    @Deprecated(forRemoval=true)
    public boolean addAll(Collection<? extends DLListBoxItem<T>> c) {
        throw new IllegalAccessError("You cannot add a DLListBoxItems directly. Use the DLListBoxItemBuilder instead.");
    }

    public boolean addAllItems(Collection<DLListBoxItemBuilder<T>> c) {
        c.forEach(x -> this.add((DLListBoxItemBuilder<T>)x));
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return c.stream().allMatch(x -> this.remove(x));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.getItems().stream().filter(x -> !c.contains(x)).forEach(x -> this.remove(x));
        return true;
    }

    @Override
    public void clear() {
        this.getItems().forEach(x -> this.remove(x));
        DLUtils.doIfNotNull(this.onItemsChanged, x -> x.accept(this));
        this.scrollBar.setMaxScroll(this.itemHeight * this.size() + 2);
    }

    public void checkSelection(DLListBoxItem<T> selected) {
        if (!this.multiselect) {
            this.getItems().stream().filter(x -> x != selected).forEach(x -> x.setSelected(false));
        }
        DLUtils.doIfNotNull(this.onSelectionChanged, x -> x.accept(this));
    }

    @Override
    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        DynamicGuiRenderer.renderArea(graphics, this.getX(), this.getY(), this.getWidth(), this.getHeight(), -10066330, DynamicGuiRenderer.AreaStyle.GRAY, DynamicGuiRenderer.ButtonState.DOWN);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public boolean consumeScrolling(double mouseX, double mouseY) {
        return true;
    }

    private static class DLListBoxContainer<T>
    extends DLScrollableWidgetContainer {
        public DLListBoxContainer(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput var1) {
        }

        @Override
        public boolean consumeScrolling(double mouseX, double mouseY) {
            return false;
        }
    }

    public record DLListBoxItemBuilder<T>(Component text, Sprite icon, T data, Consumer<DLListBoxItem<T>> onClick) {
        public DLListBoxItem<T> build(DLListBox<T> parent) {
            return new DLListBoxItem<T>(parent, this.text, this.icon, this.data, item -> {
                parent.checkSelection((DLListBoxItem<T>)item);
                this.onClick.accept((DLListBoxItem<DLListBoxItem>)item);
            });
        }
    }

    public static class DLListBoxItem<T>
    extends DLButton {
        protected final DLListBox<T> parent;
        protected final T data;
        protected Sprite icon;
        protected boolean useCustomRenderer = true;
        protected boolean selected;

        public DLListBoxItem(DLListBox<T> parent, Component pMessage, Sprite icon, T data, Consumer<DLListBoxItem<T>> pOnPress) {
            super(parent.getX() + 1, parent.getY() + 1 + parent.size() * parent.getItemHeight(), parent.getWidth() - 2 - parent.getScrollBar().m_5711_(), parent.getItemHeight(), pMessage, btn -> {
                DLListBoxItem self;
                self.setSelected(!(self = (DLListBoxItem)btn).isSelected());
                pOnPress.accept(self);
            });
            this.parent = parent;
            this.data = data;
            this.icon = icon;
        }

        @Override
        public void setRenderStyle(DynamicGuiRenderer.AreaStyle style) {
            super.setRenderStyle(style);
            this.setUsingCustomRenderer(false);
        }

        public DLListBox<T> getParent() {
            return this.parent;
        }

        public T getData() {
            return this.data;
        }

        public Sprite getIcon() {
            return this.icon;
        }

        public boolean isUsingCustomRenderer() {
            return this.useCustomRenderer;
        }

        public void setUsingCustomRenderer(boolean b) {
            this.useCustomRenderer = b;
        }

        public void setIcon(Sprite icon) {
            this.icon = icon;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean b) {
            this.selected = b;
        }

        @Override
        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
            if (this.isUsingCustomRenderer()) {
                if (this.isSelected()) {
                    GuiUtils.drawBox(graphics, GuiAreaDefinition.of(this), -16777216, -6381922);
                }
                if (this.isMouseSelected()) {
                    GuiUtils.fill(graphics, this.x(), this.y(), this.width(), this.height(), 0x33FFFFFF);
                }
            } else {
                DynamicGuiRenderer.renderArea(graphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.getBackColor(), this.style, this.m_142518_() ? (this.isSelected() ? DynamicGuiRenderer.ButtonState.DOWN : (this.m_93696_() || this.isMouseSelected() ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON)) : DynamicGuiRenderer.ButtonState.DISABLED);
            }
            int xCoord = this.x() + this.height() / 2 - this.getIcon().getWidth() / 2;
            this.getIcon().render(graphics, xCoord, this.y() + this.m_93694_() / 2 - this.getIcon().getHeight() / 2);
            int n = xCoord + this.getIcon().getWidth() + 5;
            int n2 = this.y() + this.m_93694_() / 2;
            Objects.requireNonNull(this.font);
            GuiUtils.drawString(graphics, this.font, n, n2 - 9 / 2, (FormattedText)this.m_6035_(), this.isSelected() || this.isMouseSelected() ? -96 : -1, EAlignment.LEFT, false);
        }
    }
}

