/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ITickable;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLItemButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLSlider;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.mixin.AbstractWidgetAccessor;
import de.mrjulsen.mcdragonlib.mixin.ScreenAccessor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class DLContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IDragonLibContainer<DLContainerScreen<T>> {
    protected final List<DLTooltip> tooltips = new ArrayList<DLTooltip>();
    protected DLContextMenu contextMenu;
    private boolean mouseSelected;
    private int allowedLayerIndex = 0;
    private int layerIndex = 0;
    public final Consumer<DLButton> NO_BUTTON_CLICK_ACTION = a -> {};
    public final BiConsumer<DLCycleButton<?>, ?> NO_CYCLE_BUTTON_VALUE_CHANGE_ACTION = (a, b) -> {};
    public final BiConsumer<DLEditBox, Boolean> NO_EDIT_BOX_FOCUS_CHANGE_ACTION = (a, b) -> {};
    public final BiConsumer<DLSlider, Double> NO_SLIDER_CHANGE_VALUE_ACTION = (a, b) -> {};

    public DLContainerScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    public void renderScreenBackground(Graphics graphics) {
        this.m_280273_(graphics.graphics());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tooltips.clear();
    }

    public void m_7861_() {
        super.m_7861_();
        try {
            this.close();
        }
        catch (Exception e) {
            DragonLib.LOGGER.error("Error while closing gui object.", (Throwable)e);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        this.f_169369_.stream().filter(x -> x instanceof ITickable).forEach(x -> ((ITickable)x).m_94120_());
    }

    protected void onDone() {
    }

    @Override
    public void renderBackLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable widget : this.f_169369_) {
            IDragonLibWidget layeredWidget;
            if (!(widget instanceof IDragonLibWidget) || !(layeredWidget = (IDragonLibWidget)widget).visible() || this.checkWidgetBounds() && !DLUtils.rectanglesIntersecting(layeredWidget.x(), layeredWidget.y(), layeredWidget.width(), layeredWidget.height(), (double)this.x() + (Double)this.checkWidgetBoundsOffset().getFirst(), (double)this.y() + (Double)this.checkWidgetBoundsOffset().getSecond(), this.width(), this.height())) continue;
            layeredWidget.renderBackLayer(graphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable widget : this.f_169369_) {
            IDragonLibWidget layeredWidget;
            if (!(widget instanceof IDragonLibWidget) || !(layeredWidget = (IDragonLibWidget)widget).visible() || this.checkWidgetBounds() && !DLUtils.rectanglesIntersecting(layeredWidget.x(), layeredWidget.y(), layeredWidget.width(), layeredWidget.height(), (double)this.x() + (Double)this.checkWidgetBoundsOffset().getFirst(), (double)this.y() + (Double)this.checkWidgetBoundsOffset().getSecond(), this.width(), this.height())) continue;
            layeredWidget.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        }
        DLItemButton.renderAllItemButtonTooltips((Screen)this, graphics, mouseX, mouseY);
        this.tooltips.forEach(x -> x.render((Screen)this, graphics, mouseX, mouseY));
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_(0.0f, 0.0f, 1000.0f);
        if (this.getContextMenu() != null) {
            IDragonLibContainer.super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        }
        graphics.poseStack().m_85849_();
    }

    @Override
    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Renderable widget : this.f_169369_) {
            IDragonLibWidget d;
            if (widget instanceof IDragonLibWidget && (!(d = (IDragonLibWidget)widget).visible() || this.checkWidgetBounds() && !DLUtils.rectanglesIntersecting(d.x(), d.y(), d.width(), d.height(), (double)this.x() + (Double)this.checkWidgetBoundsOffset().getFirst(), (double)this.y() + (Double)this.checkWidgetBoundsOffset().getSecond(), this.width(), this.height()))) continue;
            if (widget instanceof AbstractWidget) {
                AbstractWidget abs = (AbstractWidget)widget;
                if (!abs.f_93624_ || this.checkWidgetBounds() && !DLUtils.rectanglesIntersecting(abs.m_252754_(), abs.m_252907_(), abs.m_5711_(), abs.m_93694_(), (double)this.x() + (Double)this.checkWidgetBoundsOffset().getFirst(), (double)this.y() + (Double)this.checkWidgetBoundsOffset().getSecond(), this.width(), this.height())) continue;
            }
            widget.m_88315_(graphics.graphics(), mouseX, mouseY, partialTicks);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.mouseSelectEvent(mouseX, mouseY);
        Graphics graphics = new Graphics(guiGraphics, guiGraphics.m_280168_());
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_(0.0f, 0.0f, -100.0f);
        this.renderBackLayer(graphics, mouseX, mouseY, partialTick);
        graphics.poseStack().m_85849_();
        this.renderMainLayer(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.contextMenuMouseClickEvent((Screen)this, this, (int)mouseX, (int)mouseY, 0, 0, button, GuiAreaDefinition.of(this))) {
            return true;
        }
        ListIterator iterator = this.childrenLayered().listIterator(this.childrenLayered().size());
        while (iterator.hasPrevious()) {
            GuiEventListener guiEventListener = (GuiEventListener)iterator.previous();
            if (!guiEventListener.m_6375_(mouseX, mouseY, button)) continue;
            this.m_7522_(guiEventListener);
            if (button == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        return this.getChildAtImpl((int)mouseX, (int)mouseY);
    }

    public <W extends GuiEventListener & Renderable> W m_142416_(W widget) {
        return (W)super.m_142416_(widget);
    }

    public <W extends Renderable> W m_169394_(W widget) {
        return (W)super.m_169394_(widget);
    }

    public <W extends GuiEventListener & NarratableEntry> W m_7787_(W guiEventListener) {
        return (W)super.m_7787_(guiEventListener);
    }

    public void m_169411_(GuiEventListener listener) {
        super.m_169411_(listener);
    }

    public void m_169413_() {
        super.m_169413_();
    }

    protected DLTooltip addTooltip(DLTooltip tooltip) {
        this.tooltips.add(tooltip);
        return tooltip;
    }

    protected boolean removeTooltips(Predicate<? super DLTooltip> condition) {
        return this.tooltips.removeIf(condition);
    }

    protected DLButton addButton(int x, int y, int width, int height, Component text, Consumer<DLButton> onClick, DLTooltip tooltip) {
        DLButton btn = GuiUtils.createButton(x, y, width, height, text, onClick);
        return this.addRenderableWidget(btn, x, y, width, height, tooltip);
    }

    protected <E extends Enum<E>> DLCycleButton<E> addCycleButton(String modid, Class<E> clazz, int x, int y, int width, int height, Component text, E initialValue, BiConsumer<DLCycleButton<?>, E> onValueChanged, DLTooltip tooltip) {
        DLCycleButton<E> btn = GuiUtils.createCycleButton(modid, clazz, x, y, width, height, text, initialValue, onValueChanged);
        return this.addRenderableWidget((AbstractWidget)btn, x, y, width, height, tooltip);
    }

    protected DLCycleButton<Boolean> addOnOffButton(int x, int y, int width, int height, Component text, boolean initialValue, BiConsumer<DLCycleButton<?>, Boolean> onValueChanged, DLTooltip tooltip) {
        DLCycleButton<Boolean> btn = GuiUtils.createOnOffButton(x, y, width, height, text, initialValue, onValueChanged);
        return this.addRenderableWidget((AbstractWidget)btn, x, y, width, height, tooltip);
    }

    protected DLEditBox addEditBox(int x, int y, int width, int height, String text, Component hint, boolean drawBg, Consumer<String> onValueChanged, BiConsumer<DLEditBox, Boolean> onFocusChanged, DLTooltip tooltip) {
        DLEditBox box = GuiUtils.createEditBox(x, y, width, height, this.f_96547_, text, hint, drawBg, onValueChanged, onFocusChanged);
        return this.addRenderableWidget(box, x, y, width, height, tooltip);
    }

    protected DLSlider addSlider(int x, int y, int width, int height, Component prefix, Component suffix, double min, double max, double step, double initialValue, boolean drawLabel, BiConsumer<DLSlider, Double> onValueChanged, Consumer<DLSlider> onUpdateMessage, DLTooltip tooltip) {
        DLSlider slider = GuiUtils.createSlider(x, y, width, height, prefix, suffix, min, max, step, initialValue, drawLabel, onValueChanged, onUpdateMessage);
        return this.addRenderableWidget(slider, x, y, width, height, tooltip);
    }

    protected <W extends AbstractWidget> W addRenderableWidget(W widget, int x, int y, int width, int height, DLTooltip tooltip) {
        if (tooltip != null && !tooltip.equals(DLTooltip.empty())) {
            this.addTooltip(tooltip.assignedTo(widget));
        }
        widget.m_252865_(x);
        widget.m_253211_(y);
        widget.m_93674_(width);
        ((AbstractWidgetAccessor)widget).dragonlib$setHeight(height);
        return this.m_142416_(widget);
    }

    public static void setScreen(DLScreen screen) {
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    public boolean m_6050_(double mouseX, double mouseY, double pDelta) {
        return this.containerMouseScrolled(mouseX, mouseY, pDelta);
    }

    public void m_7522_(GuiEventListener guiEventListener) {
        IDragonLibWidget w;
        GuiEventListener guiEventListener2;
        boolean sameWidget;
        boolean bl = sameWidget = this.m_7222_() == guiEventListener;
        if (this.m_7222_() != null && !sameWidget && (guiEventListener2 = this.m_7222_()) instanceof IDragonLibWidget) {
            w = (IDragonLibWidget)guiEventListener2;
            w.onFocusChangeEvent(false);
        }
        super.m_7522_(guiEventListener);
        if (this.m_7222_() != null && !sameWidget && (guiEventListener2 = this.m_7222_()) instanceof IDragonLibWidget) {
            w = (IDragonLibWidget)guiEventListener2;
            w.onFocusChangeEvent(true);
        }
    }

    @Override
    public void onFocusChangeEvent(boolean focus) {
        if (!focus) {
            this.childrenLayered().stream().filter(x -> x instanceof IDragonLibWidget).forEach(x -> ((IDragonLibWidget)x).onFocusChangeEvent(false));
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        FocusNavigationEvent.TabNavigation focusNavigationEvent = switch (keyCode) {
            case 258 -> ((ScreenAccessor)((Object)this)).dragonlib$createTabEvent();
            default -> null;
            case 262 -> ((ScreenAccessor)((Object)this)).dragonlib$createArrowEvent(ScreenDirection.RIGHT);
            case 263 -> ((ScreenAccessor)((Object)this)).dragonlib$createArrowEvent(ScreenDirection.LEFT);
            case 264 -> ((ScreenAccessor)((Object)this)).dragonlib$createArrowEvent(ScreenDirection.DOWN);
            case 265 -> ((ScreenAccessor)((Object)this)).dragonlib$createArrowEvent(ScreenDirection.UP);
        };
        if (focusNavigationEvent != null) {
            ComponentPath componentPath = this.m_264064_((FocusNavigationEvent)focusNavigationEvent);
            if (componentPath == null && focusNavigationEvent instanceof FocusNavigationEvent.TabNavigation) {
                ((ScreenAccessor)((Object)this)).dragonlib$clearFocus();
                componentPath = this.m_264064_((FocusNavigationEvent)focusNavigationEvent);
            }
            if (componentPath != null) {
                this.m_264158_(componentPath);
            }
        }
        return false;
    }

    public ComponentPath m_264064_(FocusNavigationEvent event) {
        return this.dragonlib$nextFocusPath(event);
    }

    @Override
    public DLContextMenu getContextMenu() {
        return this.contextMenu;
    }

    @Override
    public void setMenu(DLContextMenu contextMenu) {
        this.contextMenu = contextMenu;
    }

    @Override
    public int getAllowedLayer() {
        return this.allowedLayerIndex;
    }

    @Override
    public void setAllowedLayer(int index) {
        this.allowedLayerIndex = index;
    }

    @Override
    public void setWidgetLayerIndex(int layerIndex) {
        this.layerIndex = layerIndex;
    }

    @Override
    public int getWidgetLayerIndex() {
        return this.layerIndex;
    }

    @Override
    public boolean isMouseSelected() {
        return this.mouseSelected;
    }

    @Override
    public void setMouseSelected(boolean selected) {
        this.mouseSelected = selected;
    }

    @Override
    public int x() {
        return 0;
    }

    @Override
    public int y() {
        return 0;
    }

    @Override
    public void set_x(int x) {
    }

    @Override
    public void set_y(int y) {
    }

    @Override
    public void set_width(int w) {
    }

    @Override
    public void set_height(int h) {
    }

    @Override
    public void set_visible(boolean b) {
    }

    @Override
    public boolean visible() {
        return true;
    }

    @Override
    public void set_active(boolean b) {
    }

    @Override
    public boolean active() {
        return true;
    }

    @Override
    public int width() {
        return this.f_96543_;
    }

    @Override
    public int height() {
        return this.f_96544_;
    }

    @Override
    public boolean consumeScrolling(double mouseX, double mouseY) {
        return true;
    }

    @Override
    public void close() throws Exception {
        this.m_6702_().stream().filter(x -> x instanceof AutoCloseable || x instanceof IDragonLibContainer).forEach(x -> {
            try {
                if (x instanceof AutoCloseable) {
                    AutoCloseable c = (AutoCloseable)x;
                    c.close();
                } else if (x instanceof IDragonLibContainer) {
                    IDragonLibContainer c = (IDragonLibContainer)x;
                    c.close();
                }
            }
            catch (Exception e) {
                DragonLib.LOGGER.error("Error while closing gui object.", (Throwable)e);
            }
        });
    }
}

