/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.ber;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Axis;
import de.mrjulsen.mcdragonlib.client.ber.BERQuad;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.data.Pair;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BERCube {
    private float width;
    private float height;
    private float depth;
    private BERQuad[] quads = new BERQuad[6];

    public BERCube(float width, float height, float depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public static BERCube fullCube(ResourceLocation texture, float width, float height, float depth) {
        return BERCube.cube(texture, width, height, depth, dir -> true, dir -> Pair.of(new Vec2(0.0f, 0.0f), new Vec2(1.0f, 1.0f)));
    }

    public static BERCube cube(ResourceLocation texture, float width, float height, float depth, Predicate<Direction> directionCheck, Function<Direction, Pair<Vec2, Vec2>> uv) {
        BERCube cube = new BERCube(width, height, depth);
        for (Direction dir : Direction.values()) {
            if (!directionCheck.test(dir)) continue;
            Pair<Vec2, Vec2> pair = uv.apply(dir);
            cube.setQuad(texture, dir, ((Vec2)pair.getFirst()).f_82470_, ((Vec2)pair.getFirst()).f_82471_, pair.getSecond().f_82470_, pair.getSecond().f_82471_);
        }
        return cube;
    }

    public BERQuad setQuad(ResourceLocation texture, Direction facing, float u0, float v0, float u1, float v1) {
        float w = 0.0f;
        float h = 0.0f;
        float z = 0.0f;
        Quaternionf rot = Axis.f_252436_.m_252977_(0.0f);
        switch (facing) {
            case EAST: {
                w = this.depth;
                h = this.height;
                z = this.width;
                rot = Axis.f_252436_.m_252977_(90.0f);
                break;
            }
            case WEST: {
                w = this.depth;
                h = this.height;
                z = this.width;
                rot = Axis.f_252436_.m_252977_(270.0f);
                break;
            }
            case UP: {
                w = this.width;
                h = this.depth;
                z = this.height;
                rot = Axis.f_252529_.m_252977_(90.0f);
                break;
            }
            case DOWN: {
                w = this.width;
                h = this.depth;
                z = this.height;
                rot = Axis.f_252495_.m_252977_(90.0f);
                break;
            }
            case SOUTH: {
                w = this.width;
                h = this.height;
                z = this.depth;
                break;
            }
            default: {
                w = this.width;
                h = this.height;
                z = this.depth;
                rot = Axis.f_252436_.m_252977_(180.0f);
            }
        }
        BERQuad quad = new BERQuad(texture, w, h, u0, v0, u1, v1, facing);
        quad.setRotation(rot);
        quad.setTranslate(new Vector3f(-w / 2.0f, -h / 2.0f, z / 2.0f));
        this.quads[facing.m_122411_()] = quad;
        return quad;
    }

    public void setAmbienOcclusion(boolean b) {
        for (BERQuad quad : this.quads) {
            if (quad == null) continue;
            quad.setAmbientOcclusion(b);
        }
    }

    public void setLight(int light) {
        for (BERQuad quad : this.quads) {
            if (quad == null) continue;
            quad.setLight(light);
        }
    }

    public void setTint(int tint) {
        for (BERQuad quad : this.quads) {
            if (quad == null) continue;
            quad.setTint(tint);
        }
    }

    public void addQuadPx(ResourceLocation texture, float width, float height, int u0, int v0, int u1, int v1, int textureWidth, int textureHeight, Direction facing) {
        this.quads[facing.m_122411_()] = new BERQuad(texture, BERUtils.bpx(width), BERUtils.bpx(width), BERUtils.px(u0, textureWidth), BERUtils.px(v0, textureHeight), BERUtils.px(u1, textureWidth), BERUtils.px(v1, textureHeight), facing);
    }

    public BERQuad getQuadFor(Direction facing) {
        return this.quads[facing.m_122411_()];
    }

    public ImmutableList<BERQuad> getAllQuads() {
        return ImmutableList.copyOf((Object[])this.quads);
    }

    public void render(RenderGraphics graphics) {
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_(this.width / 2.0f, this.height / 2.0f, this.depth / 2.0f);
        for (BERQuad quad : this.quads) {
            if (quad == null) continue;
            quad.render(graphics);
        }
        graphics.poseStack().m_85849_();
    }
}

