/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import de.mrjulsen.mcdragonlib.DragonLibCrossPlatform;
import de.mrjulsen.mcdragonlib.client.OverlayManager;
import de.mrjulsen.mcdragonlib.client.gui.DLOverlayScreen;
import de.mrjulsen.mcdragonlib.compat.CompatManager;
import de.mrjulsen.mcdragonlib.config.ModCommonConfig;
import de.mrjulsen.mcdragonlib.internal.ClientWrapper;
import de.mrjulsen.mcdragonlib.internal.DragonLibBlock;
import de.mrjulsen.mcdragonlib.internal.DragonLibBlockEntity;
import de.mrjulsen.mcdragonlib.net.NetworkManagerBase;
import de.mrjulsen.mcdragonlib.net.builtin.IdentifiableResponsePacketBase;
import de.mrjulsen.mcdragonlib.net.builtin.WritableSignPacket;
import de.mrjulsen.mcdragonlib.util.ScheduledTask;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.BasicDataAccessorPacket;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessorResponsePacket;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragonLib {
    public static final String MODID = "dragonlib";
    public static final String MOD_NAME = "DragonLib";
    public static final String MRJULSEN_DISCORD = "https://discord.gg/AeSbNgvc7f";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"DragonLib");
    public static final Random RANDOM = new Random();
    public static final Gson GSON = new Gson();
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    @Deprecated(forRemoval=true)
    public static final int TICKS_PER_DAY = 24000;
    @Deprecated(forRemoval=true)
    public static final int TICKS_PER_INGAME_HOUR = 1000;
    @Deprecated(forRemoval=true)
    public static final int DAYTIME_SHIFT = 6000;
    @Deprecated(forRemoval=true)
    public static final byte TPS = 20;
    @Deprecated(forRemoval=true)
    public static final int TICKS_PER_REAL_LIFE_DAY = 1728000;
    public static final int MS_PER_REAL_LIFE_DAY = 86400000;
    public static final float PIXEL = 0.0625f;
    public static final ResourceLocation UI = new ResourceLocation("dragonlib", "textures/gui/ui.png");
    public static final ResourceLocation NATIVE_WIDGETS = new ResourceLocation("minecraft:textures/gui/widgets.png");
    public static final int NATIVE_UI_FONT_COLOR = -12566464;
    public static final int NATIVE_BUTTON_FONT_COLOR_ACTIVE = -1;
    public static final int NATIVE_BUTTON_FONT_COLOR_DISABLED = -6381922;
    public static final int NATIVE_BUTTON_FONT_COLOR_HIGHLIGHT = -96;
    public static final int DARK_WINDOW_COLOR = -13619152;
    public static final int DEFAULT_BUTTON_COLOR = -12040120;
    public static final int LIGHT_BUTTON_COLOR = -7829368;
    public static final int PRIMARY_BUTTON_COLOR = -15371546;
    public static final int ACCEPT_BUTTON_COLOR = -15879603;
    public static final int ERROR_BUTTON_COLOR = -1556915;
    public static final int WARN_BUTTON_COLOR = -1524418;
    public static final Component TEXT_DRAGON = TextUtils.translate("text.dragonlib.dragon");
    public static final Component TEXT_NEXT = TextUtils.translate("text.dragonlib.next");
    public static final Component TEXT_PREVIOUS = TextUtils.translate("text.dragonlib.previous");
    public static final Component TEXT_GO_BACK = TextUtils.translate("text.dragonlib.go_back");
    public static final Component TEXT_GO_FORTH = TextUtils.translate("text.dragonlib.go_forth");
    public static final Component TEXT_GO_UP = TextUtils.translate("text.dragonlib.go_down");
    public static final Component TEXT_GO_DOWN = TextUtils.translate("text.dragonlib.go_up");
    public static final Component TEXT_GO_RIGHT = TextUtils.translate("text.dragonlib.go_right");
    public static final Component TEXT_GO_LEFT = TextUtils.translate("text.dragonlib.go_left");
    public static final Component TEXT_GO_TO_TOP = TextUtils.translate("text.dragonlib.go_to_top");
    public static final Component TEXT_GO_TO_BOTTOM = TextUtils.translate("text.dragonlib.go_to_bottom");
    public static final Component TEXT_RESET_DEFAULTS = TextUtils.translate("text.dragonlib.reset_defaults");
    public static final Component TEXT_EXPAND = TextUtils.translate("text.dragonlib.expand");
    public static final Component TEXT_COLLAPSE = TextUtils.translate("text.dragonlib.collapse");
    public static final Component TEXT_COUNT = TextUtils.translate("text.dragonlib.count");
    public static final Component TEXT_TRUE = TextUtils.translate("text.dragonlib.true");
    public static final Component TEXT_FALSE = TextUtils.translate("text.dragonlib.false");
    public static final Component TEXT_CLOSE = TextUtils.translate("text.dragonlib.close");
    public static final Component TEXT_SHOW = TextUtils.translate("text.dragonlib.show");
    public static final Component TEXT_HIDE = TextUtils.translate("text.dragonlib.hide");
    public static final Component TEXT_SEARCH = TextUtils.translate("text.dragonlib.search");
    public static final Component TEXT_REFRESH = TextUtils.translate("text.dragonlib.refresh");
    public static final Component TEXT_RELOAD = TextUtils.translate("text.dragonlib.reload");
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MODID));
    private static final Registrar<Item> ITEMS = MANAGER.get().get(Registries.f_256913_);
    private static final Registrar<Block> BLOCKS = MANAGER.get().get(Registries.f_256747_);
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITIES = MANAGER.get().get(Registries.f_256922_);
    public static final RegistrySupplier<Block> DRAGON_BLOCK = DragonLib.registerBlock("dragon", () -> new DragonLibBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.5f)));
    public static final RegistrySupplier<BlockEntityType<DragonLibBlockEntity>> DRAGONLIB_BLOCK_ENTITY = BLOCK_ENTITIES.register(new ResourceLocation("dragonlib", "dragonlib_block_entity"), () -> BlockEntityType.Builder.m_155273_(DragonLibBlockEntity::new, (Block[])new Block[]{(Block)DRAGON_BLOCK.get()}).m_58966_(null));
    private static NetworkManagerBase dragonLibNet;
    private static MinecraftServer currentServer;
    private static boolean initialized;

    private static <T extends Block, I extends BlockItem> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        RegistrySupplier toReturn = BLOCKS.register(new ResourceLocation(MODID, name), block);
        DragonLib.registerBlockItem(name, toReturn, DragonLibBlock.DragonLibItem.class);
        return toReturn;
    }

    private static <T extends Block, I extends BlockItem> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block, Class<I> blockItemClass) {
        return ITEMS.register(new ResourceLocation(MODID, name), () -> {
            try {
                return (Item)blockItemClass.getDeclaredConstructor(Block.class, Item.Properties.class).newInstance(block.get(), new Item.Properties());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.error("Unable to register block item '" + name + "'.", (Throwable)e);
                return new BlockItem((Block)block.get(), new Item.Properties());
            }
        });
    }

    public static void init() {
        if (initialized) {
            throw new IllegalAccessError("Prohibited to init DragonLib manually!");
        }
        initialized = true;
        DragonLibCrossPlatform.registerConfig();
        dragonLibNet = new NetworkManagerBase(MODID, "dragonlib_network", List.of(IdentifiableResponsePacketBase.class, WritableSignPacket.class, DataAccessorResponsePacket.class));
        DragonLib.registerCustom(BasicDataAccessorPacket.class);
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientTickEvent.CLIENT_POST.register(mc -> {
                NetworkManagerBase.callbackListenerTick();
                OverlayManager.tickAll();
            });
            ClientLifecycleEvent.CLIENT_STARTED.register(mc -> DataAccessor.startClientWorker());
            ClientLifecycleEvent.CLIENT_STOPPING.register(mc -> DataAccessor.stopClientWorker());
            ClientGuiEvent.RENDER_HUD.register((poseStack, partialTicks) -> {
                if (Minecraft.m_91087_().f_91062_ == null) {
                    return;
                }
                OverlayManager.renderAll(poseStack, partialTicks);
            });
            ClientRawInputEvent.KEY_PRESSED.register((mc, keyCode, scanCode, action, modifiers) -> {
                for (DLOverlayScreen overlay : OverlayManager.getAllOverlays()) {
                    if (!overlay.keyPressed(keyCode, scanCode, modifiers)) continue;
                    return EventResult.interruptTrue();
                }
                return EventResult.pass();
            });
            ClientRawInputEvent.MOUSE_CLICKED_POST.register((mc, mouseX, mouseY, button) -> {
                for (DLOverlayScreen overlay : OverlayManager.getAllOverlays()) {
                    if (!overlay.mouseClicked(mouseX, mouseY, button)) continue;
                    return EventResult.interruptTrue();
                }
                return EventResult.pass();
            });
            ClientRawInputEvent.MOUSE_SCROLLED.register((mc, scrollDelta) -> {
                for (DLOverlayScreen overlay : OverlayManager.getAllOverlays()) {
                    if (!overlay.mouseScrolled((int)Minecraft.m_91087_().f_91067_.m_91589_(), (int)Minecraft.m_91087_().f_91067_.m_91594_(), scrollDelta)) continue;
                    return EventResult.interruptTrue();
                }
                return EventResult.pass();
            });
        }
        TickEvent.Server.SERVER_POST.register(server -> ScheduledTask.runScheduledTasks());
        LifecycleEvent.SERVER_STARTING.register(server -> DataAccessor.startServerWorker());
        LifecycleEvent.SERVER_STARTED.register(server -> {
            currentServer = server;
        });
        LifecycleEvent.SERVER_STOPPED.register(server -> {
            DataAccessor.stopServerWorker();
            currentServer = null;
        });
        LifecycleEvent.SERVER_STOPPING.register(server -> ScheduledTask.cancelAllTasks());
        if (Platform.getEnv() == Dist.CLIENT) {
            CompatManager.run();
        }
        DragonLib.printDraconicWelcomeMessage();
    }

    public static final NetworkManagerBase getDragonLibNetworkManager() {
        return dragonLibNet;
    }

    public static boolean hasServer() {
        return currentServer != null;
    }

    public static Optional<MinecraftServer> getCurrentServer() {
        return Optional.ofNullable(currentServer);
    }

    public static Level getPhysicalLevel() {
        return DragonLib.hasServer() ? DragonLib.getCurrentServer().get().m_129783_() : ClientWrapper.getClientLevel();
    }

    public static long getCurrentWorldTime() {
        Level level = DragonLib.getPhysicalLevel();
        return level == null ? 0L : level.m_46468_();
    }

    private static void registerCustom(Class<BasicDataAccessorPacket> c) {
        try {
            BasicDataAccessorPacket packet = c.getConstructor(new Class[0]).newInstance(new Object[0]);
            DragonLib.getDragonLibNetworkManager().CHANNEL.register(c, packet::encode, buf -> (BasicDataAccessorPacket)packet.decode((FriendlyByteBuf)buf), packet::handle);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error("Unable to register packet.", (Throwable)e);
        }
    }

    public static long ticksPerDay() {
        return ((Integer)ModCommonConfig.TICKS_PER_DAY.get()).intValue();
    }

    public static long daytimeShift() {
        return ((Integer)ModCommonConfig.DAYTIME_SHIFT.get()).intValue();
    }

    public static double tps() {
        return DragonLib.mcTps() * (Double)ModCommonConfig.TIME_MULTIPLIER.get();
    }

    public static double mcTps() {
        return (double)TimeUnit.SECONDS.toMillis(1L) / 50.0;
    }

    public static double mspt() {
        return 50.0 * (Double)ModCommonConfig.TIME_MULTIPLIER.get();
    }

    public static long ticksPerRealLifeDay() {
        long msPerDay = 86400000L;
        int msPerTick = 50;
        return (long)((double)msPerDay / ((double)msPerTick * (Double)ModCommonConfig.TIME_MULTIPLIER.get()));
    }

    public static long ticksPerIngameHour() {
        return DragonLib.ticksPerDay() / 24L;
    }

    private static final void printDraconicWelcomeMessage() {
        String[] dragonTypes = new String[]{"Dragon", "Fire Dragon", "Ice Dragon", "Lightning Dragon", "Mountain Dragon", "Poison Dragon", "Drake", "Wyvern", "MrJulsen", "Toothless", "Drogon", "Smaug", "Ender Dragon", "Do you think dragons exist?"};
        new Thread(() -> {
            Mod mod = Platform.getMod((String)MODID);
            ArrayList<Object> lines = new ArrayList<String>();
            String border = "+++ \ud83d\udc09 +++";
            lines.add(border);
            lines.add(String.format("Loaded %s v%s by MrJulsen!", mod.getName(), mod.getVersion()));
            lines.add(String.format("Minecraft %s%s%s", Platform.isForge() ? "Forge " : (Platform.isFabric() ? "Fabric " : ""), Platform.getMinecraftVersion(), Platform.isDevelopmentEnvironment() ? " (Dev)" : ""));
            lines.add("");
            lines.add(String.format("Discord: %s", MRJULSEN_DISCORD));
            lines.add(String.format("GitHub: %s", mod.getHomepage().orElse("unknown")));
            lines.add(String.format("Bug Reports: %s", mod.getIssueTracker().orElse("unknown")));
            lines.add(border);
            int width = lines.stream().mapToInt(String::length).max().getAsInt() + 4;
            lines = new ArrayList<String>(lines.stream().map(x -> DragonLib.centerStringInArea(x, width)).toList());
            lines.add(1, DragonLib.lineOf('-', width));
            lines.add(lines.size() - 1, DragonLib.lineOf('-', width));
            lines.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        }, dragonTypes[RANDOM.nextInt(dragonTypes.length)]).start();
    }

    private static final String centerStringInArea(String text, int width) {
        if (text.isBlank()) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        int verLength = sb.length();
        for (int i = 0; i < (width - verLength) / 2; ++i) {
            sb.insert(0, " ");
            sb.append(" ");
        }
        return sb.toString();
    }

    private static final String lineOf(char c, int width) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        initialized = false;
    }
}

