/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.TrainIconType;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.TrainInfo;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainState;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class TrainStop
implements Comparable<TrainStop> {
    protected static final String NBT_SCHEDULE_INDEX = "ScheduleIndex";
    protected static final String NBT_SECTION_INDEX = "SectionIndex";
    protected static final String NBT_TRAIN_ID = "TrainId";
    protected static final String NBT_TRAIN_NAME = "TrainName";
    protected static final String NBT_TRAIN_ICON = "TrainIcon";
    protected static final String NBT_TRAIN_INFO = "TrainInfo";
    protected static final String NBT_SCHEDULE_TITLE = "ScheduleTitle";
    protected static final String NBT_TERMINUS_TEXT = "TerminusText";
    protected static final String NBT_STAY_DURATION = "StayDuration";
    protected static final String NBT_IS_CUSTOM_TITLE = "IsCustomTitle";
    protected static final String NBT_SIMULATED_TIME = "SimulationTime";
    protected static final String NBT_SCHEDULED_DEPARTURE_TIME = "ScheduledDeparture";
    protected static final String NBT_SCHEDULED_ARRIVAL_TIME = "ScheduledArrival";
    protected static final String NBT_CYCLE = "Cycle";
    protected static final String NBT_TAG = "StationTag";
    protected static final String NBT_REAL_TIME_ARRIVAL_TIME = "RealArrival";
    protected static final String NBT_REAL_TIME_DEPARTURE_TIME = "RealDeparture";
    protected static final String NBT_REAL_CYCLE = "RealCycle";
    protected static final String NBT_REAL_TIME_TAG = "RealTimeTag";
    protected static final String NBT_STATE = "State";
    protected final int scheduleIndex;
    protected final int sectionIndex;
    protected final UUID trainId;
    protected final String trainName;
    protected final TrainIconType trainIcon;
    protected final TrainInfo trainInfo;
    protected final String scheduleTitle;
    protected final String terminusText;
    protected final int stayDuration;
    protected final boolean isCustomTitle;
    protected boolean simulated;
    protected long simulationTime;
    protected long scheduledDepartureTime;
    protected long scheduledArrivalTime;
    protected int cycle;
    protected StationTag.ClientStationTag tag;
    protected long realTimeArrivalTime;
    protected long realTimeDepartureTime;
    protected int realTimeCycle = -1;
    protected StationTag.ClientStationTag realTimeTag;
    protected long arrivalTimeDeviation;
    protected long departureTimeDeviation;
    protected int realTimeTicksUntilArrival = -1;
    protected TrainState trainState = TrainState.BEFORE;

    public TrainStop(int scheduleIndex, int sectionIndex, UUID trainId, String trainName, TrainIconType trainIcon, TrainInfo trainInfo, String scheduleTitle, boolean isCustomTitle, String terminusText, int stayDuration, boolean simulated, long scheduledDepartureTime, long scheduledArrivalTime, int cycle, StationTag.ClientStationTag tag, long realTimeArrivalTime, long realTimeDepartureTime, int realTimeCycle, StationTag.ClientStationTag realTimeTag, long arrivalTimeDeviation, long departureTimeDeviation, int realTimeTicksUntilArrival, TrainState trainPosition) {
        this.scheduleIndex = scheduleIndex;
        this.sectionIndex = sectionIndex;
        this.trainId = trainId;
        this.trainName = trainName;
        this.trainIcon = trainIcon;
        this.trainInfo = trainInfo;
        this.scheduleTitle = scheduleTitle;
        this.isCustomTitle = isCustomTitle;
        this.terminusText = terminusText;
        this.stayDuration = stayDuration;
        this.simulated = simulated;
        this.scheduledDepartureTime = scheduledDepartureTime;
        this.scheduledArrivalTime = scheduledArrivalTime;
        this.cycle = cycle;
        this.tag = tag;
        this.realTimeArrivalTime = realTimeArrivalTime;
        this.realTimeDepartureTime = realTimeDepartureTime;
        this.realTimeCycle = realTimeCycle;
        this.realTimeTag = realTimeTag;
        this.arrivalTimeDeviation = arrivalTimeDeviation;
        this.departureTimeDeviation = departureTimeDeviation;
        this.realTimeTicksUntilArrival = realTimeTicksUntilArrival;
        this.trainState = trainPosition;
    }

    public TrainStop(TrainPrediction prediction) {
        this(prediction.getStationTag(), prediction, false);
    }

    public TrainStop(StationTag tag, TrainPrediction prediction, boolean lastCycle) {
        this(prediction.getEntryIndex(), prediction.getSection().getScheduleIndex(), prediction.getData().getTrainId(), prediction.getData().getTrain().name.getString(), prediction.getData().getTrain().icon, prediction.getData().getTrainInfo(prediction.getEntryIndex()), prediction.getTitle(), prediction.hasCustomTitle(), prediction.getSectionDestinationText(), prediction.getStayDuration(), false, lastCycle ? prediction.getPreviousScheduledDepartureTime() : prediction.getScheduledDepartureTime(), lastCycle ? prediction.getPreviousScheduledArrivalTime() : prediction.getScheduledArrivalTime(), prediction.getCurrentCycle() - (lastCycle ? 1 : 0), prediction.getStationTag().getClientTag(prediction.getStationName()), lastCycle ? prediction.getPreviousRealTimeArrivalTime() : prediction.getRealTimeArrivalTime(), lastCycle ? prediction.getPreviousRealTimeDepartureTime() : prediction.getRealTimeDepartureTime(), prediction.getCurrentCycle() - (lastCycle ? 1 : 0), prediction.getStationTag().getClientTag(prediction.getStationName()), prediction.getArrivalTimeDeviation(), prediction.getDepartureTimeDeviation(), prediction.getRealTimeArrivalTicks(), TrainState.BEFORE);
    }

    public TrainStop copy() {
        return new TrainStop(this.scheduleIndex, this.sectionIndex, this.trainId, this.trainName, this.trainIcon, this.trainInfo, this.scheduleTitle, this.isCustomTitle, this.terminusText, this.stayDuration, this.simulated, this.scheduledDepartureTime, this.scheduledArrivalTime, this.cycle, this.tag, this.realTimeArrivalTime, this.realTimeDepartureTime, this.realTimeCycle, this.realTimeTag, this.arrivalTimeDeviation, this.departureTimeDeviation, this.realTimeTicksUntilArrival, this.trainState);
    }

    public void simulateTicks(long ticks) {
        this.simulated = true;
        int totalDuration = TrainListener.data.get(this.getTrainId()).getTotalDuration();
        long scheduledTimeUntilArrival = this.getScheduledArrivalTime() - DragonLib.getCurrentWorldTime();
        int simulationCycles = (int)(ticks / (long)totalDuration);
        long simulationRemaining = ticks % (long)totalDuration;
        if (simulationRemaining > 0L && simulationRemaining >= scheduledTimeUntilArrival) {
            ++simulationCycles;
        }
        this.cycle += simulationCycles;
        this.scheduledArrivalTime += (long)(simulationCycles * totalDuration);
        this.scheduledDepartureTime += (long)(simulationCycles * totalDuration);
        this.realTimeArrivalTime += (long)(simulationCycles * totalDuration);
        this.realTimeDepartureTime += (long)(simulationCycles * totalDuration);
        this.realTimeTicksUntilArrival = -1;
        this.simulationTime += ticks;
    }

    public void simulateCycles(int cycles) {
        if (cycles == 0) {
            return;
        }
        this.simulateTicks(cycles * TrainListener.data.get(this.getTrainId()).getTotalDuration());
    }

    public static TrainStop simulateCyclesBack(TrainPrediction prediction) {
        return new TrainStop(prediction.getStationTag(), prediction, true);
    }

    public boolean isSimulated() {
        return this.simulated;
    }

    public long getSimulationTime() {
        return this.simulationTime;
    }

    public UUID getTrainId() {
        return this.trainId;
    }

    public String getTrainName() {
        return this.trainName;
    }

    public TrainIconType getTrainIcon() {
        return this.trainIcon;
    }

    public TrainInfo getTrainInfo() {
        return this.trainInfo;
    }

    public int getScheduleIndex() {
        return this.scheduleIndex;
    }

    public int getSectionIndex() {
        return this.sectionIndex;
    }

    public String getTerminusText() {
        return this.terminusText;
    }

    public boolean hasCustomTitle() {
        return this.isCustomTitle;
    }

    public String getScheduleTitle() {
        return this.scheduleTitle;
    }

    public String getDisplayTitle() {
        return this.hasCustomTitle() || this.getTerminusText() == null || this.getTerminusText().isEmpty() ? this.getScheduleTitle() : this.getTerminusText();
    }

    public String getTrainDisplayName() {
        return this.getTrainInfo() == null || this.getTrainInfo().line() == null || this.getTrainInfo().line().getLineName().isEmpty() ? this.getTrainName() : this.getTrainInfo().line().getLineName();
    }

    public int getTrainDisplayColor() {
        if (this.getTrainInfo() != null && this.getTrainInfo().line() != null && this.getTrainInfo().line().getColor() != 0) {
            return this.getTrainInfo().line().getColor();
        }
        if (this.getTrainInfo() != null && this.getTrainInfo().group() != null && this.getTrainInfo().group().getColor() != 0) {
            return this.getTrainInfo().group().getColor();
        }
        return -13027015;
    }

    public int getStayTime() {
        return this.stayDuration;
    }

    public StationTag getTag() {
        return GlobalSettings.getInstance().getStationTag(this.getClientTag().tagId()).orElse(GlobalSettings.getInstance().getOrCreateStationTagFor(TagName.of(this.getClientTag().tagName())));
    }

    public StationTag.ClientStationTag getClientTag() {
        return this.tag;
    }

    public int getScheduledCycle() {
        return this.cycle;
    }

    public int getRealTimeCycle() {
        return this.realTimeCycle;
    }

    public StationTag.ClientStationTag getRealTimeStationTag() {
        return this.realTimeTag;
    }

    public long getScheduledDepartureTime() {
        return this.scheduledDepartureTime;
    }

    public long getScheduledArrivalTime() {
        return this.scheduledArrivalTime;
    }

    public long getRealTimeArrivalTime() {
        return this.realTimeArrivalTime;
    }

    public long getRealTimeDepartureTime() {
        return this.realTimeDepartureTime;
    }

    public long getArrivalTimeDeviation() {
        return this.arrivalTimeDeviation;
    }

    public long getDepartureTimeDeviation() {
        return this.departureTimeDeviation;
    }

    public int getTicksUntilArrival() {
        return this.realTimeTicksUntilArrival;
    }

    public long getScheduledArrivalDay() {
        return this.getScheduledArrivalTime() / DragonLib.ticksPerDay();
    }

    public long getScheduledDepartureDay() {
        return this.getScheduledDepartureDay() / DragonLib.ticksPerDay();
    }

    public long getRealTimeArrivalDay() {
        return this.getRealTimeArrivalTime() / DragonLib.ticksPerDay();
    }

    public long getRealTimeDepartureDay() {
        return this.getRealTimeDepartureTime() / DragonLib.ticksPerDay();
    }

    public TrainState getState() {
        return this.trainState;
    }

    public boolean isArrivalDelayed() {
        return this.getArrivalTimeDeviation() >= (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue();
    }

    public boolean isDepartureDelayed() {
        return this.getDepartureTimeDeviation() >= (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue();
    }

    public boolean isAnyDelayed() {
        return this.isArrivalDelayed() || this.isDepartureDelayed();
    }

    public boolean shouldRenderRealTime() {
        return this.getRealTimeCycle() >= this.getScheduledCycle();
    }

    public boolean isStationInfoChanged() {
        return !this.getClientTag().info().equals(this.getRealTimeStationTag().info());
    }

    public boolean isDeparted() {
        return this.trainState == TrainState.AFTER;
    }

    @Override
    public int compareTo(TrainStop o) {
        return Long.compare(this.getScheduledArrivalTime(), o.getScheduledArrivalTime());
    }

    public CompoundTag toNbt(boolean includeRealTime) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_SCHEDULE_INDEX, this.scheduleIndex);
        nbt.m_128405_(NBT_SECTION_INDEX, this.sectionIndex);
        nbt.m_128362_(NBT_TRAIN_ID, this.trainId);
        nbt.m_128359_(NBT_TRAIN_NAME, this.trainName);
        nbt.m_128359_(NBT_TRAIN_ICON, this.trainIcon.getId().toString());
        nbt.m_128365_(NBT_TRAIN_INFO, (Tag)this.trainInfo.toNbt());
        nbt.m_128359_(NBT_SCHEDULE_TITLE, this.scheduleTitle);
        nbt.m_128359_(NBT_TERMINUS_TEXT, this.terminusText);
        nbt.m_128405_(NBT_STAY_DURATION, this.stayDuration);
        nbt.m_128379_(NBT_IS_CUSTOM_TITLE, this.isCustomTitle);
        nbt.m_128365_(NBT_TAG, (Tag)this.tag.toNbt());
        nbt.m_128356_(NBT_SIMULATED_TIME, this.simulationTime);
        nbt.m_128356_(NBT_SCHEDULED_ARRIVAL_TIME, this.scheduledArrivalTime);
        nbt.m_128356_(NBT_SCHEDULED_DEPARTURE_TIME, this.scheduledDepartureTime);
        nbt.m_128405_(NBT_CYCLE, this.cycle);
        nbt.m_128356_(NBT_REAL_TIME_ARRIVAL_TIME, this.realTimeArrivalTime);
        nbt.m_128356_(NBT_REAL_TIME_DEPARTURE_TIME, this.realTimeDepartureTime);
        nbt.m_128405_(NBT_REAL_CYCLE, this.realTimeCycle);
        nbt.m_128365_(NBT_REAL_TIME_TAG, (Tag)this.realTimeTag.toNbt());
        return nbt;
    }

    public static TrainStop fromNbt(CompoundTag nbt) {
        return new TrainStop(nbt.m_128451_(NBT_SCHEDULE_INDEX), nbt.m_128451_(NBT_SECTION_INDEX), nbt.m_128342_(NBT_TRAIN_ID), nbt.m_128461_(NBT_TRAIN_NAME), TrainIconType.byId((ResourceLocation)new ResourceLocation(nbt.m_128461_(NBT_TRAIN_ICON))), TrainInfo.fromNbt(nbt.m_128469_(NBT_TRAIN_INFO)), nbt.m_128461_(NBT_SCHEDULE_TITLE), nbt.m_128471_(NBT_IS_CUSTOM_TITLE), nbt.m_128461_(NBT_TERMINUS_TEXT), nbt.m_128451_(NBT_STAY_DURATION), nbt.m_128454_(NBT_SIMULATED_TIME) != 0L, nbt.m_128454_(NBT_SCHEDULED_DEPARTURE_TIME), nbt.m_128454_(NBT_SCHEDULED_ARRIVAL_TIME), nbt.m_128451_(NBT_CYCLE), StationTag.ClientStationTag.fromNbt(nbt.m_128469_(NBT_TAG)), nbt.m_128454_(NBT_REAL_TIME_ARRIVAL_TIME), nbt.m_128454_(NBT_REAL_TIME_DEPARTURE_TIME), nbt.m_128451_(NBT_REAL_CYCLE), StationTag.ClientStationTag.fromNbt(nbt.m_128469_(NBT_REAL_TIME_TAG)), nbt.m_128441_(NBT_REAL_TIME_ARRIVAL_TIME) ? nbt.m_128454_(NBT_REAL_TIME_ARRIVAL_TIME) - nbt.m_128454_(NBT_SCHEDULED_ARRIVAL_TIME) : 0L, nbt.m_128441_(NBT_REAL_TIME_DEPARTURE_TIME) ? nbt.m_128454_(NBT_REAL_TIME_DEPARTURE_TIME) - nbt.m_128454_(NBT_SCHEDULED_DEPARTURE_TIME) : 0L, 0, TrainState.BEFORE);
    }
}

