/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.advancement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.DyeColor;

public class DyeColorPredicate {
    public static final String JSON_PROPERTY = "colorPredicate";
    public static final DyeColorPredicate ANY = new DyeColorPredicate(Collections.emptyList());
    private final List<DyeColor> colors;

    public DyeColorPredicate(List<DyeColor> colors) {
        this.colors = colors;
    }

    public boolean matches(DyeColor color) {
        if (this.colors.size() == 0) {
            return true;
        }
        for (DyeColor dyeColor : this.colors) {
            if (!color.equals((Object)dyeColor)) continue;
            return true;
        }
        return false;
    }

    public static DyeColorPredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)JSON_PROPERTY);
        JsonArray colorsList = jsonobject.get("colors").getAsJsonArray();
        ArrayList<DyeColor> colors = new ArrayList<DyeColor>();
        for (JsonElement element : colorsList) {
            colors.add(DyeColor.m_41057_((String)element.getAsString(), null));
        }
        return new DyeColorPredicate(colors);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonArray colorsList = new JsonArray();
        for (DyeColor color : this.colors) {
            colorsList.add(color.m_7912_());
        }
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("colors", (JsonElement)colorsList);
        return jsonobject;
    }
}

