/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.loot;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.sootychimneys.block.ChimneyBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.registries.ForgeRegistries;

public class ModLootTables {
    public static final ResourceLocation SOOT_SCRAPING = new ResourceLocation("sootychimneys", "soot_scraping");

    public static List<ItemStack> getSootScrapingLootFor(BlockState state, ServerLevel level) {
        if (!(state.m_60734_() instanceof ChimneyBlock)) {
            LogUtils.getLogger().error("Soot Scraping is only for ChimneyBlocks.");
            return Collections.emptyList();
        }
        String blockId = Objects.requireNonNull(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_())).m_135815_());
        try {
            LootParams lootParams = new LootParams.Builder(level).m_287286_(LootContextParams.f_81461_, (Object)state).m_287235_(LootContextParamSets.f_81410_);
            LootContext lootContext = new LootContext.Builder(lootParams).m_287259_(null);
            LootTable lootTable = level.m_7654_().m_278653_().m_278676_(new ResourceLocation(SOOT_SCRAPING + "/" + blockId));
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            lootTable.m_79148_(lootContext, items::add);
            return items;
        }
        catch (Exception ex) {
            LogUtils.getLogger().error("Failed to get 'soot_scraping' loot table for '{}'. - {}", (Object)blockId, (Object)ex.toString());
            return Collections.emptyList();
        }
    }
}

