/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.renderer;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ScalableItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private float xScale;
    private float yScale;
    private float zScale;

    public ScalableItemStackRenderer(float xScale, float yScale, float zScale) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
    }

    public ScalableItemStackRenderer(float scale) {
        this.xScale = scale;
        this.yScale = scale;
        this.zScale = scale;
    }

    public void render(GuiGraphics guiGraphics, ItemStack ingredient) {
        if (ingredient != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(this.xScale, this.yScale, this.zScale);
            guiGraphics.m_280480_(ingredient, 0, 0);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public int getWidth() {
        return (int)(this.xScale * 16.0f);
    }

    public int getHeight() {
        return (int)(this.yScale * 16.0f);
    }

    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        try {
            return ingredient.m_41651_((Player)player, tooltipFlag);
        }
        catch (LinkageError | RuntimeException e) {
            LogUtils.getLogger().error("Failed to get tooltip: {}", (Object)ingredient, (Object)e);
            return Collections.emptyList();
        }
    }
}

