/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei;

import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.config.Config;
import io.github.mortuusars.sootychimneys.integration.jei.JeiRecipeTypes;
import io.github.mortuusars.sootychimneys.integration.jei.category.SootCoveringRecipeCategory;
import io.github.mortuusars.sootychimneys.integration.jei.category.SootScrapingRecipeCategory;
import io.github.mortuusars.sootychimneys.integration.jei.category.SootScrapingWithLootTablesRecipeCategory;
import io.github.mortuusars.sootychimneys.integration.jei.recipe.SootCoveringJeiRecipe;
import io.github.mortuusars.sootychimneys.integration.jei.recipe.SootScrapingWithLootTablesJeiRecipe;
import io.github.mortuusars.sootychimneys.recipe.ingredient.ChanceResult;
import io.github.mortuusars.sootychimneys.setup.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class SootyChimneysJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = SootyChimneys.resource("jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        if (((Boolean)Config.ADD_SOOT_COVERING_TO_JEI.get()).booleanValue() && (Double)Config.DIRTY_CHANCE.get() > 0.0) {
            registration.addRecipeCategories(new IRecipeCategory[]{new SootCoveringRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        }
        if (((Boolean)Config.ADD_SOOT_SCRAPING_TO_JEI.get()).booleanValue()) {
            if (((Boolean)Config.USE_LOOT_TABLES_FOR_SCRAPING.get()).booleanValue()) {
                registration.addRecipeCategories(new IRecipeCategory[]{new SootScrapingWithLootTablesRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
            } else {
                registration.addRecipeCategories(new IRecipeCategory[]{new SootScrapingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
            }
        }
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addRecipes(JeiRecipeTypes.SOOT_COVERING, Arrays.stream(SootyChimneys.Chimney.values()).map(c -> new SootCoveringJeiRecipe(c.getCleanItem(), c.getDirtyItem())).toList());
        if (((Boolean)Config.USE_LOOT_TABLES_FOR_SCRAPING.get()).booleanValue()) {
            registration.addRecipes(JeiRecipeTypes.SOOT_SCRAPING_LOOT_TABLES, Arrays.stream(SootyChimneys.Chimney.values()).map(c -> new SootScrapingWithLootTablesJeiRecipe(c.getDirtyItem(), c.getCleanItem())).toList());
        } else {
            ArrayList recipes = new ArrayList(Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_().m_44013_((RecipeType)ModRecipeTypes.SOOT_SCRAPING.get()));
            recipes.sort((r, r1) -> {
                List<ChanceResult> results = r.getResults();
                List<ChanceResult> results1 = r1.getResults();
                if (results.isEmpty()) {
                    return results1.isEmpty() ? -1 : 0;
                }
                if (results1.isEmpty()) {
                    return 1;
                }
                return Float.compare(results1.get(0).getChance(), results.get(0).getChance());
            });
            registration.addRecipes(JeiRecipeTypes.SOOT_SCRAPING, recipes);
        }
    }
}

