/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.data;

import io.github.mortuusars.sootychimneys.SootyChimneys;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModLootTables {

    public static class SootScrapingProvider
    implements LootTableSubProvider {
        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> output) {
            for (SootyChimneys.Chimney chimney : SootyChimneys.Chimney.values()) {
                output.accept(SootyChimneys.resource("soot_scraping/" + chimney.getDirtyId()), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42498_)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chimney.getDefaultScrapeChance()))));
            }
        }
    }

    public static class BlockLootProvider
    extends VanillaBlockLoot {
        protected void m_245660_() {
            for (SootyChimneys.Chimney chimney : SootyChimneys.Chimney.values()) {
                this.m_245724_(chimney.getCleanBlock());
                this.m_245724_(chimney.getDirtyBlock());
            }
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getEntries().stream().filter(e -> ((ResourceKey)e.getKey()).m_135782_().m_135827_().equals("sootychimneys")).map(Map.Entry::getValue).collect(Collectors.toList());
        }
    }
}

