/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.data;

import io.github.mortuusars.sootychimneys.data.ModBlockTagsProvider;
import io.github.mortuusars.sootychimneys.data.ModItemModelsProvider;
import io.github.mortuusars.sootychimneys.data.ModItemTagsProvider;
import io.github.mortuusars.sootychimneys.data.ModLootTables;
import io.github.mortuusars.sootychimneys.data.ModRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sootychimneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ModBlockTagsProvider blockTagsGenerator = new ModBlockTagsProvider(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsGenerator);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, blockTagsGenerator, event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModLootTables.BlockLootProvider::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(ModLootTables.SootScrapingProvider::new, LootContextParamSets.f_81410_))));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelsProvider(packOutput, event.getExistingFileHelper()));
    }
}

