/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.world.level.Level;

public final class ScheduledTask<T> {
    public static final int INFINITE_RUNTIME = -1;
    private final T data;
    private final BiFunction<T, ScheduledTaskContext, Boolean> action;
    private final int tickDelay;
    private final int maxIterations;
    private final Level level;
    private int iteration = 0;
    private long currentTick = -1L;
    private UUID id;

    private ScheduledTask(T data, Level level, int delay, int maxIterations, BiFunction<T, ScheduledTaskContext, Boolean> action) {
        this.data = data;
        this.tickDelay = delay;
        this.maxIterations = maxIterations;
        this.action = action;
        this.level = level;
    }

    public static <T> ScheduledTask<T> create(T data, Level level, int delay, int maxIterations, BiFunction<T, ScheduledTaskContext, Boolean> action) {
        ScheduledTask<T> task = new ScheduledTask<T>(data, level, delay, maxIterations, action);
        task.id = ScheduledTaskHolder.store(task);
        return task;
    }

    public static <T> ScheduledTask<T> create(T data, Level level, int delay, BiFunction<T, ScheduledTaskContext, Boolean> action) {
        ScheduledTask<T> task = new ScheduledTask<T>(data, level, delay, -1, action);
        task.id = ScheduledTaskHolder.store(task);
        return task;
    }

    private void run() {
        ++this.currentTick;
        if (this.currentTick % (long)this.tickDelay != 0L) {
            return;
        }
        if (!this.action.apply(this.data, new ScheduledTaskContext(this.level, this.iteration)).booleanValue()) {
            ScheduledTaskHolder.delete(this.id);
        }
        ++this.iteration;
        if (this.maxIterations >= 0 && this.iteration >= this.maxIterations) {
            ScheduledTaskHolder.delete(this.id);
        }
    }

    public UUID getId() {
        return this.id;
    }

    public void cancel() {
        ScheduledTaskHolder.delete(this.id);
    }

    public static int getRunningTasksCount() {
        return ScheduledTaskHolder.scheduledTasks.size();
    }

    public static void runScheduledTasks() {
        ArrayList taskList = new ArrayList(ScheduledTaskHolder.scheduledTasks.values());
        taskList.forEach(x -> x.run());
    }

    public static void cancelAllTasks() {
        ScheduledTaskHolder.scheduledTasks.clear();
    }

    private static final class ScheduledTaskHolder {
        static final Map<UUID, ScheduledTask<?>> scheduledTasks = new HashMap();

        private ScheduledTaskHolder() {
        }

        static UUID store(ScheduledTask<?> task) {
            UUID id = UUID.randomUUID();
            while (scheduledTasks.containsKey(id)) {
                id = UUID.randomUUID();
            }
            scheduledTasks.put(id, task);
            return id;
        }

        static void delete(UUID id) {
            if (scheduledTasks.containsKey(id)) {
                scheduledTasks.remove(id);
            }
        }
    }

    public record ScheduledTaskContext(Level level, int iteration) {
    }
}

