/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.data;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class Clipboard {
    protected static final Map<Class<? extends INBTSerializable>, CompoundTag> clipboardData = new HashMap<Class<? extends INBTSerializable>, CompoundTag>();

    public static <T extends INBTSerializable> void put(Class<T> clipboardClass, T data) {
        if (clipboardData.containsKey(clipboardClass)) {
            clipboardData.remove(clipboardClass);
        }
        clipboardData.put(clipboardClass, data.serializeNbt());
    }

    public static <T extends INBTSerializable> Optional<T> get(Class<T> clipboardClass) {
        if (clipboardData.containsKey(clipboardClass)) {
            try {
                INBTSerializable t = (INBTSerializable)clipboardClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                t.deserializeNbt(clipboardData.get(clipboardClass));
                return Optional.of(t);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                DragonLib.LOGGER.error("Unable to deserialize clipbaord data.", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public static <T extends INBTSerializable> boolean contains(Class<T> clipboardClass) {
        return clipboardData.containsKey(clipboardClass);
    }

    public static void clear() {
        clipboardData.clear();
    }

    public static <T extends INBTSerializable> Optional<T> clear(Class<T> clipboardClass) {
        CompoundTag nbt = clipboardData.remove(clipboardClass);
        try {
            INBTSerializable t = (INBTSerializable)clipboardClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            t.deserializeNbt(nbt);
            return Optional.of(t);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            DragonLib.LOGGER.error("Unable to deserialize clipbaord data.", (Throwable)e);
            return Optional.empty();
        }
    }
}

