/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.core;

import de.mrjulsen.mcdragonlib.util.MathUtils;
import java.awt.Color;

public class ColorObject {
    private int r;
    private int g;
    private int b;
    private int a;

    public ColorObject(int r, int g, int b, int a) {
        this.r = MathUtils.clamp(r, 0, 255);
        this.g = MathUtils.clamp(g, 0, 255);
        this.b = MathUtils.clamp(b, 0, 255);
        this.a = MathUtils.clamp(a, 0, 255);
    }

    public ColorObject(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public ColorObject(float r, float g, float b, float a) {
        this(ColorObject.colorFloatToInt(r), ColorObject.colorFloatToInt(g), ColorObject.colorFloatToInt(b), ColorObject.colorFloatToInt(a));
    }

    public ColorObject(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public static float colorIntToFloat(int i) {
        float f = MathUtils.clamp(Math.abs(i), 0, 255);
        return f == 0.0f ? 0.0f : 0.00390625f * f;
    }

    public static int colorFloatToInt(float f) {
        f = MathUtils.clamp(f, 0.0f, 1.0f);
        return (int)(255.0f * f);
    }

    public static ColorObject fromHSV(float h, float s, float b) {
        Color c = Color.getHSBColor(h, s, b);
        return new ColorObject(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    public static ColorObject fromHSV(double h, double s, double b) {
        return ColorObject.fromHSV((float)h, (float)s, (float)b);
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public int getA() {
        return this.a;
    }

    public float getRFloat() {
        return ColorObject.colorIntToFloat(this.r);
    }

    public float getGFloat() {
        return ColorObject.colorIntToFloat(this.g);
    }

    public float getBFloat() {
        return ColorObject.colorIntToFloat(this.b);
    }

    public float getAFloat() {
        return ColorObject.colorIntToFloat(this.a);
    }

    public int toInt() {
        this.r = Math.max(0, Math.min(255, this.getR()));
        this.g = Math.max(0, Math.min(255, this.getG()));
        this.b = Math.max(0, Math.min(255, this.getB()));
        this.a = Math.max(0, Math.min(255, this.getA()));
        int rgba = this.a << 24 | this.r << 16 | this.g << 8 | this.b;
        return rgba;
    }

    public static ColorObject fromInt(int rgba) {
        int a = rgba >> 24 & 0xFF;
        int r = rgba >> 16 & 0xFF;
        int g = rgba >> 8 & 0xFF;
        int b = rgba & 0xFF;
        return new ColorObject(r, g, b, a);
    }

    public float[] toHSV() {
        float[] hsb = new float[4];
        Color.RGBtoHSB(this.r, this.g, this.b, hsb);
        return hsb;
    }
}

