/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.AbstractWidget;

public class WidgetsCollection {
    public final List<AbstractWidget> components = new ArrayList<AbstractWidget>();
    private boolean enabled = true;
    private boolean visible = true;

    public void performForEach(Predicate<? super AbstractWidget> filter, Consumer<? super AbstractWidget> consumer) {
        this.components.stream().filter(filter).forEach(consumer);
    }

    public void performForEach(Consumer<? super AbstractWidget> consumer) {
        this.performForEach(x -> true, consumer);
    }

    public <C extends AbstractWidget> void performForEachOfType(Class<C> clazz, Predicate<C> filter, Consumer<C> consumer) {
        this.components.stream().filter(clazz::isInstance).map(clazz::cast).filter(filter).forEach(consumer);
    }

    public <C extends AbstractWidget> void performForEachOfType(Class<C> clazz, Consumer<C> consumer) {
        this.performForEachOfType(clazz, x -> true, consumer);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean v) {
        this.visible = v;
        this.performForEach(x -> {
            x.f_93624_ = v;
        });
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
        this.performForEach(x -> {
            x.f_93623_ = e;
        });
    }

    public <W extends AbstractWidget> void add(W widget) {
        widget.f_93623_ = this.enabled;
        widget.f_93624_ = this.visible;
        this.components.add(widget);
    }

    public void clear() {
        this.components.clear();
    }

    public void clear(Consumer<AbstractWidget> onRemove) {
        this.performForEach(x -> onRemove.accept((AbstractWidget)x));
        this.clear();
    }
}

