/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLSlider;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.core.ColorObject;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.mixin.FontAccessor;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public class GuiUtils {
    public static final String ELLIPSIS_STRING = "...";

    public static void enableScissor(Graphics graphics, int x, int y, int w, int h) {
        int scale = (int)Minecraft.m_91087_().m_91268_().m_85449_();
        RenderSystem.enableScissor((int)(x * scale), (int)(Minecraft.m_91087_().m_91268_().m_85442_() - (y + h) * scale), (int)(w * scale), (int)(h * scale));
        graphics.poseStack().m_85836_();
    }

    public static void disableScissor(Graphics graphics) {
        graphics.poseStack().m_85849_();
        RenderSystem.disableScissor();
    }

    public static void playButtonSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public static FormattedCharSequence toFormattedCharSequence(FormattedText text) {
        return text instanceof Component ? ((Component)text).m_7532_() : Language.m_128107_().m_5536_(text);
    }

    public static <T extends FormattedText> boolean renderTooltipAt(Screen screen, GuiAreaDefinition area, List<T> lines, int maxWidth, Graphics graphics, int xPos, int yPos, int mouseX, int mouseY, int xOffset, int yOffset) {
        if (area.isInBounds(mouseX + xOffset, mouseY + yOffset)) {
            graphics.graphics().m_280245_(Minecraft.m_91087_().f_91062_, GuiUtils.getTooltipData(screen, lines, maxWidth), xPos - 8, yPos + 16);
            return true;
        }
        return false;
    }

    public static <W extends AbstractWidget, T extends FormattedText> boolean renderTooltip(Screen screen, W widget, List<T> lines, int maxWidth, Graphics graphics, int mouseX, int mouseY) {
        return GuiUtils.renderTooltipWithOffset(screen, widget, lines, maxWidth, graphics, mouseX, mouseY, 0, 0);
    }

    public static <T extends FormattedText> boolean renderTooltip(Screen screen, GuiAreaDefinition area, List<T> lines, int maxWidth, Graphics graphics, int mouseX, int mouseY) {
        return GuiUtils.renderTooltipWithOffset(screen, area, lines, maxWidth, graphics, mouseX, mouseY, 0, 0);
    }

    public static <W extends AbstractWidget, T extends FormattedText> boolean renderTooltipWithOffset(Screen screen, W widget, List<T> lines, int maxWidth, Graphics graphics, int mouseX, int mouseY, int xOffset, int yOffset) {
        IDragonLibWidget dlw;
        if (widget instanceof IDragonLibWidget && (dlw = (IDragonLibWidget)widget).isMouseSelected() || !(widget instanceof IDragonLibWidget) && widget.m_5953_((double)(mouseX + xOffset), (double)(mouseY + yOffset))) {
            graphics.graphics().m_280245_(Minecraft.m_91087_().f_91062_, GuiUtils.getTooltipData(screen, lines, maxWidth), mouseX, mouseY);
            return true;
        }
        return false;
    }

    public static <T extends FormattedText> boolean renderTooltipWithOffset(Screen screen, GuiAreaDefinition area, List<T> lines, int maxWidth, Graphics graphics, int mouseX, int mouseY, int xOffset, int yOffset) {
        if (area.isInBounds(mouseX + xOffset, mouseY + yOffset)) {
            graphics.graphics().m_280245_(Minecraft.m_91087_().f_91062_, GuiUtils.getTooltipData(screen, lines, maxWidth), mouseX, mouseY);
            return true;
        }
        return false;
    }

    public static <T extends Enum<T>> List<FormattedCharSequence> getEnumTooltipData(String modid, Screen screen, Class<T> enumClass, int maxWidth) {
        ArrayList<FormattedCharSequence> c = new ArrayList<FormattedCharSequence>();
        Enum enumValue = ((Enum[])enumClass.getEnumConstants())[0];
        c.addAll(((FontAccessor)Minecraft.m_91087_().f_91062_).dragonlib$getSplitter().m_92414_((FormattedText)TextUtils.translate(((ITranslatableEnum)((Object)enumValue)).getEnumDescriptionTranslationKey(modid)), maxWidth, Style.f_131099_).stream().map(x -> GuiUtils.toFormattedCharSequence(x)).toList());
        c.add(TextUtils.text(" ").m_7532_());
        c.addAll(Arrays.stream((Enum[])enumClass.getEnumConstants()).map(tr -> TextUtils.text(String.format("\u00a7l> %s\u00a7r\u00a77\n%s", TextUtils.translate(((ITranslatableEnum)((Object)tr)).getValueTranslationKey(modid)).getString(), TextUtils.translate(((ITranslatableEnum)((Object)tr)).getValueInfoTranslationKey(modid)).getString()))).map(x -> ((FontAccessor)Minecraft.m_91087_().f_91062_).dragonlib$getSplitter().m_92414_((FormattedText)x, maxWidth, Style.f_131099_).stream().map(a -> GuiUtils.toFormattedCharSequence(a)).toList()).flatMap(Collection::stream).collect(Collectors.toList()));
        return c;
    }

    public static <T extends Enum<T>> List<Component> getEnumTooltipData(String modid, Class<T> enumClass) {
        ArrayList<Component> c = new ArrayList<Component>();
        Enum enumValue = ((Enum[])enumClass.getEnumConstants())[0];
        c.add((Component)TextUtils.translate(((ITranslatableEnum)((Object)enumValue)).getEnumDescriptionTranslationKey(modid)));
        c.add((Component)TextUtils.text(" "));
        c.addAll(Arrays.stream((Enum[])enumClass.getEnumConstants()).map(tr -> TextUtils.text(String.format("\u00a7l> %s\u00a7r\u00a77\n%s", TextUtils.translate(((ITranslatableEnum)((Object)tr)).getValueTranslationKey(modid)).getString(), TextUtils.translate(((ITranslatableEnum)((Object)tr)).getValueInfoTranslationKey(modid)).getString()))).toList());
        return c;
    }

    public static <T extends FormattedText> List<FormattedCharSequence> getTooltipData(Screen screen, T component, int maxWidth) {
        return GuiUtils.getTooltipData(screen, List.of(component), maxWidth);
    }

    public static <T extends FormattedText> List<FormattedCharSequence> getTooltipData(Screen screen, Collection<T> components, int maxWidth) {
        return components.stream().flatMap(a -> ((FontAccessor)Minecraft.m_91087_().f_91062_).dragonlib$getSplitter().m_92414_(a, maxWidth <= 0 ? screen.f_96543_ : maxWidth, Style.f_131099_).stream()).map(x -> GuiUtils.toFormattedCharSequence(x)).toList();
    }

    public static <T extends FormattedText> List<FormattedText> getTooltipDataFormatted(Screen screen, Collection<T> components, int maxWidth) {
        return components.stream().flatMap(a -> ((FontAccessor)Minecraft.m_91087_().f_91062_).dragonlib$getSplitter().m_92414_(a, maxWidth <= 0 ? screen.f_96543_ : maxWidth, Style.f_131099_).stream()).toList();
    }

    public static boolean editBoxNumberFilter(String input) {
        if (input.isEmpty()) {
            return true;
        }
        String i = input;
        if (input.equals("-")) {
            i = "-0";
        }
        try {
            Integer.parseInt(i);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean editBoxPositiveNumberFilter(String input) {
        if (input.isEmpty()) {
            return true;
        }
        try {
            int i = Integer.parseInt(input);
            return i > 0;
        }
        catch (NumberFormatException var3) {
            return false;
        }
    }

    public static boolean editBoxNonNegativeNumberFilter(String input) {
        if (input.isEmpty()) {
            return true;
        }
        try {
            int i = Integer.parseInt(input);
            return i >= 0;
        }
        catch (NumberFormatException var3) {
            return false;
        }
    }

    public static void setTexture(ResourceLocation texture) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void setTexture(int textureId) {
        RenderSystem.setShaderTexture((int)0, (int)textureId);
    }

    public static void setTint(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void setTint(int color) {
        short[] argb = ColorUtils.decodeARGB(color);
        GuiUtils.setTint(ColorObject.colorIntToFloat(argb[1]), ColorObject.colorIntToFloat(argb[2]), ColorObject.colorIntToFloat(argb[3]), ColorObject.colorIntToFloat(argb[0]));
    }

    public static void resetTint() {
        GuiUtils.setTint(-1);
    }

    public static void drawTexture(ResourceLocation texture, Graphics graphics, int x, int y, int w, int h, int u, int v, int uW, int vH, int textureWidth, int textureHeight) {
        graphics.graphics().m_280411_(texture, x, y, w, h, (float)u, (float)v, uW, vH, textureWidth, textureHeight);
    }

    public static void drawTexture(ResourceLocation texture, Graphics graphics, int x, int y, int w, int h, int u, int v, int textureWidth, int textureHeight) {
        graphics.graphics().m_280411_(texture, x, y, w, h, (float)u, (float)v, w, h, textureWidth, textureHeight);
    }

    public static void drawTexture(ResourceLocation texture, Graphics graphics, int x, int y, int u, int v, int w, int h) {
        graphics.graphics().m_280411_(texture, x, y, w, h, (float)u, (float)v, w, h, 256, 256);
    }

    public static void drawTexture(ResourceLocation texture, Graphics graphics, int x, int y, int w, int h) {
        graphics.graphics().m_280411_(texture, x, y, w, h, 0.0f, 0.0f, w, h, w, h);
    }

    private static void innerBlit(PoseStack pose, int textureId, int pX1, int pX2, int pY1, int pY2, int pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, (float)pX1, (float)pY1, (float)pBlitOffset).m_7421_(pMinU, pMinV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)pX1, (float)pY2, (float)pBlitOffset).m_7421_(pMinU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)pX2, (float)pY2, (float)pBlitOffset).m_7421_(pMaxU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)pX2, (float)pY1, (float)pBlitOffset).m_7421_(pMaxU, pMinV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    private static void blit(GuiGraphics graphics, int textureId, int pX, int pY, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        GuiUtils.blit(graphics, textureId, pX, pX + pWidth, pY, pY + pHeight, 0, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight);
    }

    private static void blit(GuiGraphics graphics, int textureId, int pX1, int pX2, int pY1, int pY2, int pBlitOffset, int pUWidth, int pVHeight, float pUOffset, float pVOffset, int pTextureWidth, int pTextureHeight) {
        GuiUtils.innerBlit(graphics.m_280168_(), textureId, pX1, pX2, pY1, pY2, pBlitOffset, (pUOffset + 0.0f) / (float)pTextureWidth, (pUOffset + (float)pUWidth) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight, (pVOffset + (float)pVHeight) / (float)pTextureHeight);
    }

    public static void drawTexture(int textureId, Graphics graphics, int x, int y, int w, int h, int u, int v, int uW, int vH, int textureWidth, int textureHeight) {
        GuiUtils.blit(graphics.graphics(), textureId, x, y, w, h, u, v, uW, vH, textureWidth, textureHeight);
    }

    public static void drawTexture(int textureId, Graphics graphics, int x, int y, int w, int h, int u, int v, int textureWidth, int textureHeight) {
        GuiUtils.blit(graphics.graphics(), textureId, x, y, w, h, u, v, w, h, textureWidth, textureHeight);
    }

    public static void drawTexture(int textureId, Graphics graphics, int x, int y, int w, int h, int textureWidth, int textureHeight) {
        GuiUtils.blit(graphics.graphics(), textureId, x, y, w, h, 0.0f, 0.0f, w, h, textureWidth, textureHeight);
    }

    public static void drawTexture(int textureId, Graphics graphics, int x, int y, int w, int h) {
        GuiUtils.blit(graphics.graphics(), textureId, x, y, w, h, 0.0f, 0.0f, w, h, w, h);
    }

    public static void fill(Graphics graphics, int x, int y, int w, int h, int color) {
        graphics.graphics().m_280509_(x, y, x + w, y + h, color);
    }

    public static void fillGradient(Graphics graphics, int x, int y, int z, int w, int h, int colorA, int colorB) {
        float startAlpha = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(colorA & 0xFF) / 255.0f;
        float endAlpha = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(colorB & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(graphics.poseStack().m_85850_().m_252922_(), (float)(x + w), (float)y, (float)z).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_252986_(graphics.poseStack().m_85850_().m_252922_(), (float)x, (float)y, (float)z).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_252986_(graphics.poseStack().m_85850_().m_252922_(), (float)x, (float)(y + h), (float)z).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        buffer.m_252986_(graphics.poseStack().m_85850_().m_252922_(), (float)(x + w), (float)(y + h), (float)z).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void drawBox(Graphics graphics, GuiAreaDefinition area, int fillColor, int borderColor) {
        GuiUtils.fill(graphics, area.getLeft(), area.getTop(), area.getWidth(), area.getHeight(), fillColor);
        GuiUtils.fill(graphics, area.getLeft(), area.getTop(), area.getWidth(), 1, borderColor);
        GuiUtils.fill(graphics, area.getLeft(), area.getBottom() - 1, area.getWidth(), 1, borderColor);
        GuiUtils.fill(graphics, area.getLeft(), area.getTop() + 1, 1, area.getHeight() - 2, borderColor);
        GuiUtils.fill(graphics, area.getRight() - 1, area.getTop() + 1, 1, area.getHeight() - 2, borderColor);
    }

    public static void drawString(Graphics graphics, Font font, int x, int y, String text, int color, EAlignment alignment, boolean shadow) {
        GuiUtils.drawString(graphics, font, x, y, (FormattedText)TextUtils.text(text), color, alignment, shadow);
    }

    public static void drawString(Graphics graphics, Font font, int x, int y, FormattedText text, int color, EAlignment alignment, boolean shadow) {
        int width = font.m_92852_(text);
        int offset = 0;
        switch (alignment) {
            default: {
                break;
            }
            case CENTER: {
                offset = -width / 2;
                break;
            }
            case RIGHT: {
                offset = -width;
            }
        }
        graphics.graphics().m_280649_(font, GuiUtils.toFormattedCharSequence(text), x + offset, y, color, shadow);
    }

    public static DLButton createButton(int x, int y, int width, int height, Component text, Consumer<DLButton> onClick) {
        return new DLButton(x, y, width, height, text, onClick);
    }

    public static <T extends Enum<T>> DLCycleButton<T> createCycleButton(String modid, Class<T> clazz, int x, int y, int width, int height, Component text, T initialValue, BiConsumer<DLCycleButton<?>, T> onValueChanged) {
        DLCycleButton<Enum> btn = DLCycleButton.builder(p -> TextUtils.translate(((ITranslatableEnum)((Object)((Enum)clazz.cast(p)))).getValueTranslationKey(modid))).withValues((Enum[])((Enum[])clazz.getEnumConstants())).withInitialValue(initialValue).create(x, y, width, height, text, (b, v) -> onValueChanged.accept(b, v));
        return btn;
    }

    public static DLCycleButton<Boolean> createOnOffButton(int x, int y, int width, int height, Component text, boolean initialValue, BiConsumer<DLCycleButton<?>, Boolean> onValueChanged) {
        DLCycleButton<Boolean> btn = DLCycleButton.onOffBuilder(initialValue).create(x, y, width, height, text, (b, v) -> onValueChanged.accept(b, (Boolean)v));
        return btn;
    }

    public static DLEditBox createEditBox(int x, int h, int width, int height, Font font, String text, Component hint, boolean drawBg, Consumer<String> onValueChanged, BiConsumer<DLEditBox, Boolean> onFocusChanged) {
        DLEditBox box = new DLEditBox(font, x, h, width, height, (Component)TextUtils.text(text)).withHint(hint).withOnFocusChanged(onFocusChanged);
        box.m_94151_(onValueChanged);
        box.m_94144_(text);
        box.m_94182_(drawBg);
        return box;
    }

    public static DLSlider createSlider(int x, int y, int width, int height, Component prefix, Component suffix, double min, double max, double step, double initialValue, boolean drawLabel, BiConsumer<DLSlider, Double> onValueChanged, Consumer<DLSlider> onUpdateMessage) {
        DLSlider slider = new DLSlider(x, y, width, height, prefix, suffix, min, max, initialValue, step, 1, drawLabel);
        slider.setOnUpdateMessage(onUpdateMessage);
        slider.setOnValueChanged(onValueChanged);
        return slider;
    }

    public static Component ellipsisString(Font font, Component text, int maxWidth) {
        int lineWidth = font.m_92852_((FormattedText)text);
        return lineWidth < maxWidth ? text : TextUtils.text(font.m_92854_((FormattedText)text, maxWidth - font.m_92895_(ELLIPSIS_STRING)).getString()).m_130948_(text.m_7383_()).m_130946_(ELLIPSIS_STRING);
    }
}

