/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.WidgetContainer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;

public class GuiAreaDefinition {
    private final int x;
    private final int y;
    private final int w;
    private final int h;

    public GuiAreaDefinition(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getRight() {
        return this.x + this.w;
    }

    public int getBottom() {
        return this.y + this.h;
    }

    public int getLeft() {
        return this.getX();
    }

    public int getTop() {
        return this.getY();
    }

    public boolean isInBounds(double mouseX, double mouseY) {
        return mouseX >= (double)this.getLeft() && mouseX < (double)this.getRight() && mouseY >= (double)this.getTop() && mouseY < (double)this.getBottom();
    }

    public static GuiAreaDefinition empty() {
        return new GuiAreaDefinition(0, 0, 0, 0);
    }

    public static <T extends Screen> GuiAreaDefinition of(T screen) {
        return new GuiAreaDefinition(0, 0, screen.f_96543_, screen.f_96544_);
    }

    @Deprecated(forRemoval=true)
    public static <T extends WidgetContainer> GuiAreaDefinition of(T container) {
        return new GuiAreaDefinition(container.getX(), container.getY(), container.getWidth(), container.getHeight());
    }

    public static <T extends DLWidgetContainer> GuiAreaDefinition of(T container) {
        return new GuiAreaDefinition(container.getX(), container.getY(), container.getWidth(), container.getHeight());
    }

    public static <T extends AbstractWidget> GuiAreaDefinition of(T widget) {
        return new GuiAreaDefinition(widget.m_252754_(), widget.m_252907_(), widget.m_5711_(), widget.m_93694_());
    }

    public String toString() {
        return String.format("[%s, %s, %s, %s]", this.getX(), this.getY(), this.getRight(), this.getBottom());
    }
}

