/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class DLCycleButton<T>
extends DLButton {
    static final BooleanSupplier DEFAULT_ALT_LIST_SELECTOR = Screen::m_96639_;
    private static final List<Boolean> BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final Component name;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, Component> valueStringifier;
    private final Function<DLCycleButton<T>, MutableComponent> narrationProvider;
    private final OnValueChange<T> onValueChange;
    private final boolean displayOnlyValue;

    DLCycleButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Component pName, int pIndex, T pValue, ValueListSupplier<T> pValues, Function<T, Component> pValueStringifier, Function<DLCycleButton<T>, MutableComponent> pNarrationProvider, OnValueChange<T> pOnValueChange, boolean pDisplayOnlyValue) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.name = pName;
        this.index = pIndex;
        this.value = pValue;
        this.values = pValues;
        this.valueStringifier = pValueStringifier;
        this.narrationProvider = pNarrationProvider;
        this.onValueChange = pOnValueChange;
        this.displayOnlyValue = pDisplayOnlyValue;
    }

    public void m_5691_() {
        if (Screen.m_96638_()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int pDelta) {
        List<T> list = this.values.getSelectedList();
        this.index = Mth.m_14100_((int)(this.index + pDelta), (int)list.size());
        T t = list.get(this.index);
        this.updateValue(t);
        this.onValueChange.onValueChange(this, t);
    }

    private T getCycledValue(int pDelta) {
        List<T> list = this.values.getSelectedList();
        return list.get(Mth.m_14100_((int)(this.index + pDelta), (int)list.size()));
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (pDelta > 0.0) {
            this.cycleValue(-1);
        } else if (pDelta < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    public void setValue(T pValue) {
        List<T> list = this.values.getSelectedList();
        int i = list.indexOf(pValue);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(pValue);
    }

    private void updateValue(T pValue) {
        Component component = this.createLabelForValue(pValue);
        this.m_93666_(component);
        this.value = pValue;
    }

    private Component createLabelForValue(T pValue) {
        return this.displayOnlyValue ? this.valueStringifier.apply(pValue) : this.createFullName(pValue);
    }

    private MutableComponent createFullName(T pValue) {
        return CommonComponents.m_178393_((Component)this.name, (Component)this.valueStringifier.apply(pValue));
    }

    public T getValue() {
        return this.value;
    }

    protected MutableComponent m_5646_() {
        return this.narrationProvider.apply(this);
    }

    public void m_168797_(NarrationElementOutput arg) {
        arg.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            T object = this.getCycledValue(1);
            Component component = this.createLabelForValue(object);
            if (this.m_93696_()) {
                arg.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                arg.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public MutableComponent createDefaultNarrationMessage() {
        return DLCycleButton.m_168799_((Component)(this.displayOnlyValue ? this.createFullName(this.value) : this.m_6035_()));
    }

    public static <T> Builder<T> builder(Function<T, Component> pValueStringifier) {
        return new Builder<T>(pValueStringifier);
    }

    public static Builder<Boolean> booleanBuilder(Component pComponentOn, Component pComponentOff) {
        return new Builder<Boolean>(p_168902_ -> p_168902_ != false ? pComponentOn : pComponentOff).withValues(BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(p_168891_ -> p_168891_ != false ? CommonComponents.f_130653_ : CommonComponents.f_130654_).withValues(BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder(boolean pInitialValue) {
        return DLCycleButton.onOffBuilder().withInitialValue(pInitialValue);
    }

    static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(List<T> pValues) {
            ImmutableList list = ImmutableList.copyOf(pValues);
            return new ValueListSupplier<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier pAltListSelector, List<T> pDefaultList, List<T> pSelectedList) {
            ImmutableList list = ImmutableList.copyOf(pDefaultList);
            ImmutableList list1 = ImmutableList.copyOf(pSelectedList);
            return new ValueListSupplier<T>(){
                final /* synthetic */ List val$list1;
                final /* synthetic */ List val$list;
                {
                    this.val$list1 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return pAltListSelector.getAsBoolean() ? this.val$list1 : this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }
    }

    public static interface OnValueChange<T> {
        public void onValueChange(DLCycleButton<T> var1, T var2);
    }

    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T initialValue;
        private final Function<T, Component> valueStringifier;
        private Function<DLCycleButton<T>, MutableComponent> narrationProvider = DLCycleButton::createDefaultNarrationMessage;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());
        private boolean displayOnlyValue;

        public Builder(Function<T, Component> pValueStringifier) {
            this.valueStringifier = pValueStringifier;
        }

        public Builder<T> withValues(List<T> pValues) {
            this.values = ValueListSupplier.create(pValues);
            return this;
        }

        @SafeVarargs
        public final Builder<T> withValues(T ... pValues) {
            return this.withValues((List<T>)ImmutableList.copyOf((Object[])pValues));
        }

        public Builder<T> withValues(List<T> pDefaultList, List<T> pSelectedList) {
            this.values = ValueListSupplier.create(DEFAULT_ALT_LIST_SELECTOR, pDefaultList, pSelectedList);
            return this;
        }

        public Builder<T> withValues(BooleanSupplier pAltListSelector, List<T> pDefaultList, List<T> pSelectedList) {
            this.values = ValueListSupplier.create(pAltListSelector, pDefaultList, pSelectedList);
            return this;
        }

        public Builder<T> withInitialValue(T pInitialValue) {
            this.initialValue = pInitialValue;
            int i = this.values.getDefaultList().indexOf(pInitialValue);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> withCustomNarration(Function<DLCycleButton<T>, MutableComponent> pNarrationProvider) {
            this.narrationProvider = pNarrationProvider;
            return this;
        }

        public Builder<T> displayOnlyValue() {
            this.displayOnlyValue = true;
            return this;
        }

        public DLCycleButton<T> create(int pX, int pY, int pWidth, int pHeight, Component pName) {
            return this.create(pX, pY, pWidth, pHeight, pName, (p_168946_, p_168947_) -> {});
        }

        public DLCycleButton<T> create(int pX, int pY, int pWidth, int pHeight, Component pName, OnValueChange<T> pOnValueChange) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T t = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            Component component = this.valueStringifier.apply(t);
            Component component1 = this.displayOnlyValue ? component : CommonComponents.m_178393_((Component)pName, (Component)component);
            return new DLCycleButton<T>(pX, pY, pWidth, pHeight, component1, pName, this.initialIndex, t, this.values, this.valueStringifier, this.narrationProvider, pOnValueChange, this.displayOnlyValue);
        }
    }

    @FunctionalInterface
    public static interface TooltipSupplier<T>
    extends Function<T, List<FormattedCharSequence>> {
    }
}

