/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.ber;

import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BERQuad {
    private ResourceLocation texture;
    private float width;
    private float height;
    private float u0;
    private float v0;
    private float u1;
    private float v1;
    private Direction facing;
    private boolean ambientOcclusion;
    private boolean useCustomLight;
    private int light;
    private int tint = -1;
    private Vector3f translate = null;
    private Quaternionf rotation = null;

    public BERQuad(ResourceLocation texture, float width, float height, float u0, float v0, float u1, float v1, Direction facing) {
        this.width = width;
        this.height = height;
        this.u0 = u0;
        this.v0 = v0;
        this.u1 = u1;
        this.v1 = v1;
        this.facing = facing;
        this.texture = texture;
    }

    public static BERQuad createPx(ResourceLocation texture, int width, int height, int u0, int v0, int u1, int v1, int textureWidth, int textureHeight, Direction facing) {
        return new BERQuad(texture, BERUtils.bpx(width), BERUtils.bpx(width), BERUtils.px(u0, textureWidth), BERUtils.px(v0, textureHeight), BERUtils.px(u1, textureWidth), BERUtils.px(v1, textureHeight), facing);
    }

    public void setAmbientOcclusion(boolean b) {
        this.ambientOcclusion = b;
    }

    public boolean isUsingAmbientOcclusion() {
        return this.ambientOcclusion;
    }

    public void setLight(int light) {
        this.light = light;
        this.useCustomLight = true;
    }

    public void defaultLight() {
        this.useCustomLight = false;
    }

    public boolean isUsingCustomLight() {
        return this.useCustomLight;
    }

    public void setTint(int tint) {
        this.tint = tint;
    }

    public Vector3f getTranslate() {
        return this.translate;
    }

    public void setTranslate(Vector3f translate) {
        this.translate = translate;
    }

    public Quaternionf getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternionf rotation) {
        this.rotation = rotation;
    }

    public void render(RenderGraphics graphics) {
        this.render(graphics, 0.0f, 0.0f, 0.0f);
    }

    public void renderPx(RenderGraphics graphics) {
        this.renderPx(graphics, 0.0f, 0.0f, 0.0f);
    }

    public void render(RenderGraphics graphics, float x, float y, float z) {
        graphics.poseStack().m_85836_();
        if (this.rotation != null) {
            graphics.poseStack().m_252781_(this.rotation);
        }
        graphics.poseStack().m_85836_();
        if (this.translate != null) {
            graphics.poseStack().m_252880_(this.translate.x(), this.translate.y(), this.translate.z());
        }
        BERUtils.renderTexture(this.texture, graphics, this.ambientOcclusion, x, y, z, this.width, this.height, this.u0, this.v0, this.u1, this.v1, this.facing, this.tint, this.useCustomLight ? this.light : graphics.packedLight());
        graphics.poseStack().m_85849_();
        graphics.poseStack().m_85849_();
    }

    public void renderPx(RenderGraphics graphics, float x, float y, float z) {
        this.render(graphics, BERUtils.bpx(x), BERUtils.bpx(y), BERUtils.bpx(z));
    }
}

