/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class TrainStopDisplayData {
    private final int stationEntryIndex;
    private final String name;
    private final long scheduledDepartureTime;
    private final long scheduledArrivalTime;
    private final long realTimeDepartureTime;
    private final long realTimeArrivalTime;
    private final String destination;
    private final String trainName;
    private final StationTag.StationInfo stationInfo;
    private static final String NBT_STATION_INDEX = "Index";
    private static final String NBT_NAME = "Name";
    private static final String NBT_SCHEDULED_DEPARTURE_TIME = "ScheduledDeparture";
    private static final String NBT_SCHEDULED_ARRIVAL_TIME = "ScheduledArrival";
    private static final String NBT_REAL_TIME_DEPARTURE_TIME = "RealTimeArrival";
    private static final String NBT_REAL_TIME_ARRIVAL_TIME = "RealTimeDeparture";
    private static final String NBT_DESTINATION = "Destination";
    private static final String NBT_TRAIN_NAME = "TrainName";
    private static final String NBT_STATION_INFO = "StationInfo";

    public TrainStopDisplayData(int stationEntryIndex, String name, long scheduledDepartureTime, long scheduledArrivalTime, long realTimeDepartureTime, long realTimeArrivalTime, String destination, String trainName, StationTag.StationInfo stationInfo) {
        this.stationEntryIndex = stationEntryIndex;
        this.name = name;
        this.scheduledDepartureTime = scheduledDepartureTime;
        this.scheduledArrivalTime = scheduledArrivalTime;
        this.realTimeDepartureTime = realTimeDepartureTime;
        this.realTimeArrivalTime = realTimeArrivalTime;
        this.destination = destination;
        this.trainName = trainName;
        this.stationInfo = stationInfo;
    }

    public static TrainStopDisplayData empty() {
        return new TrainStopDisplayData(-1, "", 0L, 0L, 0L, 0L, "", "", StationTag.StationInfo.empty());
    }

    public static TrainStopDisplayData of(TrainStop stop) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return new TrainStopDisplayData(stop.getScheduleIndex(), stop.getRealTimeStationTag().tagName(), stop.getScheduledDepartureTime(), stop.getScheduledArrivalTime(), stop.getRealTimeDepartureTime(), stop.getRealTimeArrivalTime(), stop.getDisplayTitle(), stop.getTrainDisplayName(), stop.getRealTimeStationTag().info());
    }

    public int getStationEntryIndex() {
        return this.stationEntryIndex;
    }

    public String getName() {
        return this.name;
    }

    public long getScheduledDepartureTime() {
        return this.scheduledDepartureTime;
    }

    public long getScheduledArrivalTime() {
        return this.scheduledArrivalTime;
    }

    public long getRealTimeDepartureTime() {
        return this.realTimeDepartureTime;
    }

    public long getRealTimeArrivalTime() {
        return this.realTimeArrivalTime;
    }

    public String getDestination() {
        return this.destination;
    }

    public StationTag.StationInfo getStationInfo() {
        return this.stationInfo;
    }

    public String getTrainName() {
        return this.trainName;
    }

    public long getDepartureTimeDeviation() {
        return this.getRealTimeDepartureTime() - this.getScheduledDepartureTime();
    }

    public long getArrivalTimeDeviation() {
        return this.getRealTimeArrivalTime() - this.getScheduledArrivalTime();
    }

    public boolean isDepartureDelayed() {
        return this.getDepartureTimeDeviation() > (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue();
    }

    public boolean isArrivalDelayed() {
        return this.getArrivalTimeDeviation() > (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_STATION_INDEX, this.stationEntryIndex);
        nbt.m_128359_(NBT_NAME, this.name);
        nbt.m_128356_(NBT_SCHEDULED_DEPARTURE_TIME, this.scheduledDepartureTime);
        nbt.m_128356_(NBT_SCHEDULED_ARRIVAL_TIME, this.scheduledArrivalTime);
        nbt.m_128356_(NBT_REAL_TIME_DEPARTURE_TIME, this.realTimeDepartureTime);
        nbt.m_128356_(NBT_REAL_TIME_ARRIVAL_TIME, this.realTimeArrivalTime);
        nbt.m_128359_(NBT_DESTINATION, this.destination);
        nbt.m_128359_(NBT_TRAIN_NAME, this.trainName);
        nbt.m_128365_(NBT_STATION_INFO, (Tag)this.stationInfo.toNbt());
        return nbt;
    }

    public static TrainStopDisplayData fromNbt(CompoundTag nbt) {
        return new TrainStopDisplayData(nbt.m_128451_(NBT_STATION_INDEX), nbt.m_128461_(NBT_NAME), nbt.m_128454_(NBT_SCHEDULED_DEPARTURE_TIME), nbt.m_128454_(NBT_SCHEDULED_ARRIVAL_TIME), nbt.m_128454_(NBT_REAL_TIME_DEPARTURE_TIME), nbt.m_128454_(NBT_REAL_TIME_ARRIVAL_TIME), nbt.m_128461_(NBT_DESTINATION), nbt.m_128461_(NBT_TRAIN_NAME), StationTag.StationInfo.fromNbt(nbt.m_128469_(NBT_STATION_INFO)));
    }

    public final boolean equals(Object obj) {
        TrainStopDisplayData o;
        return obj instanceof TrainStopDisplayData && (o = (TrainStopDisplayData)obj).getDestination().equals(this.getDestination()) && o.getStationEntryIndex() == this.getStationEntryIndex();
    }

    public final int hashCode() {
        return Objects.hash(this.getDestination(), this.getStationEntryIndex());
    }
}

