/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.tooltip;

import com.copycatsplus.copycats.foundation.tooltip.CopycatCharacteristics;
import com.copycatsplus.copycats.foundation.tooltip.forge.CopycatDescriptionImpl;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CopycatDescription {
    public static final Map<Item, List<CopycatCharacteristics>> ITEM_CHARACTERISTICS = new HashMap<Item, List<CopycatCharacteristics>>();
    protected final Item item;
    private Language cachedLanguage = null;
    private Map<String, List<Object>> cachedArgs = new HashMap<String, List<Object>>();
    private Map<CopycatCharacteristics, Pair<List<Component>, List<Component>>> descriptions;
    @Nullable
    private List<Component> shortDescription = null;
    @Nullable
    private List<Component> longDescription = null;

    public static void register(ItemLike item, CopycatCharacteristics ... characteristics) {
        ITEM_CHARACTERISTICS.put(item.m_5456_(), List.of(characteristics));
    }

    public static <T extends ItemLike> NonNullConsumer<? super T> register(CopycatCharacteristics ... characteristics) {
        return item -> CopycatDescription.register((ItemLike)item.m_5456_(), characteristics);
    }

    protected CopycatDescription(Item item) {
        this.item = item;
    }

    private void loadDescriptions(Item item) {
        List<CopycatCharacteristics> characteristics = ITEM_CHARACTERISTICS.get(item);
        if (characteristics == null) {
            this.shortDescription = new ArrayList<Component>();
            this.longDescription = new ArrayList<Component>();
            return;
        }
        this.shortDescription = new ArrayList<Component>(characteristics.size());
        this.longDescription = new ArrayList<Component>(characteristics.size() * 2);
        for (CopycatCharacteristics characteristic : characteristics) {
            Pair<List<Component>, List<Component>> pair = this.descriptions.get((Object)characteristic);
            if (pair == null) continue;
            this.shortDescription.addAll((Collection)pair.getFirst());
            this.longDescription.addAll((Collection)pair.getFirst());
            this.longDescription.addAll((Collection)pair.getSecond());
        }
        String[] holdDesc = Lang.translateDirect((String)"tooltip.holdForDescription", (Object[])new Object[]{"$"}).getString().split("\\$");
        MutableComponent keyShift = Lang.translateDirect((String)"tooltip.keyShift", (Object[])new Object[0]);
        for (boolean shift : Iterate.falseAndTrue) {
            MutableComponent tabBuilder = Components.empty();
            tabBuilder.m_7220_((Component)Components.literal((String)holdDesc[0]).m_130940_(ChatFormatting.DARK_GRAY));
            tabBuilder.m_7220_((Component)keyShift.m_6879_().m_130940_(shift ? ChatFormatting.WHITE : ChatFormatting.GRAY));
            if (holdDesc.length > 1) {
                tabBuilder.m_7220_((Component)Components.literal((String)holdDesc[1]).m_130940_(ChatFormatting.DARK_GRAY));
            }
            (shift ? this.longDescription : this.shortDescription).add(0, (Component)tabBuilder);
            (shift ? this.longDescription : this.shortDescription).add(1, Components.immutableEmpty());
        }
    }

    public void modify(Item item, List<Component> tooltip) {
        if (this.shouldInvalidateCache()) {
            this.populateDescriptions();
            this.loadDescriptions(item);
        }
        if (this.shortDescription == null || this.longDescription == null) {
            this.loadDescriptions(item);
        }
        if (Screen.m_96638_()) {
            if (this.longDescription != null) {
                tooltip.addAll(1, this.longDescription);
            }
        } else if (this.shortDescription != null) {
            tooltip.addAll(1, this.shortDescription);
        }
    }

    private boolean shouldInvalidateCache() {
        Language currentLanguage = Language.m_128107_();
        HashMap<String, List<Object>> newArgs = new HashMap<String, List<Object>>();
        for (CopycatCharacteristics characteristics : CopycatCharacteristics.all()) {
            newArgs.put(characteristics.m_7912_(), Arrays.stream(characteristics.getArgs()).map(Supplier::get).toList());
        }
        if (!currentLanguage.equals(this.cachedLanguage) || !newArgs.equals(this.cachedArgs)) {
            this.cachedLanguage = currentLanguage;
            this.cachedArgs = newArgs;
            return true;
        }
        return false;
    }

    private void populateDescriptions() {
        this.descriptions = new HashMap<CopycatCharacteristics, Pair<List<Component>, List<Component>>>();
        for (CopycatCharacteristics characteristics : CopycatCharacteristics.all()) {
            String titleKey = characteristics.getTitleKey();
            String descKey = characteristics.getDescriptionKey();
            if (!this.cachedLanguage.m_6722_(titleKey) || !this.cachedLanguage.m_6722_(descKey)) continue;
            this.descriptions.put(characteristics, (Pair<List<Component>, List<Component>>)Pair.of(List.of(Components.literal((String)("- " + this.cachedLanguage.m_6834_(titleKey))).m_130940_(ChatFormatting.GRAY)), (Object)TooltipHelper.cutStringTextComponent((String)String.format(this.cachedLanguage.m_6834_(descKey), this.cachedArgs.get(characteristics.m_7912_()).toArray()), (TooltipHelper.Palette)TooltipHelper.Palette.STANDARD_CREATE)));
        }
    }

    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static TooltipModifier create(ItemLike item) {
        return CopycatDescriptionImpl.create(item);
    }
}

