/*
 * Decompiled with CFR 0.152.
 */
package com.neuvillette.ae2ct.api;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEKey;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.neuvillette.ae2ct.Config;
import com.neuvillette.ae2ct.api.CraftingTreeHelper;
import com.neuvillette.ae2ct.gui.CraftingTreeWidget;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;

public class ScreenshotHelper {
    private static final int scale = 2;
    private static final Font font = new Font("Arial", 1, 12);

    public static void Screenshot(CraftingTreeHelper.NodeManager nodeManager, Player player) {
        try {
            int scale = 2;
            Minecraft minecraft = Minecraft.m_91087_();
            HashMap<AEKey, Point> map = new HashMap<AEKey, Point>();
            BufferedImage image = new BufferedImage(nodeManager.max_x * 110, nodeManager.max_y * 110, 6);
            Graphics2D graphics = image.createGraphics();
            graphics.setFont(font);
            graphics.setColor(Color.BLACK);
            graphics.setStroke(new BasicStroke(4.0f));
            BufferedImage stackImage = ScreenshotHelper.init(nodeManager.root, map);
            ScreenshotHelper.draw(graphics, stackImage, nodeManager.root, map);
            graphics.dispose();
            ScreenshotHelper.safeImage(minecraft.f_91069_, "CraftingTree_" + Util.m_241986_() + ".png", image, arg_0 -> ((Player)player).m_213846_(arg_0));
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237110_((String)"ae2ct.screenshot.exception", (Object[])new Object[]{e.toString()}));
        }
    }

    private static BufferedImage init(CraftingTreeHelper.Node node, Map<AEKey, Point> map) throws IOException {
        Minecraft minecraft = Minecraft.m_91087_();
        HashSet<AEKey> keys = new HashSet<AEKey>();
        ScreenshotHelper.initNode(node, keys);
        int size = keys.size();
        int len = (int)Math.sqrt(size) + 1;
        int simpleLen = 22;
        int width = len * simpleLen * 2 * 2;
        int height = len * simpleLen * 2 * 2;
        RenderTarget target = new RenderTarget(true){};
        target.m_83950_(width, height, true);
        target.m_83931_(203.0f, 204.0f, 212.0f, 255.0f);
        target.m_83954_(Minecraft.f_91002_);
        target.m_83947_(true);
        PoseStack view = RenderSystem.getModelViewStack();
        view.m_85836_();
        view.m_166856_();
        view.m_252880_(-1.0f, 1.0f, 0.0f);
        view.m_85841_(4.0f / (float)width, -4.0f / (float)height, -0.001f);
        view.m_252880_(0.0f, 0.0f, 10.0f);
        RenderSystem.applyModelViewMatrix();
        Matrix4f backupProj = RenderSystem.getProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().identity(), (VertexSorting)VertexSorting.f_276633_);
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        guiGraphics.m_280509_(0, 0, width / 2, height / 2, -3420972);
        int x = 0;
        int y = 0;
        for (AEKey key : keys) {
            Point pos = new Point(x, y);
            map.put(key, pos);
            guiGraphics.m_280218_(ResourceLocation.m_214293_((String)"ae2ct", (String)"icon.png"), x * simpleLen, y * simpleLen, 0, 0, 22, 22);
            AEKeyRendering.drawInGui((Minecraft)Minecraft.m_91087_(), (GuiGraphics)guiGraphics, (int)(x * simpleLen + 3), (int)(y * simpleLen + 3), (AEKey)key);
            if (++x < len) continue;
            x = 0;
            ++y;
        }
        guiGraphics.m_280262_();
        RenderSystem.setProjectionMatrix((Matrix4f)backupProj, (VertexSorting)VertexSorting.f_276633_);
        view.m_85849_();
        RenderSystem.applyModelViewMatrix();
        target.m_83970_();
        NativeImage nativeimage = Screenshot.m_92279_((RenderTarget)target);
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(nativeimage.m_85121_()));
        target.m_83930_();
        return img;
    }

    private static void initNode(CraftingTreeHelper.Node node, Set<AEKey> set) {
        set.add(node.stack.what());
        if (node.subNodes != null) {
            for (CraftingTreeHelper.Node subNode : node.subNodes) {
                ScreenshotHelper.initNode(subNode, set);
            }
        }
    }

    private static void draw(Graphics2D graphics, BufferedImage stackImage, CraftingTreeHelper.Node node, Map<AEKey, Point> map) {
        int spacing = 110;
        int output = 10;
        int stackLength = 44;
        int x = node.point.x * spacing + output;
        int y = node.point.y * spacing + output;
        if (node.subNodes != null && !node.subNodes.isEmpty()) {
            graphics.drawLine(x + stackLength, y + stackLength, x + stackLength, y + stackLength + spacing / 2);
        }
        Point pos = map.get(node.stack.what());
        BufferedImage subImage = stackImage.getSubimage(pos.x * 88, pos.y * 88, 88, 88);
        graphics.drawImage((Image)subImage, x, y, null);
        if (((Boolean)Config.SCREENSHOT_SHOW_COUNT.get()).booleanValue()) {
            String text = CraftingTreeWidget.getDrawAmount(node);
            FontMetrics fm = graphics.getFontMetrics();
            int textWidth = fm.stringWidth(text);
            int textHeight = fm.getHeight();
            graphics.drawString(text, x + 80 - textWidth, y + 92 - textHeight);
        }
        if (node.subNodes == null || node.subNodes.isEmpty()) {
            return;
        }
        Point last = new Point(0, 0);
        for (CraftingTreeHelper.Node child : node.subNodes) {
            Point p = child.point;
            int pX = p.x * spacing + output;
            int pY = p.y * spacing + output;
            graphics.drawLine(pX + stackLength, y + stackLength + spacing / 2, pX + stackLength, pY + stackLength);
            ScreenshotHelper.draw(graphics, stackImage, child, map);
            if (last.x >= p.x) continue;
            last = p;
        }
        graphics.drawLine(x + stackLength, y + stackLength + spacing / 2, last.x * spacing + output + stackLength, y + stackLength + spacing / 2);
    }

    private static void safeImage(File file, @Nullable String p_92307_, BufferedImage image, Consumer<Component> p_92311_) throws IOException {
        File file1 = new File(file, "screenshots");
        file1.mkdir();
        File file2 = p_92307_ == null ? ScreenshotHelper.getFile(file1) : new File(file1, p_92307_);
        File target = file2.getCanonicalFile();
        Util.m_183992_().execute(() -> {
            try {
                boolean success = ImageIO.write((RenderedImage)image, "png", target);
                if (!success) {
                    throw new IOException("Failed to write buffered image to file: " + target.getAbsolutePath());
                }
                MutableComponent component = Component.m_237113_((String)file2.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(p_168608_ -> p_168608_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, target.getAbsolutePath())));
                p_92311_.accept((Component)Component.m_237110_((String)"screenshot.success", (Object[])new Object[]{component}));
            }
            catch (Exception exception) {
                p_92311_.accept((Component)Component.m_237110_((String)"screenshot.failure", (Object[])new Object[]{exception.getMessage()}));
            }
        });
    }

    private static File getFile(File p_92288_) {
        String s = Util.m_241986_();
        int i = 1;
        File file1;
        while ((file1 = new File(p_92288_, s + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }
}

