/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.multiloader.forge;

import com.dugkse.moderntrainparts.multiloader.PlayerSelection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerSelectionImpl
extends PlayerSelection {
    private static final PacketDistributor<Predicate<ServerPlayer>> ALL_WITH = new PacketDistributor(PlayerSelectionImpl::playerListAllWith, NetworkDirection.PLAY_TO_CLIENT);
    final PacketDistributor.PacketTarget target;

    private static Consumer<Packet<?>> playerListAllWith(PacketDistributor<Predicate<ServerPlayer>> distributor, Supplier<Predicate<ServerPlayer>> predicateSupplier) {
        return p -> {
            Predicate predicate = (Predicate)predicateSupplier.get();
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                if (!predicate.test(player)) continue;
                player.f_8906_.m_9829_(p);
            }
        };
    }

    private PlayerSelectionImpl(PacketDistributor.PacketTarget target) {
        this.target = target;
    }

    @Override
    public void accept(ResourceLocation id, FriendlyByteBuf buffer) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(id, buffer);
        this.target.send((Packet)packet);
    }

    public static PlayerSelection all() {
        return new PlayerSelectionImpl(PacketDistributor.ALL.noArg());
    }

    public static PlayerSelection allWith(Predicate<ServerPlayer> condition) {
        return new PlayerSelectionImpl(ALL_WITH.with(() -> condition));
    }

    public static PlayerSelection of(ServerPlayer player) {
        return new PlayerSelectionImpl(PacketDistributor.PLAYER.with(() -> player));
    }

    public static PlayerSelection tracking(Entity entity) {
        return new PlayerSelectionImpl(PacketDistributor.TRACKING_ENTITY.with(() -> entity));
    }

    public static PlayerSelection tracking(BlockEntity be) {
        LevelChunk chunk = be.m_58904_().m_46745_(be.m_58899_());
        return new PlayerSelectionImpl(PacketDistributor.TRACKING_CHUNK.with(() -> chunk));
    }

    public static PlayerSelection tracking(ServerLevel level, BlockPos pos) {
        LevelChunk chunk = level.m_46745_(pos);
        return new PlayerSelectionImpl(PacketDistributor.TRACKING_CHUNK.with(() -> chunk));
    }

    public static PlayerSelection trackingAndSelf(ServerPlayer player) {
        return new PlayerSelectionImpl(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
    }
}

