/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.mixin;

import com.dugkse.moderntrainparts.content.pantograph.PantographBlock;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.MutablePair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Train.class})
public class TrainMixin {
    @Shadow
    public int fuelTicks;
    @Shadow
    public List<Carriage> carriages;
    @Shadow
    public double speed;

    @Inject(at={@At(value="HEAD")}, method={"burnFuel()V"}, cancellable=true, remap=false)
    public void burnFuel(CallbackInfo ci) {
        boolean iterateFromBack = this.speed < 0.0;
        int carriageCount = this.carriages.size();
        AtomicBoolean hasPower = new AtomicBoolean(false);
        for (int index = 0; index < carriageCount; ++index) {
            int i = iterateFromBack ? carriageCount - 1 - index : index;
            Carriage carriage = this.carriages.get(i);
            carriage.forEachPresentEntity(entity -> {
                for (MutablePair actor : entity.getContraption().getActors()) {
                    if (!(((StructureTemplate.StructureBlockInfo)actor.left).f_74676_().m_60734_() instanceof PantographBlock) || !((MovementContext)actor.right).data.m_128441_("touches_power")) continue;
                    hasPower.set(true);
                    return;
                }
            });
        }
        if (hasPower.get()) {
            if (this.fuelTicks < 1) {
                this.fuelTicks = 1;
            }
            ci.cancel();
        }
    }
}

