/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.init;

import com.dugkse.moderntrainparts.util.TextUtils;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MTPTagsInit {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)id);
    }

    public static void register() {
        AllBlockTags.register();
    }

    public static void provideLangEntries(BiConsumer<String, String> consumer) {
        for (AllBlockTags blockTag : AllBlockTags.values()) {
            ResourceLocation loc = blockTag.tag.f_203868_();
            consumer.accept("tag.block." + loc.m_135827_() + "." + loc.m_135815_().replace('/', '.'), TextUtils.titleCaseConversion(blockTag.name()).replace('_', ' '));
        }
        consumer.accept("tag.item.railways.long_stack", "Double Stack");
        consumer.accept("tag.item.forge.string", "String");
    }

    public static enum AllBlockTags {
        TRANSFERS_ELECTRICITY_TRAINS(NameSpace.MOD, NameSpace.MOD.optionalDefault, false);

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? MTPTagsInit.optionalTag(BuiltInRegistries.f_256975_, id) : TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        public static void register() {
        }
    }

    public static enum NameSpace {
        MOD("moderntrainparts", false, true),
        FORGE("forge");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

