/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.wire;

import com.dugkse.moderntrainparts.config.MTPConfigs;
import com.dugkse.moderntrainparts.content.wire.WireBlock;
import com.dugkse.moderntrainparts.content.wire.WireBlockEntity;
import com.dugkse.moderntrainparts.init.MTPPartialModels;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class WireEntityRenderer
extends SafeBlockEntityRenderer<WireBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public WireEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    protected void renderSafe(WireBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        BlockState blockState = te.m_58900_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110451_());
        SuperByteBuffer wireHanger = CachedBufferer.partial((PartialModel)MTPPartialModels.WIRE_HANGER, (BlockState)blockState).disableDiffuse();
        SuperByteBuffer wireTop = CachedBufferer.partial((PartialModel)MTPPartialModels.WIRE_TOP, (BlockState)blockState).disableDiffuse();
        SuperByteBuffer wireBtm = CachedBufferer.partial((PartialModel)MTPPartialModels.WIRE_BTM, (BlockState)blockState).disableDiffuse();
        SuperByteBuffer wireCorner = CachedBufferer.partial((PartialModel)MTPPartialModels.WIRE_CORNER, (BlockState)blockState).disableDiffuse();
        float length = te.getLength();
        float orientation_horizontal = te.getHorizontalOrientation();
        float orientation_vertical = te.getVerticalOrientation();
        BlockPos begin = te.m_58899_();
        BlockPos end = te.end_position;
        float offsetx = end.m_123341_();
        float offsety = end.m_123342_();
        float offsetz = end.m_123343_();
        double randomOffsety = te.randomOffsety;
        ms.m_85836_();
        ms.m_85837_(0.0, randomOffsety, 0.0);
        ((SuperByteBuffer)((SuperByteBuffer)wireBtm.translate(0.5, 0.0, 0.5).rotateYRadians((double)(-orientation_horizontal))).rotateZRadians((double)orientation_vertical)).translate(0.0, 0.0, -0.5).scale(length, 1.0f, 1.0f).renderInto(ms, buffer);
        ((SuperByteBuffer)((SuperByteBuffer)wireTop.translate(0.5, 1.0, 0.5).rotateYRadians((double)(-orientation_horizontal))).rotateZRadians((double)orientation_vertical)).scale(length, 1.0f, 1.0f).translate(0.0, -1.0, -0.5).renderInto(ms, buffer);
        double beginCoor = 0.0;
        double endCoor = 0.0;
        double angle = 0.0;
        double dir = 1.0;
        double yDiff = offsety;
        float pi4 = (float)WireBlock.PI4;
        if (orientation_horizontal <= pi4 && orientation_horizontal >= -pi4) {
            beginCoor = begin.m_123341_();
            endCoor = end.m_123341_();
            angle = Math.sqrt(Math.pow(Math.tan(orientation_horizontal), 2.0) + 1.0);
        } else if (orientation_horizontal > pi4 && orientation_horizontal < 3.0f * pi4) {
            beginCoor = begin.m_123343_();
            endCoor = end.m_123343_();
            angle = Math.sqrt(Math.pow(1.0 / Math.tan(orientation_horizontal), 2.0) + 1.0);
        } else if (orientation_horizontal > -3.0f * pi4 && orientation_horizontal < -pi4) {
            beginCoor = begin.m_123343_();
            endCoor = -end.m_123343_();
            dir = -1.0;
            angle = Math.sqrt(Math.pow(1.0 / Math.tan(orientation_horizontal), 2.0) + 1.0);
        } else if (orientation_horizontal >= 3.0f * pi4 || orientation_horizontal <= -3.0f * pi4) {
            beginCoor = begin.m_123341_();
            endCoor = -end.m_123341_();
            dir = -1.0;
            angle = Math.sqrt(Math.pow(Math.tan(orientation_horizontal), 2.0) + 1.0);
        }
        for (double x = 0.0; x <= endCoor; x += 1.0) {
            if ((beginCoor + x * dir) % (double)((Integer)MTPConfigs.client().WIRE_HANGER_SPACING.get()).intValue() != 0.0) continue;
            ((SuperByteBuffer)wireHanger.disableDiffuse().translate(0.5, 0.0, 0.5).rotateYRadians((double)(-orientation_horizontal))).translate(angle * (x - 0.5), (double)offsety * x / endCoor - 0.0625, -0.5).scale(1.0f, 1.125f, 1.0f).renderInto(ms, buffer);
        }
        ms.m_85849_();
        if (orientation_vertical == 0.0f) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wireCorner.translate(0.5, 0.0, 0.5).rotateYRadians((double)(-orientation_horizontal))).rotateZRadians((double)orientation_vertical)).translateBack(0.5, 0.0, 0.5)).translateY(randomOffsety)).renderInto(ms, buffer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wireCorner.disableDiffuse().translate((double)offsetx, (double)offsety, (double)offsetz).translate(0.5, 0.0, 0.5).rotateYRadians((double)(-orientation_horizontal))).rotateZRadians((double)orientation_vertical)).translateBack(0.5, 0.0, 0.5)).translateY(randomOffsety)).renderInto(ms, buffer);
        }
    }

    public boolean shouldRenderOffScreen(WireBlockEntity pBlockEntity) {
        return true;
    }

    public int m_142163_() {
        return 192;
    }
}

