/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.pantograph;

import com.dugkse.moderntrainparts.content.pantograph.PantographBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PantographTileEntity
extends SmartBlockEntity {
    public LerpedFloat animationProgress = LerpedFloat.linear();
    public static float speed = 0.02f;
    public boolean goingUp = true;
    private boolean redstoneControlled = false;
    private boolean booleanLastState = false;

    public PantographTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        if (((Boolean)blockState.m_61143_((Property)PantographBlock.UP)).booleanValue()) {
            this.booleanLastState = true;
            PantographTileEntity.animationChase(1.0f, this.animationProgress);
            this.animationProgress.setValue(1.0);
            this.animationProgress.setValue(1.0);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (clientPacket) {
            this.animationProgress.setValue((double)tag.m_128457_("animationProgress"));
            this.goingUp = tag.m_128471_("goingUp");
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        if (clientPacket) {
            tag.m_128350_("animationProgress", this.animationProgress.getValue());
            tag.m_128379_("goingUp", this.goingUp);
        }
        super.write(tag, clientPacket);
    }

    public void tick() {
        super.tick();
        if ((Boolean)this.m_58900_().m_61143_((Property)PantographBlock.UP) != this.booleanLastState) {
            this.booleanLastState = !this.booleanLastState;
            this.move(this.booleanLastState);
        }
        this.animationProgress.tickChaser();
        boolean hasRedstone = this.f_58857_.m_276867_(this.m_58899_());
        if (hasRedstone) {
            this.redstoneControlled = true;
            this.move(true);
        } else if (this.redstoneControlled) {
            this.move(false);
            this.redstoneControlled = false;
        }
    }

    public BlockEntityType<?> m_58903_() {
        return super.m_58903_();
    }

    public void move(boolean up) {
        this.goingUp = up;
        if (up) {
            PantographTileEntity.animationChase(1.0f, this.animationProgress);
        } else {
            PantographTileEntity.animationChase(0.0f, this.animationProgress);
        }
    }

    public void move() {
        this.move(this.animationProgress.getChaseTarget() <= 0.0f);
    }

    public static void animationChase(float goal, LerpedFloat animationProgress) {
        animationProgress.chase((double)goal, (double)speed, LerpedFloat.Chaser.LINEAR);
    }
}

