/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.containers;

import com.dugkse.moderntrainparts.content.containers.ContainerBlock;
import com.dugkse.moderntrainparts.content.containers.ContainerWall;
import com.dugkse.moderntrainparts.init.MTPBlockinit;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;

public class ContainerItem
extends Item {
    private final Integer color;

    protected SoundEvent getPlaceSound(BlockState state) {
        return state.m_60827_().m_56777_();
    }

    public ContainerItem(Block block, Item.Properties properties, Integer color) {
        super(properties);
        this.color = color;
    }

    public InteractionResult m_6225_(@NotNull UseOnContext p_40581_) {
        InteractionResult interactionresult = this.place(new BlockPlaceContext(p_40581_));
        if (!interactionresult.m_19077_() && this.m_41472_()) {
            InteractionResult interactionresult1 = this.m_7203_(p_40581_.m_43725_(), p_40581_.m_43723_(), p_40581_.m_43724_()).m_19089_();
            return interactionresult1 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionresult1;
        }
        return interactionresult;
    }

    public InteractionResult place(BlockPlaceContext p_40577_) {
        if (!p_40577_.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockplacecontext = this.updatePlacementContext(p_40577_);
        if (blockplacecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockplacecontext);
        BlockPos blockpos = ((ContainerWall)((Object)MTPBlockinit.CONTAINER_WALL.get())).getPosForPlacement(blockplacecontext).m_7495_();
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockplacecontext, blockstate, blockpos)) {
            return InteractionResult.FAIL;
        }
        Level level = blockplacecontext.m_43725_();
        Player player = blockplacecontext.m_43723_();
        ItemStack itemstack = blockplacecontext.m_43722_();
        BlockState blockstate1 = level.m_8055_(blockpos);
        if (blockstate1.m_60713_(blockstate.m_60734_())) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, level, itemstack, blockstate1);
            this.updateCustomBlockEntityTag(blockpos, level, player, itemstack, blockstate1);
            blockstate1.m_60734_().m_6402_(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
        SoundType soundtype = blockstate1.m_60827_();
        level.m_5594_(player, blockpos, this.getPlaceSound(blockstate1), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext p_40609_) {
        return p_40609_;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos p_40597_, Level p_40598_, @Nullable Player p_40599_, ItemStack p_40600_, BlockState p_40601_) {
        return ContainerItem.updateCustomBlockEntityTag(p_40598_, p_40599_, p_40597_, p_40600_);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext p_40613_) {
        BlockState blockstate = ((ContainerWall)((Object)MTPBlockinit.CONTAINER_WALL.get())).m_5573_(p_40613_);
        return blockstate != null && this.canPlace(p_40613_, blockstate) ? blockstate : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos p_40603_, Level p_40604_, ItemStack p_40605_, BlockState p_40606_) {
        BlockState blockstate = p_40606_;
        CompoundTag compoundtag = p_40605_.m_41783_();
        if (compoundtag != null) {
            CompoundTag compoundTag1 = compoundtag.m_128469_("BlockStateTag");
            StateDefinition statedefinition = p_40606_.m_60734_().m_49965_();
            for (String s : compoundTag1.m_128431_()) {
                Property property = statedefinition.m_61081_(s);
                if (property == null) continue;
                String s1 = Objects.requireNonNull(compoundTag1.m_128423_(s)).m_7916_();
                blockstate = ContainerItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != p_40606_) {
            p_40604_.m_7731_(p_40603_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState p_40594_, Property<T> p_40595_, String p_40596_) {
        return p_40595_.m_6215_(p_40596_).map(p_40592_ -> (BlockState)p_40594_.m_61124_(p_40595_, p_40592_)).orElse(p_40594_);
    }

    protected boolean canPlace(BlockPlaceContext p_40611_, BlockState p_40612_) {
        Player player = p_40611_.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return (!this.mustSurvive() || p_40612_.m_60710_((LevelReader)p_40611_.m_43725_(), p_40611_.m_8083_())) && p_40611_.m_43725_().m_45752_(p_40612_, p_40611_.m_8083_(), collisioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    public static boolean updateCustomBlockEntityTag(Level p_40583_, @Nullable Player p_40584_, BlockPos p_40585_, ItemStack p_40586_) {
        BlockEntity blockentity;
        CompoundTag compoundtag;
        MinecraftServer minecraftserver = p_40583_.m_7654_();
        if (minecraftserver != null && (compoundtag = ContainerItem.getBlockEntityData(p_40586_)) != null && (blockentity = p_40583_.m_7702_(p_40585_)) != null) {
            if (!(p_40583_.f_46443_ || !blockentity.m_6326_() || p_40584_ != null && p_40584_.m_36337_())) {
                return false;
            }
            CompoundTag compoundtag1 = blockentity.m_187482_();
            CompoundTag compoundtag2 = compoundtag1.m_6426_();
            compoundtag1.m_128391_(compoundtag);
            if (!compoundtag1.equals((Object)compoundtag2)) {
                blockentity.m_142466_(compoundtag1);
                blockentity.m_6596_();
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static CompoundTag getBlockEntityData(ItemStack p_186337_) {
        return p_186337_.m_41737_("BlockEntityTag");
    }

    public static void setBlockEntityData(ItemStack p_186339_, BlockEntityType<?> p_186340_, CompoundTag p_186341_) {
        if (p_186341_.m_128456_()) {
            p_186339_.m_41749_("BlockEntityTag");
        } else {
            BlockEntity.m_187468_((CompoundTag)p_186341_, p_186340_);
            p_186339_.m_41700_("BlockEntityTag", (Tag)p_186341_);
        }
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state, BlockPos pos) {
        if (state.m_60734_() instanceof ContainerBlock) {
            return context.m_43725_().m_7731_(pos, (BlockState)state.m_61124_((Property)ContainerBlock.COLOR, (Comparable)this.color), 11);
        }
        return context.m_43725_().m_7731_(pos, (BlockState)MTPBlockinit.CONTAINER_WALL.getDefaultState().m_61124_((Property)ContainerBlock.COLOR, (Comparable)this.color), 11);
    }
}

