/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.bulkStorage.forge;

import com.dugkse.moderntrainparts.config.MTPConfigs;
import com.dugkse.moderntrainparts.content.bulkStorage.BulkStorageBlockEntity;
import com.dugkse.moderntrainparts.content.bulkStorage.packets.BulkStorageFilledPacket;
import com.dugkse.moderntrainparts.content.bulkStorage.packets.BulkStorageMaterialPacket;
import com.dugkse.moderntrainparts.init.MTPPacketsInit;
import com.dugkse.moderntrainparts.multiloader.PlayerSelection;
import com.dugkse.moderntrainparts.multiloader.S2CPacket;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class BulkStorageBlockEntityImpl
extends BulkStorageBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    private LazyOptional<IItemHandler> itemCapability;
    public ItemStackHandler inventory;

    @Override
    protected void ClearItemCapabalitiy() {
        this.itemCapability = null;
    }

    protected BulkStorageBlockEntityImpl(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.inventory = new ItemStackHandler((Integer)MTPConfigs.server().BULK_STORAGE_CAPACITY.get()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BulkStorageBlockEntityImpl.this.updateComparators();
                BulkStorageBlockEntityImpl controller = BulkStorageBlockEntityImpl.this.getControllerBE();
                if (controller != null) {
                    controller.updateInventory = true;
                }
            }

            public boolean isItemValid(int slot, ItemStack resource) {
                if (!(resource.m_41720_() instanceof BlockItem)) {
                    return false;
                }
                BlockState state = BulkStorageBlockEntityImpl.this.material;
                BulkStorageBlockEntityImpl entity = BulkStorageBlockEntityImpl.this.getControllerBE();
                if (entity != null) {
                    state = entity.material;
                }
                if (state.m_60734_() == Blocks.f_50016_) {
                    return true;
                }
                return state.m_60734_() == ((BlockItem)resource.m_41720_()).m_40614_();
            }
        };
        this.ClearItemCapabalitiy();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isItemHandlerCap(cap)) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void updateInventory() {
        BlockState prevMaterial = this.material;
        int filled = 0;
        int space = 0;
        LazyOptional capability = this.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!capability.isPresent()) {
            return;
        }
        IItemHandler handler = (IItemHandler)capability.orElse(null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            filled += stack.m_41613_();
            space += handler.getSlotLimit(i);
            if (stack.m_41619_()) continue;
            this.material = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
        }
        this.filledpercent = space >= 1 ? (double)filled / (double)space : 0.0;
        if (filled == 0) {
            this.material = Blocks.f_50016_.m_49966_();
        }
        if (this.material.m_60734_() != Blocks.f_50016_) {
            this.setLastMaterial(this.material);
        }
        if (prevMaterial != this.material) {
            MTPPacketsInit.PACKETS.sendTo(PlayerSelection.tracking((BlockEntity)this), (S2CPacket)new BulkStorageMaterialPacket(this.material, this.getController()));
        }
        MTPPacketsInit.PACKETS.sendTo(PlayerSelection.tracking((BlockEntity)this), (S2CPacket)new BulkStorageFilledPacket(this.filledpercent, this.getController()));
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public IItemHandler getItemStorage() {
        this.initCapability();
        return (IItemHandler)this.getControllerBE().itemCapability.resolve().get();
    }

    @Override
    @Nullable
    public BulkStorageBlockEntityImpl getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.controller);
        if (tileEntity instanceof BulkStorageBlockEntityImpl) {
            return (BulkStorageBlockEntityImpl)tileEntity;
        }
        return null;
    }

    @Override
    protected void initCapability() {
        if (this.itemCapability != null) {
            return;
        }
        if (!this.isController()) {
            BulkStorageBlockEntityImpl controllerTE = this.getControllerBE();
            if (controllerTE == null) {
                return;
            }
            controllerTE.initCapability();
            this.itemCapability = controllerTE.itemCapability;
            return;
        }
        Object[] invs = new ItemStackHandler[this.length];
        Arrays.fill(invs, new ItemStackHandler());
        ArrayList<BulkStorageBlockEntityImpl> connectedStorages = new ArrayList<BulkStorageBlockEntityImpl>();
        Stack<BulkStorageBlockEntityImpl> traversingStorages = new Stack<BulkStorageBlockEntityImpl>();
        traversingStorages.add(this);
        while (!traversingStorages.isEmpty() && connectedStorages.size() < this.length) {
            BulkStorageBlockEntityImpl storage = (BulkStorageBlockEntityImpl)((Object)traversingStorages.pop());
            invs[connectedStorages.size()] = storage != null ? storage.inventory : new ItemStackHandler();
            connectedStorages.add(storage);
            BlockPos storage_pos = storage.m_58899_();
            for (Direction d : Direction.values()) {
                BlockEntity te = this.f_58857_.m_7702_(storage_pos.m_121945_(d));
                if (!(te instanceof BulkStorageBlockEntity) || connectedStorages.contains(te)) continue;
                traversingStorages.add((BulkStorageBlockEntityImpl)te);
            }
        }
        VersionedInventoryWrapper itemHandler = new VersionedInventoryWrapper((IItemHandlerModifiable)new CombinedInvWrapper((IItemHandlerModifiable[])invs));
        this.itemCapability = LazyOptional.of(() -> BulkStorageBlockEntityImpl.lambda$initCapability$0((IItemHandler)itemHandler));
    }

    public static BulkStorageBlockEntity create(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        return new BulkStorageBlockEntityImpl(tileEntityTypeIn, pos, state);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        }
        super.read(compound, clientPacket);
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (!clientPacket) {
            compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : ItemStack.f_41583_);
        }
    }

    public int getMaxWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public void setHeight(int height) {
    }

    public int getWidth() {
        return 0;
    }

    public void setWidth(int width) {
    }

    private static /* synthetic */ IItemHandler lambda$initCapability$0(IItemHandler itemHandler) {
        return itemHandler;
    }
}

