/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.bulkStorage;

import com.dugkse.moderntrainparts.content.bulkStorage.BulkStorageBlock;
import com.dugkse.moderntrainparts.content.bulkStorage.forge.BulkStorageBlockEntityImpl;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BulkStorageBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected boolean isInContraption = false;
    protected int length = 1;
    protected Direction.Axis axis;
    protected double minHeight = 0.0;
    protected double maxHeight = 1.0;
    protected double filledpercent;
    protected char direction;
    protected boolean updateInventory;
    protected BlockState material = Blocks.f_50016_.m_49966_();
    protected BlockState lastMaterial;

    protected abstract void ClearItemCapabalitiy();

    protected abstract void updateInventory();

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BulkStorageBlockEntity create(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        void var2_2;
        void var1_1;
        return BulkStorageBlockEntityImpl.create(tileEntityTypeIn, (BlockPos)var1_1, (BlockState)var2_2);
    }

    public BulkStorageBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        this.initializeMultiblockIfNecessary();
    }

    public static void splitMultiblock(BulkStorageBlockEntity be) {
        ArrayList<BulkStorageBlockEntity> connectedStorages = new ArrayList<BulkStorageBlockEntity>();
        Stack<BulkStorageBlockEntity> traversingStorages = new Stack<BulkStorageBlockEntity>();
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        BlockEntity controller = level.m_7702_(be.getController());
        if (!(controller instanceof BulkStorageBlockEntity) || controller.m_58901_()) {
            return;
        }
        traversingStorages.add((BulkStorageBlockEntity)controller);
        while (!traversingStorages.isEmpty()) {
            BulkStorageBlockEntity storage = (BulkStorageBlockEntity)((Object)traversingStorages.pop());
            storage.removeController(true);
            connectedStorages.add(storage);
            BlockPos storage_pos = storage.m_58899_();
            for (Direction d : Direction.values()) {
                BlockEntity te = level.m_7702_(storage_pos.m_121945_(d));
                if (!(te instanceof BulkStorageBlockEntity) || connectedStorages.contains(te) || te.m_58901_()) continue;
                traversingStorages.add((BulkStorageBlockEntity)te);
            }
        }
    }

    private void initializeMultiblockIfNecessary() {
        ArrayList<BulkStorageBlockEntity> connectedStorages = new ArrayList<BulkStorageBlockEntity>();
        Stack<BulkStorageBlockEntity> traversingStorages = new Stack<BulkStorageBlockEntity>();
        HashMap<Integer, Integer> storagesAtHeight = new HashMap<Integer, Integer>();
        int lowestHeight = Integer.MAX_VALUE;
        BulkStorageBlockEntity controller = this;
        traversingStorages.add(this);
        while (!traversingStorages.isEmpty()) {
            BulkStorageBlockEntity storage = (BulkStorageBlockEntity)((Object)traversingStorages.pop());
            if (storage.isController()) {
                controller = storage;
            }
            connectedStorages.add(storage);
            BlockPos storage_pos = storage.m_58899_();
            if (storagesAtHeight.containsKey(storage_pos.m_123342_())) {
                storagesAtHeight.put(storage_pos.m_123342_(), 1 + (Integer)storagesAtHeight.get(storage_pos.m_123342_()));
            } else {
                storagesAtHeight.put(storage_pos.m_123342_(), 1);
            }
            if (storage_pos.m_123342_() < lowestHeight) {
                lowestHeight = storage_pos.m_123342_();
            }
            for (Direction d : Direction.values()) {
                BlockEntity te = this.f_58857_.m_7702_(storage_pos.m_121945_(d));
                if (!(te instanceof BulkStorageBlockEntity) || connectedStorages.contains(te)) continue;
                traversingStorages.add((BulkStorageBlockEntity)te);
            }
        }
        System.out.println("Setting master to " + controller.m_58899_() + " for " + connectedStorages.size() + " blocks");
        int Length = connectedStorages.size();
        for (BulkStorageBlockEntity storage : connectedStorages) {
            storage.setController(controller.m_58899_());
            storage.preventConnectivityUpdate();
            storage.setLength(Length);
            storage.notifyMultiUpdated();
            storage.setMaxHeight((double)((Integer)storagesAtHeight.get(storage.m_58899_().m_123342_())).intValue() / (double)Length);
            storage.setMinHeight((double)this.getMinHeight(storagesAtHeight, lowestHeight, storage.m_58899_().m_123342_()) / (double)Length);
        }
        controller.ClearItemCapabalitiy();
        controller.updateInventory();
    }

    public void setUpdateConnectivity() {
        BulkStorageBlockEntity controller = this.getControllerBE();
        if (controller != null) {
            controller.updateConnectivity();
        }
    }

    public void setMaxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setMinHeight(double minHeight) {
        this.minHeight = minHeight;
    }

    private int getMinHeight(Map<Integer, Integer> storagesAtHeight, int lowestHeight, int curHeight) {
        if (curHeight == lowestHeight) {
            return 0;
        }
        return storagesAtHeight.get(curHeight - 1) + this.getMinHeight(storagesAtHeight, lowestHeight, curHeight - 1);
    }

    protected void updateComparators() {
        BulkStorageBlockEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            return;
        }
        BlockPos pos = controllerTE.m_58899_();
    }

    public double getFilledpercent() {
        double val;
        BulkStorageBlockEntity controllerTE = this.getControllerBE();
        double fill = this.filledpercent;
        if (controllerTE != null) {
            fill = controllerTE.filledpercent;
        }
        if ((val = (fill - this.minHeight) / this.maxHeight) < 0.0) {
            return 0.0;
        }
        if (val > 1.0) {
            return 1.0;
        }
        return val;
    }

    public void setFilledpercent(double percent) {
        BulkStorageBlockEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            this.filledpercent = percent;
            return;
        }
        controllerTE.filledpercent = percent;
    }

    public BlockState getMaterial() {
        BulkStorageBlockEntity controllerTE = this.getControllerBE();
        BlockState curMaterial = this.material;
        BlockState lastMat = this.lastMaterial;
        if (controllerTE != null) {
            curMaterial = controllerTE.material;
            lastMat = controllerTE.lastMaterial;
            this.material = curMaterial;
            this.lastMaterial = lastMat;
        }
        if (curMaterial.m_60734_() == Blocks.f_50016_ && lastMat != null) {
            return lastMat;
        }
        return curMaterial;
    }

    public void setMaterial(BlockState state) {
        BulkStorageBlockEntity controllerTE = this.getControllerBE();
        this.material = state;
        if (controllerTE == null) {
            return;
        }
        controllerTE.material = state;
    }

    public void setLastMaterial(BlockState state) {
        BulkStorageBlockEntity controllerTe = this.getControllerBE();
        this.lastMaterial = state;
        if (controllerTe == null) {
            return;
        }
        controllerTe.lastMaterial = state;
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.updateInventory && !this.m_58901_()) {
            this.updateInventory();
        }
    }

    public void rotate(Direction facing) {
        if (!this.isController()) {
            this.getControllerBE().rotate(facing);
        }
        switch (facing) {
            case UP: 
            case DOWN: {
                this.direction = (char)121;
                break;
            }
            case EAST: 
            case WEST: {
                this.direction = (char)120;
                break;
            }
            case SOUTH: 
            case NORTH: {
                this.direction = (char)122;
            }
        }
    }

    public Direction getFacing() {
        return BulkStorageBlockEntity.getFacing(this.getControllerBE().direction);
    }

    public static Direction getFacing(char dir) {
        switch (dir) {
            case 'x': {
                return Direction.EAST;
            }
            case 'z': {
                return Direction.SOUTH;
            }
        }
        return Direction.UP;
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    public BulkStorageBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.controller);
        if (tileEntity instanceof BulkStorageBlockEntity) {
            return (BulkStorageBlockEntity)tileEntity;
        }
        return null;
    }

    public void removeController(boolean keepContents) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.length = 1;
        this.material = Blocks.f_50016_.m_49966_();
        this.minHeight = 0.0;
        this.maxHeight = 1.0;
        BlockState state = this.m_58900_();
        if (BulkStorageBlock.isStorage(state)) {
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.ClearItemCapabalitiy();
        this.m_6596_();
        this.sendData();
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.ClearItemCapabalitiy();
        this.m_6596_();
        this.sendData();
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevLength = this.length;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        this.filledpercent = compound.m_128459_("FilledPercentage");
        this.minHeight = compound.m_128459_("MinHeight");
        this.maxHeight = compound.m_128459_("MaxHeight");
        this.direction = (char)compound.m_128445_("Direction");
        this.material = NbtUtils.m_247651_((HolderGetter)this.blockHolderGetter(), (CompoundTag)compound.m_128469_("Material"));
        if (compound.m_128441_("LastMaterial")) {
            this.lastMaterial = NbtUtils.m_247651_((HolderGetter)this.blockHolderGetter(), (CompoundTag)compound.m_128469_("LastMaterial"));
        }
        if (this.isController()) {
            this.length = compound.m_128451_("Length");
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (this.m_58898_() && (changeOfController || prevLength != this.length)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Length", this.length);
        }
        compound.m_128347_("FilledPercentage", this.filledpercent);
        compound.m_128347_("MinHeight", this.minHeight);
        compound.m_128347_("MaxHeight", this.maxHeight);
        compound.m_128344_("Direction", (byte)this.direction);
        compound.m_128365_("Material", (Tag)NbtUtils.m_129202_((BlockState)this.material));
        if (this.lastMaterial != null) {
            compound.m_128365_("LastMaterial", (Tag)NbtUtils.m_129202_((BlockState)this.lastMaterial));
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            compound.m_128359_("StorageType", "CombinedInv");
        }
    }

    protected abstract void initCapability();

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (BulkStorageBlock.isStorage(state)) {
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        this.ClearItemCapabalitiy();
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf((BlockEntity)this);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int height) {
        this.length = height;
    }

    public boolean hasInventory() {
        return true;
    }

    public void destroy() {
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("FilledPercentage", this.filledpercent);
        tag.m_128365_("Material", (Tag)NbtUtils.m_129202_((BlockState)this.material));
        if (this.direction != '\u0000') {
            tag.m_128344_("Direction", (byte)this.direction);
        }
        if (this.lastMaterial != null) {
            tag.m_128365_("LastMaterial", (Tag)NbtUtils.m_129202_((BlockState)this.lastMaterial));
        }
        return this.writeClient(tag);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag.m_128441_("FilledPercentage")) {
            this.filledpercent = tag.m_128459_("FilledPercentage");
        }
        if (tag.m_128441_("Material")) {
            this.material = NbtUtils.m_247651_((HolderGetter)this.blockHolderGetter(), (CompoundTag)tag.m_128469_("Material"));
        }
        if (tag.m_128441_("LastMaterial")) {
            this.lastMaterial = NbtUtils.m_247651_((HolderGetter)this.blockHolderGetter(), (CompoundTag)tag.m_128469_("LastMaterial"));
        }
        if (tag.m_128441_("Direction")) {
            this.direction = (char)tag.m_128445_("Direction");
        }
        super.onDataPacket(connection, packet);
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return 10;
    }
}

