/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.config;

import com.dugkse.moderntrainparts.config.MTPClientConfig;
import com.dugkse.moderntrainparts.config.MTPCommonConfig;
import com.dugkse.moderntrainparts.config.MTPServerConfig;
import com.simibubi.create.foundation.config.ConfigBase;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class MTPConfigs {
    @ApiStatus.Internal
    public static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static MTPClientConfig client;
    private static MTPServerConfig server;
    private static MTPCommonConfig common;

    public static MTPClientConfig client() {
        return client;
    }

    public static MTPServerConfig server() {
        return server;
    }

    public static MTPCommonConfig common() {
        return common;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    @ApiStatus.Internal
    public static void registerCommon() {
        client = MTPConfigs.register(MTPClientConfig::new, ModConfig.Type.CLIENT);
        common = MTPConfigs.register(MTPCommonConfig::new, ModConfig.Type.COMMON);
        server = MTPConfigs.register(MTPServerConfig::new, ModConfig.Type.SERVER);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }

    public static String migrateClient(String contents) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("conductorSpyShader", "useConductorSpyShader");
        m.put("extendedCouplerDebug", "showExtendedCouplerDebug");
        m.put("trackOverlayOffset", "trackOverlayOffset");
        m.put("skipClientsideDerailing", "skipClientDerailing");
        m.put("trainSmokePercentage", "smoke.smokePercentage");
        m.put("trainSmokeLifetime", "smoke.smokeLifetime");
        m.put("smokeTextureQuality", "smoke.smokeQuality");
        m.put("journeymapObsolescenceCheckTicks", "journeymap.removeObsoleteRate");
        m.put("journeymapUpdateTicks", "journeymap.updateRate");
        HashMap<String, String> trueMap = new HashMap<String, String>();
        for (Map.Entry entry : m.entrySet()) {
            trueMap.put("general." + (String)entry.getKey(), "client." + (String)entry.getValue());
        }
        return MTPConfigs.migrate(contents, trueMap);
    }

    public static String migrateCommon(String contents) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("registerMissingTracks", "registerMissingTracks");
        m.put("disableDatafixer", "disableDatafixer");
        HashMap<String, String> trueMap = new HashMap<String, String>();
        for (Map.Entry entry : m.entrySet()) {
            trueMap.put("general." + (String)entry.getKey(), (String)entry.getValue());
        }
        return MTPConfigs.migrate(contents, trueMap);
    }

    @ApiStatus.Internal
    public static String migrate(String contents, Map<String, String> pathMap) {
        TomlGroup root = TomlGroup.root();
        Object keyPrefix = "";
        List<String> lines = contents.lines().toList();
        for (String line : lines) {
            String[] pieces;
            String key;
            if (line.isEmpty()) continue;
            int commentIdx = line.indexOf(35);
            if (commentIdx != -1) {
                line = line.substring(0, commentIdx);
            }
            if ((line = line.trim().replaceAll(" ", "")).isEmpty()) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                keyPrefix = line.substring(1, line.length() - 1) + ".";
                continue;
            }
            if (!line.contains("=") || !pathMap.containsKey(key = (String)keyPrefix + (pieces = line.split("=", 2))[0].trim())) continue;
            root.add(pathMap.get(key), pieces[1].trim());
        }
        return root.write();
    }

    private static class TomlGroup {
        private final Map<String, TomlGroup> subgroups = new HashMap<String, TomlGroup>();
        private final Map<String, String> entries = new HashMap<String, String>();
        private final String path;

        private static TomlGroup root() {
            return new TomlGroup("");
        }

        private TomlGroup(String path) {
            this.path = path;
        }

        public boolean isRoot() {
            return this.path.isEmpty();
        }

        public void add(String key, String value) {
            if (!this.isRoot()) {
                throw new NotImplementedException();
            }
            String[] pieces = key.split("\\.");
            String subKey = pieces[pieces.length - 1];
            TomlGroup targetedGroup = this;
            for (int i = 0; i < pieces.length - 1; ++i) {
                targetedGroup = targetedGroup.getOrCreateSubGroup(pieces[i]);
            }
            targetedGroup.entries.put(subKey, value);
        }

        private TomlGroup getOrCreateSubGroup(String subKey) {
            return this.subgroups.computeIfAbsent(subKey, sk -> new TomlGroup((String)(this.path.isEmpty() ? sk : this.path + "." + sk)));
        }

        private void write(StringBuilder b) {
            if (!this.isRoot()) {
                b.append("\n[").append(this.path).append("]");
            }
            for (Map.Entry<String, String> entry : this.entries.entrySet()) {
                b.append("\n").append(entry.getKey()).append(" = ").append(entry.getValue());
            }
            for (TomlGroup subGroup : this.subgroups.values()) {
                subGroup.write(b);
            }
        }

        private String write() {
            StringBuilder b = new StringBuilder();
            b.append("# Automatically written by a converter");
            this.write(b);
            b.append("\n");
            return b.toString();
        }
    }
}

