/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.capability.v3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import fuzs.puzzleslib.api.capability.v3.CapabilityController;
import fuzs.puzzleslib.api.capability.v3.data.BlockEntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.EntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelChunkCapabilityKey;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.api.core.v1.ReflectionHelper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.impl.capability.v3.GlobalCapabilityRegister;
import fuzs.puzzleslib.impl.capability.v3.data.CapabilityAdapter;
import fuzs.puzzleslib.impl.capability.v3.data.ForgeBlockEntityCapabilityKey;
import fuzs.puzzleslib.impl.capability.v3.data.ForgeCapabilityKey;
import fuzs.puzzleslib.impl.capability.v3.data.ForgeEntityCapabilityKey;
import fuzs.puzzleslib.impl.capability.v3.data.ForgeLevelCapabilityKey;
import fuzs.puzzleslib.impl.capability.v3.data.ForgeLevelChunkCapabilityKey;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public final class ForgeCapabilityController
implements CapabilityController {
    private final Multimap<Class<?>, CapabilityData<?, ?>> capabilityData = Multimaps.newListMultimap((Map)Maps.newIdentityHashMap(), Lists::newArrayList);
    private final String modId;

    public ForgeCapabilityController(String modId) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.modId = modId;
        ModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> eventBus.addListener(this::onRegisterCapabilities));
    }

    @Override
    public <T extends Entity, C extends CapabilityComponent<T>> EntityCapabilityKey.Mutable<T, C> registerEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> entityType) {
        return this.registerCapability(Entity.class, identifier, capabilityType, capabilityFactory, entityType::isInstance, ForgeEntityCapabilityKey::new);
    }

    @Override
    public <T extends BlockEntity, C extends CapabilityComponent<T>> BlockEntityCapabilityKey<T, C> registerBlockEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> blockEntityType) {
        return this.registerCapability(BlockEntity.class, identifier, capabilityType, capabilityFactory, blockEntityType::isInstance, ForgeBlockEntityCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<LevelChunk>> LevelChunkCapabilityKey<C> registerLevelChunkCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return this.registerCapability(LevelChunk.class, identifier, capabilityType, capabilityFactory, ForgeLevelChunkCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<Level>> LevelCapabilityKey<C> registerLevelCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return this.registerCapability(Level.class, identifier, capabilityType, capabilityFactory, ForgeLevelCapabilityKey::new);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends ICapabilityProvider> holderType, String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, ForgeCapabilityKey.ForgeCapabilityKeyFactory<T, C, K> capabilityKeyFactory) {
        return this.registerCapability(holderType, identifier, capabilityType, capabilityFactory, holderType::isInstance, capabilityKeyFactory);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends ICapabilityProvider> holderType, String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Predicate<Object> filter, ForgeCapabilityKey.ForgeCapabilityKeyFactory<T, C, K> capabilityKeyFactory) {
        GlobalCapabilityRegister.testHolderType(holderType);
        ResourceLocation capabilityName = ResourceLocationHelper.fromNamespaceAndPath(this.modId, identifier);
        Capability capability = this.getCapability(capabilityType);
        Objects.requireNonNull(capability, "capability is null");
        Object capabilityKey = capabilityKeyFactory.apply(capabilityName, capability, filter, capabilityFactory);
        Function<Object, CapabilityAdapter> capabilityAdapterFactory = t -> {
            CapabilityComponent capabilityComponent = (CapabilityComponent)capabilityFactory.get();
            Objects.requireNonNull(capabilityComponent, "capability component is null");
            capabilityComponent.initialize(capabilityKey, t);
            return new CapabilityAdapter(capability, capabilityComponent);
        };
        CapabilityData<Object, C> capabilityData = new CapabilityData<Object, C>(capabilityName, capabilityType, filter, capabilityAdapterFactory);
        this.capabilityData.put(holderType, capabilityData);
        return capabilityKey;
    }

    private <T, C extends CapabilityComponent<T>> Capability<C> getCapability(Class<C> capabilityType) {
        try {
            Method method = ReflectionHelper.findMethod(CapabilityManager.class, "get", String.class, Boolean.TYPE);
            Objects.requireNonNull(method, "CapabilityManager::get is null");
            String internalName = Type.getInternalName(capabilityType);
            return MethodHandles.lookup().unreflect(method).invoke(CapabilityManager.INSTANCE, internalName, false);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent evt) {
        for (CapabilityData data : this.capabilityData.values()) {
            evt.register(data.type());
        }
    }

    @SubscribeEvent
    public <T> void onAttachCapabilities(AttachCapabilitiesEvent<?> evt) {
        Class holderType = (Class)evt.getGenericType();
        for (CapabilityData data : this.capabilityData.get((Object)holderType)) {
            if (!data.test(evt.getObject())) continue;
            evt.addCapability(data.identifier(), data.apply(evt.getObject()));
        }
    }

    private record CapabilityData<T, C extends CapabilityComponent<T>>(ResourceLocation identifier, Class<C> type, Predicate<Object> filter, Function<T, CapabilityAdapter<T, C>> factory) {
        public CapabilityAdapter<T, C> apply(T t) {
            return this.factory.apply(t);
        }

        public boolean test(@Nullable Object o) {
            return o != null && this.filter.test(o);
        }
    }
}

