/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.entity;

import net.freedinner.display.init.DisplayTags;
import net.freedinner.display.util.BlockAssociations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class AbstractDisplayEntity
extends LivingEntity {
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public long lastHit;

    public AbstractDisplayEntity(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.0f);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ListTag armor = new ListTag();
        for (ItemStack stack : this.armorItems) {
            CompoundTag atag = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(atag);
            }
            armor.add((Object)atag);
        }
        tag.m_128365_("ArmorItems", (Tag)armor);
        ListTag hands = new ListTag();
        for (ItemStack stack : this.handItems) {
            CompoundTag htag = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(htag);
            }
            hands.add((Object)htag);
        }
        tag.m_128365_("HandItems", (Tag)hands);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("ArmorItems", 9)) {
            ListTag armor = tag.m_128437_("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)ItemStack.m_41712_((CompoundTag)armor.m_128728_(i)));
            }
        }
        if (tag.m_128425_("HandItems", 9)) {
            ListTag hands = tag.m_128437_("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                this.handItems.set(j, (Object)ItemStack.m_41712_((CompoundTag)hands.m_128728_(j)));
            }
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 v, InteractionHand hand) {
        BlockPos pos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_());
        Level world = this.m_9236_();
        if (world instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)world;
            if (hand == InteractionHand.MAIN_HAND) {
                ItemStack stack = player.m_21120_(hand);
                ItemStack current = this.m_21205_();
                if (current.m_41619_()) {
                    Block target = BlockAssociations.getBlockFor(stack.m_41720_());
                    if (stack.m_204117_(DisplayTags.DISPLAYABLE) && this.isCorrectBlock(target)) {
                        ItemStack copy = stack.m_41777_();
                        copy.m_41764_(1);
                        this.m_21008_(InteractionHand.MAIN_HAND, copy);
                        this.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)target.m_5456_()));
                        lvl.m_5594_(null, pos, target.m_49966_().getSoundType((LevelReader)world, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        player.m_21011_(hand, true);
                        return InteractionResult.SUCCESS;
                    }
                } else if (player.m_21205_().m_41619_()) {
                    Block target = BlockAssociations.getBlockFor(current.m_41720_());
                    player.m_36356_(current);
                    current.m_41774_(1);
                    this.m_21206_().m_41774_(1);
                    lvl.m_5594_(null, pos, target.m_49966_().getSoundType((LevelReader)world, pos, (Entity)player).m_56775_(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                    player.m_21011_(hand, true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean m_6469_(DamageSource source, float f) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_() && source.m_7639_() != null) {
            if (source.m_19390_() || source.m_269533_(DamageTypeTags.f_268738_) || source.m_269533_(DamageTypeTags.f_268415_)) {
                this.m_6667_(source);
            } else {
                long i = this.m_9236_().m_46467_();
                if (i - this.lastHit > 5L) {
                    this.m_9236_().m_7605_((Entity)this, (byte)32);
                    this.m_146852_(GameEvent.f_223706_, source.m_7639_());
                    this.lastHit = i;
                } else {
                    this.m_6667_(source);
                }
                return true;
            }
        }
        return false;
    }

    public void m_6667_(DamageSource source) {
        Player player;
        super.m_6667_(source);
        Entity entity = source.m_7639_();
        boolean flag = entity instanceof Player && (player = (Player)entity).m_7500_();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
        this.showBreakingParticles();
        if (!flag) {
            ItemEntity target = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_142340_());
            target.m_32010_(10);
            this.m_9236_().m_7967_((Entity)target);
            if (!this.m_21205_().m_41619_()) {
                ItemEntity drop = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21205_());
                drop.m_32010_(10);
                this.m_9236_().m_7967_((Entity)drop);
            }
        }
        this.m_146870_();
    }

    public void m_7822_(byte b) {
        if (b == 32) {
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f, false);
                this.lastHit = this.m_9236_().m_46467_();
            }
        } else {
            super.m_7822_(b);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public Iterable<ItemStack> m_6167_() {
        return this.handItems;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        switch (slot.m_20743_()) {
            case HAND: {
                return (ItemStack)this.handItems.get(slot.m_20749_());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(slot.m_20749_());
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        this.m_181122_(stack);
        switch (slot.m_20743_()) {
            case HAND: {
                this.m_238392_(slot, (ItemStack)this.handItems.set(slot.m_20749_(), (Object)stack), stack);
                break;
            }
            case ARMOR: {
                this.m_238392_(slot, (ItemStack)this.armorItems.set(slot.m_20749_(), (Object)stack), stack);
            }
        }
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_11683_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    public boolean isCorrectBlock(Block target) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 1.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    private void showBreakingParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            lvl.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.35), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }
}

