/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode.shadow.cron;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CronExpression {
    private final String expr;
    private final SimpleField secondField;
    private final SimpleField minuteField;
    private final SimpleField hourField;
    private final DayOfWeekField dayOfWeekField;
    private final SimpleField monthField;
    private final DayOfMonthField dayOfMonthField;

    public CronExpression(String expr) {
        this(expr, true);
    }

    public CronExpression(String expr, boolean withSeconds) {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        this.expr = expr;
        int expectedParts = withSeconds ? 6 : 5;
        String[] parts = expr.split("\\s+");
        if (parts.length != expectedParts) {
            throw new IllegalArgumentException(String.format("Invalid cron expression [%s], expected %s field, got %s", expr, expectedParts, parts.length));
        }
        int ix = withSeconds ? 1 : 0;
        this.secondField = new SimpleField(CronFieldType.SECOND, withSeconds ? parts[0] : "0");
        this.minuteField = new SimpleField(CronFieldType.MINUTE, parts[ix++]);
        this.hourField = new SimpleField(CronFieldType.HOUR, parts[ix++]);
        this.dayOfMonthField = new DayOfMonthField(parts[ix++]);
        this.monthField = new SimpleField(CronFieldType.MONTH, parts[ix++]);
        this.dayOfWeekField = new DayOfWeekField(parts[ix++]);
    }

    public static CronExpression create(String expr) {
        return new CronExpression(expr, true);
    }

    public static CronExpression createWithoutSeconds(String expr) {
        return new CronExpression(expr, false);
    }

    public ZonedDateTime nextTimeAfter(ZonedDateTime afterTime) throws IllegalArgumentException {
        return this.nextTimeAfter(afterTime, afterTime.plusYears(4L));
    }

    public LocalDateTime nextLocalDateTimeAfter(LocalDateTime dateTime) throws IllegalArgumentException {
        return this.nextTimeAfter(ZonedDateTime.of(dateTime, ZoneId.systemDefault())).toLocalDateTime();
    }

    public ZonedDateTime nextTimeAfter(ZonedDateTime afterTime, long durationInMillis) throws IllegalArgumentException {
        return this.nextTimeAfter(afterTime, afterTime.plus(Duration.ofMillis(durationInMillis)));
    }

    public ZonedDateTime nextTimeAfter(ZonedDateTime afterTime, ZonedDateTime dateTimeBarrier) throws IllegalArgumentException {
        ZonedDateTime[] nextDateTime = new ZonedDateTime[]{afterTime.plusSeconds(1L).withNano(0)};
        do {
            CronExpression.checkIfDateTimeBarrierIsReached(nextDateTime[0], dateTimeBarrier);
        } while (!this.monthField.nextMatch(nextDateTime) || !this.findDay(nextDateTime, dateTimeBarrier) || !this.hourField.nextMatch(nextDateTime) || !this.minuteField.nextMatch(nextDateTime) || !this.secondField.nextMatch(nextDateTime));
        CronExpression.checkIfDateTimeBarrierIsReached(nextDateTime[0], dateTimeBarrier);
        return nextDateTime[0];
    }

    private boolean findDay(ZonedDateTime[] dateTime, ZonedDateTime dateTimeBarrier) {
        int month = dateTime[0].getMonthValue();
        while (!this.dayOfMonthField.matches(dateTime[0].toLocalDate()) || !this.dayOfWeekField.matches(dateTime[0].toLocalDate())) {
            dateTime[0] = dateTime[0].plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            if (dateTime[0].getMonthValue() == month) continue;
            return false;
        }
        return true;
    }

    private static void checkIfDateTimeBarrierIsReached(ZonedDateTime nextTime, ZonedDateTime dateTimeBarrier) throws IllegalArgumentException {
        if (nextTime.isAfter(dateTimeBarrier)) {
            throw new IllegalArgumentException("No next execution time could be determined that is before the limit of " + dateTimeBarrier);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.expr + ">";
    }

    static class DayOfMonthField
    extends BasicField {
        DayOfMonthField(String fieldExpr) {
            super(CronFieldType.DAY_OF_MONTH, fieldExpr);
        }

        boolean matches(LocalDate dato) {
            for (FieldPart part : this.parts) {
                if ("L".equals(part.modifier)) {
                    YearMonth ym = YearMonth.of(dato.getYear(), dato.getMonth().getValue());
                    return dato.getDayOfMonth() == ym.lengthOfMonth() - (part.from == -1 ? 0 : part.from);
                }
                if ("W".equals(part.modifier)) {
                    if (dato.getDayOfWeek().getValue() > 5) continue;
                    if (dato.getDayOfMonth() == part.from) {
                        return true;
                    }
                    if (dato.getDayOfWeek().getValue() == 5) {
                        return dato.plusDays(1L).getDayOfMonth() == part.from;
                    }
                    if (dato.getDayOfWeek().getValue() != 1) continue;
                    return dato.minusDays(1L).getDayOfMonth() == part.from;
                }
                if (!this.matches(dato.getDayOfMonth(), part)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void validatePart(FieldPart part) {
            if (part.modifier != null && !Arrays.asList("L", "W", "?").contains(part.modifier)) {
                throw new IllegalArgumentException(String.format("Invalid modifier [%s]", part.modifier));
            }
            if (part.incrementModifier != null && !"/".equals(part.incrementModifier)) {
                throw new IllegalArgumentException(String.format("Invalid increment modifier [%s]", part.incrementModifier));
            }
        }

        @Override
        protected boolean matches(int val, FieldPart part) {
            return "?".equals(part.modifier) || super.matches(val, part);
        }
    }

    static class DayOfWeekField
    extends BasicField {
        DayOfWeekField(String fieldExpr) {
            super(CronFieldType.DAY_OF_WEEK, fieldExpr);
        }

        boolean matches(LocalDate dato) {
            for (FieldPart part : this.parts) {
                if ("L".equals(part.modifier)) {
                    YearMonth ym = YearMonth.of(dato.getYear(), dato.getMonth().getValue());
                    return dato.getDayOfWeek() == DayOfWeek.of(part.from) && dato.getDayOfMonth() > ym.lengthOfMonth() - 7;
                }
                if ("#".equals(part.incrementModifier)) {
                    if (dato.getDayOfWeek() == DayOfWeek.of(part.from)) {
                        int num = dato.getDayOfMonth() / 7;
                        return part.increment == (dato.getDayOfMonth() % 7 == 0 ? num : num + 1);
                    }
                    return false;
                }
                if (!this.matches(dato.getDayOfWeek().getValue(), part)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int mapValue(String value) {
            return "0".equals(value) ? 7 : super.mapValue(value);
        }

        @Override
        protected boolean matches(int val, FieldPart part) {
            return "?".equals(part.modifier) || super.matches(val, part);
        }

        @Override
        protected void validatePart(FieldPart part) {
            if (part.modifier != null && !Arrays.asList("L", "?").contains(part.modifier)) {
                throw new IllegalArgumentException(String.format("Invalid modifier [%s]", part.modifier));
            }
            if (part.incrementModifier != null && !Arrays.asList("/", "#").contains(part.incrementModifier)) {
                throw new IllegalArgumentException(String.format("Invalid increment modifier [%s]", part.incrementModifier));
            }
        }
    }

    static class SimpleField
    extends BasicField {
        SimpleField(CronFieldType fieldType, String fieldExpr) {
            super(fieldType, fieldExpr);
        }

        public boolean matches(int val) {
            if (val >= this.fieldType.from && val <= this.fieldType.to) {
                for (FieldPart part : this.parts) {
                    if (!this.matches(val, part)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean nextMatch(ZonedDateTime[] dateTime) {
            int value = this.fieldType.getValue(dateTime[0]);
            for (FieldPart part : this.parts) {
                int nextMatch = this.nextMatch(value, part);
                if (nextMatch <= -1) continue;
                if (nextMatch != value) {
                    dateTime[0] = this.fieldType.setValue(dateTime[0], nextMatch);
                }
                return true;
            }
            dateTime[0] = this.fieldType.overflow(dateTime[0]);
            return false;
        }
    }

    static abstract class BasicField {
        private static final Pattern CRON_FIELD_REGEXP = Pattern.compile("(?:(?:(?<all>\\*)|(?<ignore>\\?)|(?<last>L)) | (?<start>[0-9]{1,2}|[a-z]{3})(?:(?<mod>[LW])| -(?<end>[0-9]{1,2}|[a-z]{3,3}))?)(?:(?<incmod>[/\\#])(?<inc>[0-9]{1,7}))?", 6);
        final CronFieldType fieldType;
        final List<FieldPart> parts = new ArrayList<FieldPart>();

        private BasicField(CronFieldType fieldType, String fieldExpr) {
            this.fieldType = fieldType;
            this.parse(fieldExpr);
        }

        private void parse(String fieldExpr) {
            String[] rangeParts;
            for (String rangePart : rangeParts = fieldExpr.split(",")) {
                Matcher m = CRON_FIELD_REGEXP.matcher(rangePart);
                if (!m.matches()) {
                    throw new IllegalArgumentException("Invalid cron field '" + rangePart + "' for field [" + (Object)((Object)this.fieldType) + "]");
                }
                String startNumber = m.group("start");
                String modifier = m.group("mod");
                String sluttNumber = m.group("end");
                String incrementModifier = m.group("incmod");
                String increment = m.group("inc");
                FieldPart part = new FieldPart();
                part.increment = 999;
                if (startNumber != null) {
                    part.from = this.mapValue(startNumber);
                    part.modifier = modifier;
                    if (sluttNumber != null) {
                        part.to = this.mapValue(sluttNumber);
                        part.increment = 1;
                    } else if (increment != null) {
                        part.to = this.fieldType.to;
                    } else {
                        part.to = part.from;
                    }
                } else if (m.group("all") != null) {
                    part.from = this.fieldType.from;
                    part.to = this.fieldType.to;
                    part.increment = 1;
                } else if (m.group("ignore") != null) {
                    part.modifier = m.group("ignore");
                } else if (m.group("last") != null) {
                    part.modifier = m.group("last");
                } else {
                    throw new IllegalArgumentException("Invalid cron part: " + rangePart);
                }
                if (increment != null) {
                    part.incrementModifier = incrementModifier;
                    part.increment = Integer.parseInt(increment);
                }
                this.validateRange(part);
                this.validatePart(part);
                this.parts.add(part);
            }
            Collections.sort(this.parts);
        }

        protected void validatePart(FieldPart part) {
            if (part.modifier != null) {
                throw new IllegalArgumentException(String.format("Invalid modifier [%s]", part.modifier));
            }
            if (part.incrementModifier != null && !"/".equals(part.incrementModifier)) {
                throw new IllegalArgumentException(String.format("Invalid increment modifier [%s]", part.incrementModifier));
            }
        }

        private void validateRange(FieldPart part) {
            if (part.from != -1 && part.from < this.fieldType.from || part.to != -1 && part.to > this.fieldType.to) {
                throw new IllegalArgumentException(String.format("Invalid interval [%s-%s], must be %s<=_<=%s", part.from, part.to, this.fieldType.from, this.fieldType.to));
            }
            if (part.from != -1 && part.to != -1 && part.from > part.to) {
                throw new IllegalArgumentException(String.format("Invalid interval [%s-%s].  Rolling periods are not supported (ex. 5-1, only 1-5) since this won't give a deterministic result. Must be %s<=_<=%s", part.from, part.to, this.fieldType.from, this.fieldType.to));
            }
        }

        protected int mapValue(String value) {
            int idx;
            if (this.fieldType.names != null && (idx = this.fieldType.names.indexOf(value.toUpperCase(Locale.getDefault()))) >= 0) {
                return idx + this.fieldType.from;
            }
            return Integer.parseInt(value);
        }

        protected boolean matches(int val, FieldPart part) {
            return val >= part.from && val <= part.to && (val - part.from) % part.increment == 0;
        }

        protected int nextMatch(int val, FieldPart part) {
            if (val > part.to) {
                return -1;
            }
            int nextPotential = Math.max(val, part.from);
            if (part.increment == 1 || nextPotential == part.from) {
                return nextPotential;
            }
            int remainder = (nextPotential - part.from) % part.increment;
            if (remainder != 0) {
                nextPotential += part.increment - remainder;
            }
            return nextPotential <= part.to ? nextPotential : -1;
        }
    }

    static class FieldPart
    implements Comparable<FieldPart> {
        private int from = -1;
        private int to = -1;
        private int increment = -1;
        private String modifier;
        private String incrementModifier;

        FieldPart() {
        }

        @Override
        public int compareTo(FieldPart o) {
            return Integer.compare(this.from, o.from);
        }
    }

    static enum CronFieldType {
        SECOND(0, 59, null){

            @Override
            int getValue(ZonedDateTime dateTime) {
                return dateTime.getSecond();
            }

            @Override
            ZonedDateTime setValue(ZonedDateTime dateTime, int value) {
                return dateTime.withSecond(value).withNano(0);
            }

            @Override
            ZonedDateTime overflow(ZonedDateTime dateTime) {
                return dateTime.plusMinutes(1L).withSecond(0).withNano(0);
            }
        }
        ,
        MINUTE(0, 59, null){

            @Override
            int getValue(ZonedDateTime dateTime) {
                return dateTime.getMinute();
            }

            @Override
            ZonedDateTime setValue(ZonedDateTime dateTime, int value) {
                return dateTime.withMinute(value).withSecond(0).withNano(0);
            }

            @Override
            ZonedDateTime overflow(ZonedDateTime dateTime) {
                return dateTime.plusHours(1L).withMinute(0).withSecond(0).withNano(0);
            }
        }
        ,
        HOUR(0, 23, null){

            @Override
            int getValue(ZonedDateTime dateTime) {
                return dateTime.getHour();
            }

            @Override
            ZonedDateTime setValue(ZonedDateTime dateTime, int value) {
                return dateTime.withHour(value).withMinute(0).withSecond(0).withNano(0);
            }

            @Override
            ZonedDateTime overflow(ZonedDateTime dateTime) {
                return dateTime.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            }
        }
        ,
        DAY_OF_MONTH(1, 31, null){

            @Override
            int getValue(ZonedDateTime dateTime) {
                return dateTime.getDayOfMonth();
            }

            @Override
            ZonedDateTime setValue(ZonedDateTime dateTime, int value) {
                return dateTime.withDayOfMonth(value).withHour(0).withMinute(0).withSecond(0).withNano(0);
            }

            @Override
            ZonedDateTime overflow(ZonedDateTime dateTime) {
                return dateTime.plusMonths(1L).withDayOfMonth(0).withHour(0).withMinute(0).withSecond(0).withNano(0);
            }
        }
        ,
        MONTH(1, 12, (List)Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC")){

            @Override
            int getValue(ZonedDateTime dateTime) {
                return dateTime.getMonthValue();
            }

            @Override
            ZonedDateTime setValue(ZonedDateTime dateTime, int value) {
                return dateTime.withMonth(value).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
            }

            @Override
            ZonedDateTime overflow(ZonedDateTime dateTime) {
                return dateTime.plusYears(1L).withMonth(1).withHour(0).withDayOfMonth(1).withMinute(0).withSecond(0).withNano(0);
            }
        }
        ,
        DAY_OF_WEEK(1, 7, (List)Arrays.asList("MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN")){

            @Override
            int getValue(ZonedDateTime dateTime) {
                return dateTime.getDayOfWeek().getValue();
            }

            @Override
            ZonedDateTime setValue(ZonedDateTime dateTime, int value) {
                throw new UnsupportedOperationException();
            }

            @Override
            ZonedDateTime overflow(ZonedDateTime dateTime) {
                throw new UnsupportedOperationException();
            }
        };

        final int from;
        final int to;
        final List<String> names;

        private CronFieldType(int from, int to, List<String> names) {
            this.from = from;
            this.to = to;
            this.names = names;
        }

        abstract int getValue(ZonedDateTime var1);

        abstract ZonedDateTime setValue(ZonedDateTime var1, int var2);

        abstract ZonedDateTime overflow(ZonedDateTime var1);
    }
}

