/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode.shadow.coreoz.wisp.schedule.cron;

import com.hypherionmc.mmode.shadow.coreoz.wisp.schedule.Schedule;
import com.hypherionmc.mmode.shadow.cron.CronExpression;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class CronExpressionSchedule
implements Schedule {
    private final CronExpression cronExpression;
    private final ZoneId zoneId;

    public CronExpressionSchedule(CronExpression cronExpression, ZoneId zoneId) {
        this.cronExpression = cronExpression;
        this.zoneId = zoneId;
    }

    public CronExpressionSchedule(CronExpression cronExpression) {
        this(cronExpression, ZoneId.systemDefault());
    }

    @Override
    public long nextExecutionInMillis(long currentTimeInMillis, int executionsCount, Long lastExecutionTimeInMillis) {
        Instant currentInstant = Instant.ofEpochMilli(currentTimeInMillis);
        try {
            return this.cronExpression.nextTimeAfter(ZonedDateTime.ofInstant(currentInstant, this.zoneId)).toEpochSecond() * 1000L;
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    public String toString() {
        return this.cronExpression.toString();
    }

    public static CronExpressionSchedule parse(String cronExpression) {
        return new CronExpressionSchedule(CronExpression.createWithoutSeconds(cronExpression));
    }

    public static CronExpressionSchedule parseWithSeconds(String cronExpression) {
        return new CronExpressionSchedule(CronExpression.create(cronExpression));
    }
}

