/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode.shadow.coreoz.wisp.schedule;

import com.hypherionmc.mmode.shadow.coreoz.wisp.schedule.Schedule;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public class FixedHourSchedule
implements Schedule {
    private final LocalTime executionTime;
    private final ZoneId zoneId;

    public FixedHourSchedule(String every) {
        this(LocalTime.parse(every));
    }

    public FixedHourSchedule(String every, ZoneId zoneId) {
        this(LocalTime.parse(every), zoneId);
    }

    public FixedHourSchedule(LocalTime every) {
        this(every, ZoneId.systemDefault());
    }

    public FixedHourSchedule(LocalTime every, ZoneId zoneId) {
        this.executionTime = every;
        this.zoneId = zoneId;
    }

    public LocalTime executionTime() {
        return this.executionTime;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    public long nextExecutionInMillis(long currentTimeInMillis, int executionsCount, Long lastExecutionTimeInMillis) {
        return this.durationUntilNextExecutionInMillis(currentTimeInMillis, lastExecutionTimeInMillis) + currentTimeInMillis;
    }

    long durationUntilNextExecutionInMillis(long currentTimeInMillis, Long lastExecutionTimeInMillis) {
        ZonedDateTime currentDateTime = Instant.ofEpochMilli(currentTimeInMillis).atZone(this.zoneId);
        return currentDateTime.until(this.nextExecutionDateTime(currentDateTime, lastExecutionTimeInMillis != null && lastExecutionTimeInMillis == currentTimeInMillis), ChronoUnit.MILLIS);
    }

    private ZonedDateTime nextExecutionDateTime(ZonedDateTime currentDateTime, boolean nextExecutionShouldBeNextDay) {
        if (!nextExecutionShouldBeNextDay && currentDateTime.toLocalTime().compareTo(this.executionTime) <= 0) {
            return this.executionTime.atDate(currentDateTime.toLocalDate()).atZone(this.zoneId);
        }
        return this.executionTime.atDate(currentDateTime.toLocalDate()).plusDays(1L).atZone(this.zoneId);
    }

    public String toString() {
        return "at " + this.executionTime + " " + this.zoneId;
    }
}

