/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode.shadow.coreoz.wisp.schedule;

import com.hypherionmc.mmode.shadow.coreoz.wisp.schedule.Schedule;
import java.time.Duration;

public class AfterInitialDelaySchedule
implements Schedule {
    private final Schedule baseSchedule;
    private final Duration initialDelay;
    private Integer initialExecutionsCount;
    private boolean hasNotBeenExecuted;

    public AfterInitialDelaySchedule(Schedule baseSchedule, Duration initialDelay) {
        this.baseSchedule = baseSchedule;
        this.initialDelay = initialDelay;
        this.initialExecutionsCount = null;
        this.hasNotBeenExecuted = true;
    }

    @Override
    public long nextExecutionInMillis(long currentTimeInMillis, int executionsCount, Long lastExecutionTimeInMillis) {
        if (this.initialExecutionsCount == null) {
            this.initialExecutionsCount = executionsCount;
        }
        if (this.initialExecutionsCount >= executionsCount) {
            return this.initialDelay.toMillis() + currentTimeInMillis;
        }
        this.hasNotBeenExecuted = false;
        return this.baseSchedule.nextExecutionInMillis(currentTimeInMillis, executionsCount, lastExecutionTimeInMillis);
    }

    public Schedule baseSchedule() {
        return this.baseSchedule;
    }

    public String toString() {
        if (this.hasNotBeenExecuted) {
            return "first after " + this.initialDelay + ", then " + this.baseSchedule;
        }
        return this.baseSchedule.toString();
    }
}

