/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode.shadow.coreoz.wisp;

import com.hypherionmc.mmode.shadow.coreoz.wisp.Job;
import com.hypherionmc.mmode.shadow.coreoz.wisp.JobStatus;
import com.hypherionmc.mmode.shadow.coreoz.wisp.ScalingThreadPoolExecutor;
import com.hypherionmc.mmode.shadow.coreoz.wisp.SchedulerConfig;
import com.hypherionmc.mmode.shadow.coreoz.wisp.schedule.Schedule;
import com.hypherionmc.mmode.shadow.coreoz.wisp.stats.SchedulerStats;
import com.hypherionmc.mmode.shadow.coreoz.wisp.stats.ThreadPoolStats;
import com.hypherionmc.mmode.shadow.coreoz.wisp.time.SystemTimeProvider;
import com.hypherionmc.mmode.shadow.coreoz.wisp.time.TimeProvider;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scheduler {
    private static final Logger logger = LoggerFactory.getLogger(Scheduler.class);
    private static final AtomicInteger threadCounter = new AtomicInteger(0);
    @Deprecated
    public static final int DEFAULT_THREAD_POOL_SIZE = 10;
    @Deprecated
    public static final long DEFAULT_MINIMUM_DELAY_IN_MILLIS_TO_REPLACE_JOB = 10L;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final TimeProvider timeProvider;
    private final AtomicBoolean launcherNotifier;
    private final Map<String, Job> indexedJobsByName;
    private final ArrayList<Job> nextExecutionsOrder;
    private final Map<String, CompletableFuture<Job>> cancelHandles;
    private volatile boolean shuttingDown;

    public Scheduler() {
        this(SchedulerConfig.builder().build());
    }

    public Scheduler(int maxThreads) {
        this(SchedulerConfig.builder().maxThreads(maxThreads).build());
    }

    public Scheduler(SchedulerConfig config) {
        if (config.getTimeProvider() == null) {
            throw new NullPointerException("The timeProvider cannot be null");
        }
        this.indexedJobsByName = new ConcurrentHashMap<String, Job>();
        this.nextExecutionsOrder = new ArrayList();
        this.timeProvider = config.getTimeProvider();
        this.launcherNotifier = new AtomicBoolean(true);
        this.cancelHandles = new ConcurrentHashMap<String, CompletableFuture<Job>>();
        this.threadPoolExecutor = new ScalingThreadPoolExecutor(config.getMinThreads(), config.getMaxThreads(), config.getThreadsKeepAliveTime().toMillis(), TimeUnit.MILLISECONDS, new WispThreadFactory());
        Thread launcherThread = new Thread(this::launcher, "Wisp Monitor");
        if (launcherThread.isDaemon()) {
            launcherThread.setDaemon(false);
        }
        launcherThread.start();
    }

    @Deprecated
    public Scheduler(int maxThreads, long minimumDelayInMillisToReplaceJob) {
        this(maxThreads, minimumDelayInMillisToReplaceJob, new SystemTimeProvider());
    }

    @Deprecated
    public Scheduler(int maxThreads, long minimumDelayInMillisToReplaceJob, TimeProvider timeProvider) {
        this(SchedulerConfig.builder().maxThreads(maxThreads).timeProvider(timeProvider).build());
    }

    public Job schedule(Runnable runnable, Schedule when) {
        return this.schedule(null, runnable, when);
    }

    public Job schedule(String nullableName, Runnable runnable, Schedule when) {
        Objects.requireNonNull(runnable, "Runnable must not be null");
        Objects.requireNonNull(when, "Schedule must not be null");
        String name = nullableName == null ? runnable.toString() : nullableName;
        Job job = this.prepareJob(name, runnable, when);
        long currentTimeInMillis = this.timeProvider.currentTime();
        if (when.nextExecutionInMillis(currentTimeInMillis, job.executionsCount(), job.lastExecutionEndedTimeInMillis()) < currentTimeInMillis) {
            logger.warn("The job '{}' is scheduled at a paste date: it will never be executed", (Object)name);
        }
        logger.info("Scheduling job '{}' to run {}", (Object)job.name(), (Object)job.schedule());
        this.scheduleNextExecution(job);
        return job;
    }

    public Collection<Job> jobStatus() {
        return this.indexedJobsByName.values();
    }

    public Optional<Job> findJob(String name) {
        return Optional.ofNullable(this.indexedJobsByName.get(name));
    }

    public CompletionStage<Job> cancel(String jobName) {
        Job job = this.findJob(jobName).orElseThrow(IllegalArgumentException::new);
        Scheduler scheduler = this;
        synchronized (scheduler) {
            JobStatus jobStatus = job.status();
            if (jobStatus == JobStatus.DONE) {
                return CompletableFuture.completedFuture(job);
            }
            CompletableFuture<Job> existingHandle = this.cancelHandles.get(jobName);
            if (existingHandle != null) {
                return existingHandle;
            }
            job.schedule(Schedule.willNeverBeExecuted);
            if (jobStatus == JobStatus.READY && this.threadPoolExecutor.remove(job.runningJob())) {
                this.scheduleNextExecution(job);
                return CompletableFuture.completedFuture(job);
            }
            if (jobStatus == JobStatus.RUNNING || jobStatus == JobStatus.READY) {
                CompletableFuture<Job> promise = new CompletableFuture<Job>();
                this.cancelHandles.put(jobName, promise);
                return promise;
            }
            Iterator<Job> iterator = this.nextExecutionsOrder.iterator();
            while (iterator.hasNext()) {
                Job nextJob = iterator.next();
                if (nextJob != job) continue;
                iterator.remove();
                job.status(JobStatus.DONE);
                return CompletableFuture.completedFuture(job);
            }
            throw new IllegalStateException("Cannot find the job " + job + " in " + this.nextExecutionsOrder + ". Please open an issue on https://github.com/Coreoz/Wisp/issues");
        }
    }

    public void remove(String jobName) {
        Job jobToRemove = this.indexedJobsByName.get(jobName);
        if (jobToRemove == null) {
            throw new IllegalArgumentException("There is no existing job with the name " + jobName);
        }
        if (jobToRemove.status() != JobStatus.DONE) {
            throw new IllegalArgumentException("Job is not terminated. Need to call the cancel() method before trying to remove it?");
        }
        this.indexedJobsByName.remove(jobName);
    }

    public void gracefullyShutdown() {
        this.gracefullyShutdown(Duration.ofSeconds(10L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefullyShutdown(Duration timeout) {
        logger.info("Shutting down...");
        if (!this.shuttingDown) {
            Object object = this;
            synchronized (object) {
                this.shuttingDown = true;
                this.threadPoolExecutor.shutdown();
            }
            for (Job job : this.jobStatus()) {
                Runnable runningJob = job.runningJob();
                if (runningJob != null) {
                    this.threadPoolExecutor.remove(runningJob);
                }
                job.status(JobStatus.DONE);
            }
            object = this.launcherNotifier;
            synchronized (object) {
                this.launcherNotifier.set(false);
                this.launcherNotifier.notify();
            }
        }
        this.threadPoolExecutor.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public SchedulerStats stats() {
        int activeThreads = this.threadPoolExecutor.getActiveCount();
        return SchedulerStats.of(ThreadPoolStats.of(this.threadPoolExecutor.getCorePoolSize(), this.threadPoolExecutor.getMaximumPoolSize(), activeThreads, this.threadPoolExecutor.getPoolSize() - activeThreads, this.threadPoolExecutor.getLargestPoolSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job prepareJob(String name, Runnable runnable, Schedule when) {
        Map<String, Job> map = this.indexedJobsByName;
        synchronized (map) {
            Job lastJob = this.findJob(name).orElse(null);
            if (lastJob != null && lastJob.status() != JobStatus.DONE) {
                throw new IllegalArgumentException("A job is already scheduled with the name:" + name);
            }
            Job job = new Job(JobStatus.SCHEDULED, 0L, lastJob != null ? lastJob.executionsCount() : 0, lastJob != null ? lastJob.lastExecutionStartedTimeInMillis() : null, lastJob != null ? lastJob.lastExecutionEndedTimeInMillis() : null, name, when, runnable);
            this.indexedJobsByName.put(name, job);
            return job;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scheduleNextExecution(Job job) {
        job.runningJob(null);
        long currentTimeInMillis = this.timeProvider.currentTime();
        try {
            job.nextExecutionTimeInMillis(job.schedule().nextExecutionInMillis(currentTimeInMillis, job.executionsCount(), job.lastExecutionEndedTimeInMillis()));
        }
        catch (Throwable t) {
            logger.error("An exception was raised during the job next execution time calculation, therefore the job '{}' will not be executed again.", (Object)job.name(), (Object)t);
            job.nextExecutionTimeInMillis(-1L);
        }
        if (job.nextExecutionTimeInMillis() >= currentTimeInMillis) {
            job.status(JobStatus.SCHEDULED);
            this.nextExecutionsOrder.add(job);
            this.nextExecutionsOrder.sort(Comparator.comparing(Job::nextExecutionTimeInMillis));
            AtomicBoolean t = this.launcherNotifier;
            synchronized (t) {
                this.launcherNotifier.set(false);
                this.launcherNotifier.notify();
            }
        } else {
            logger.info("Job '{}' will not be executed again since its next execution time, {}ms, is planned in the past", (Object)job.name(), (Object)Instant.ofEpochMilli(job.nextExecutionTimeInMillis()));
            job.status(JobStatus.DONE);
            CompletableFuture<Job> cancelHandle = this.cancelHandles.remove(job.name());
            if (cancelHandle != null) {
                cancelHandle.complete(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launcher() {
        while (true) {
            if (this.shuttingDown) break;
            Long timeBeforeNextExecution = null;
            Object object = this;
            synchronized (object) {
                if (this.nextExecutionsOrder.size() > 0) {
                    timeBeforeNextExecution = this.nextExecutionsOrder.get(0).nextExecutionTimeInMillis() - this.timeProvider.currentTime();
                }
            }
            if (timeBeforeNextExecution == null || timeBeforeNextExecution > 0L) {
                object = this.launcherNotifier;
                synchronized (object) {
                    if (this.shuttingDown) {
                        return;
                    }
                    if (this.launcherNotifier.get()) {
                        if (timeBeforeNextExecution == null) {
                            this.launcherNotifier.wait();
                        } else {
                            this.launcherNotifier.wait(timeBeforeNextExecution);
                        }
                    }
                    this.launcherNotifier.set(true);
                    continue;
                }
            }
            object = this;
            synchronized (object) {
                if (this.shuttingDown) {
                    return;
                }
                if (this.nextExecutionsOrder.size() > 0) {
                    Job jobToRun = this.nextExecutionsOrder.remove(0);
                    jobToRun.status(JobStatus.READY);
                    jobToRun.runningJob(() -> this.runJob(jobToRun));
                    if (this.threadPoolExecutor.getActiveCount() == this.threadPoolExecutor.getMaximumPoolSize()) {
                        logger.warn("Job thread pool is full, either tasks take too much time to execute or either the thread pool is too small");
                    }
                    this.threadPoolExecutor.execute(jobToRun.runningJob());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJob(Job jobToRun) {
        long startExecutionTime = this.timeProvider.currentTime();
        long timeBeforeNextExecution = jobToRun.nextExecutionTimeInMillis() - startExecutionTime;
        if (timeBeforeNextExecution < 0L) {
            logger.debug("Job '{}' execution is {}ms late", (Object)jobToRun.name(), (Object)(-timeBeforeNextExecution));
        }
        jobToRun.status(JobStatus.RUNNING);
        jobToRun.lastExecutionStartedTimeInMillis(startExecutionTime);
        jobToRun.threadRunningJob(Thread.currentThread());
        try {
            jobToRun.runnable().run();
        }
        catch (Throwable t) {
            logger.error("Error during job '{}' execution", (Object)jobToRun.name(), (Object)t);
        }
        jobToRun.executionsCount(jobToRun.executionsCount() + 1);
        jobToRun.lastExecutionEndedTimeInMillis(this.timeProvider.currentTime());
        jobToRun.threadRunningJob(null);
        if (logger.isDebugEnabled()) {
            logger.debug("Job '{}' executed in {}ms", (Object)jobToRun.name(), (Object)(this.timeProvider.currentTime() - startExecutionTime));
        }
        if (this.shuttingDown) {
            return;
        }
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.scheduleNextExecution(jobToRun);
        }
    }

    private static class WispThreadFactory
    implements ThreadFactory {
        private WispThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Wisp Scheduler Worker #" + threadCounter.getAndIncrement());
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

