/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode.shadow.coreoz.wisp;

import com.hypherionmc.mmode.shadow.coreoz.wisp.Job;
import com.hypherionmc.mmode.shadow.coreoz.wisp.JobStatus;
import com.hypherionmc.mmode.shadow.coreoz.wisp.Scheduler;
import com.hypherionmc.mmode.shadow.coreoz.wisp.SchedulerConfig;
import com.hypherionmc.mmode.shadow.coreoz.wisp.time.TimeProvider;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongRunningJobMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LongRunningJobMonitor.class);
    public static final Duration DEFAULT_THRESHOLD_DETECTION = Duration.ofMinutes(5L);
    private final Scheduler scheduler;
    private final TimeProvider timeProvider;
    private final long detectionThresholdInMillis;
    private final Map<Job, LongRunningJobInfo> longRunningJobs;

    public LongRunningJobMonitor(Scheduler scheduler, Duration detectionThreshold, TimeProvider timeProvider) {
        this.scheduler = scheduler;
        this.timeProvider = timeProvider;
        this.detectionThresholdInMillis = detectionThreshold.toMillis();
        this.longRunningJobs = new HashMap<Job, LongRunningJobInfo>();
    }

    public LongRunningJobMonitor(Scheduler scheduler, Duration detectionThreshold) {
        this(scheduler, detectionThreshold, SchedulerConfig.DEFAULT_TIME_PROVIDER);
    }

    public LongRunningJobMonitor(Scheduler scheduler) {
        this(scheduler, DEFAULT_THRESHOLD_DETECTION, SchedulerConfig.DEFAULT_TIME_PROVIDER);
    }

    @Override
    public void run() {
        long currentTime = this.timeProvider.currentTime();
        for (Job job : this.scheduler.jobStatus()) {
            this.cleanUpLongJobIfItHasFinishedExecuting(currentTime, job);
            this.detectLongRunningJob(currentTime, job);
        }
    }

    boolean detectLongRunningJob(long currentTime, Job job) {
        if (job.status() == JobStatus.RUNNING && !this.longRunningJobs.containsKey(job)) {
            int jobExecutionsCount = job.executionsCount();
            Long jobStartedtimeInMillis = job.lastExecutionStartedTimeInMillis();
            Thread threadRunningJob = job.threadRunningJob();
            if (jobStartedtimeInMillis != null && threadRunningJob != null && currentTime - jobStartedtimeInMillis > this.detectionThresholdInMillis) {
                logger.warn("Job '{}' is still running after {}ms (detection threshold = {}ms), stack trace = {}", new Object[]{job.name(), currentTime - jobStartedtimeInMillis, this.detectionThresholdInMillis, Stream.of(threadRunningJob.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n  "))});
                this.longRunningJobs.put(job, new LongRunningJobInfo(jobStartedtimeInMillis, jobExecutionsCount));
                return true;
            }
        }
        return false;
    }

    Long cleanUpLongJobIfItHasFinishedExecuting(long currentTime, Job job) {
        if (this.longRunningJobs.containsKey(job) && this.longRunningJobs.get((Object)job).executionsCount != job.executionsCount()) {
            Long jobLastExecutionTimeInMillis = job.lastExecutionEndedTimeInMillis();
            int jobExecutionsCount = job.executionsCount();
            LongRunningJobInfo jobRunningInfo = this.longRunningJobs.get(job);
            long jobExecutionDuration = 0L;
            if (jobExecutionsCount == jobRunningInfo.executionsCount + 1) {
                jobExecutionDuration = jobLastExecutionTimeInMillis - jobRunningInfo.jobStartedtimeInMillis;
                logger.info("Job '{}' has finished executing after {}ms", (Object)job.name(), (Object)jobExecutionDuration);
            } else {
                jobExecutionDuration = currentTime - jobRunningInfo.jobStartedtimeInMillis;
                logger.info("Job '{}' has finished executing after about {}ms", (Object)job.name(), (Object)jobExecutionDuration);
            }
            this.longRunningJobs.remove(job);
            return jobExecutionDuration;
        }
        return null;
    }

    private static class LongRunningJobInfo {
        final long jobStartedtimeInMillis;
        final int executionsCount;

        public LongRunningJobInfo(long jobStartedtimeInMillis, int executionsCount) {
            this.jobStartedtimeInMillis = jobStartedtimeInMillis;
            this.executionsCount = executionsCount;
        }
    }
}

