/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.mmode.schedule;

import com.hypherionmc.craterlib.core.event.CraterEvent;
import com.hypherionmc.craterlib.core.event.CraterEventBus;
import com.hypherionmc.mmode.CommonClass;
import com.hypherionmc.mmode.ModConstants;
import com.hypherionmc.mmode.api.events.MaintenanceModeEvent;
import com.hypherionmc.mmode.config.MaintenanceModeConfig;
import com.hypherionmc.mmode.shadow.coreoz.wisp.Scheduler;
import com.hypherionmc.mmode.shadow.coreoz.wisp.schedule.cron.CronExpressionSchedule;
import java.time.Duration;

public class MaintenanceSchedule {
    public static final MaintenanceSchedule INSTANCE = new MaintenanceSchedule();
    private final Scheduler scheduler = new Scheduler(2);

    MaintenanceSchedule() {
    }

    public void initScheduler() {
        try {
            this.scheduler.findJob("mmodestart").ifPresent(job -> {
                this.scheduler.cancel(job.name());
                this.scheduler.remove(job.name());
            });
            this.scheduler.findJob("mmodeend").ifPresent(job -> {
                this.scheduler.cancel(job.name());
                this.scheduler.remove(job.name());
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!MaintenanceModeConfig.INSTANCE.getSchedule().getStartTime().isEmpty()) {
                this.scheduler.schedule("mmodestart", this::startMaintenance, CronExpressionSchedule.parse(MaintenanceModeConfig.INSTANCE.getSchedule().getStartTime()));
            }
        }
        catch (Exception e) {
            ModConstants.LOG.error("Failed to schedule maintenance", (Throwable)e);
        }
        try {
            if (!MaintenanceModeConfig.INSTANCE.getSchedule().getEndTime().isEmpty()) {
                this.scheduler.schedule("mmodeend", this::endMaintenance, CronExpressionSchedule.parse(MaintenanceModeConfig.INSTANCE.getSchedule().getEndTime()));
            }
        }
        catch (Exception e) {
            ModConstants.LOG.error("Failed to schedule maintenance", (Throwable)e);
        }
    }

    private void startMaintenance() {
        CraterEventBus.INSTANCE.postEvent((CraterEvent)new MaintenanceModeEvent.MaintenanceStart());
        CommonClass.INSTANCE.broadcastMessage("Maintenance is starting");
        MaintenanceModeConfig.INSTANCE.setEnabled(true);
        CommonClass.INSTANCE.resetOnStartup = MaintenanceModeConfig.INSTANCE.getSchedule().isDisableOnRestart();
        CommonClass.INSTANCE.kickAllPlayers(MaintenanceModeConfig.INSTANCE.getMessage());
        CommonClass.INSTANCE.isDirty.set(true);
        MaintenanceModeConfig.INSTANCE.saveConfig((Object)MaintenanceModeConfig.INSTANCE);
    }

    private void endMaintenance() {
        CraterEventBus.INSTANCE.postEvent((CraterEvent)new MaintenanceModeEvent.MaintenanceEnd());
        CommonClass.INSTANCE.broadcastMessage("Maintenance is ending");
        MaintenanceModeConfig.INSTANCE.setEnabled(false);
        CommonClass.INSTANCE.isDirty.set(true);
        MaintenanceModeConfig.INSTANCE.saveConfig((Object)MaintenanceModeConfig.INSTANCE);
    }

    public void shutDown() {
        this.scheduler.gracefullyShutdown(Duration.ZERO);
    }
}

