/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.inventory;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.inventory.ACMenuRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.CaveInfoItem;
import com.github.alexmodguy.alexscaves.server.message.WorldEventMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class SpelunkeryTableMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private static final String NEEDS_TUTORIAL_IDENTIFIER = "alexscaves_spelunkery_tutorial_complete";
    long lastSoundTime;
    public final Container container = new SimpleContainer(2){

        public void m_6596_() {
            SpelunkeryTableMenu.this.m_6199_((Container)this);
            super.m_6596_();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer(){

        public void m_6596_() {
            SpelunkeryTableMenu.this.m_6199_((Container)this);
            super.m_6596_();
        }
    };

    public SpelunkeryTableMenu(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.f_39287_);
    }

    public SpelunkeryTableMenu(int id, Inventory inventory, final ContainerLevelAccess access) {
        super((MenuType)ACMenuRegistry.SPELUNKERY_TABLE_MENU.get(), id);
        this.access = access;
        this.m_38897_(new Slot(this.container, 0, 50, 143){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_((Item)ACItemRegistry.CAVE_TABLET.get());
            }

            public int m_6641_() {
                return 1;
            }

            public boolean m_8010_(Player player) {
                return SpelunkeryTableMenu.this.container.m_8020_(1).m_41619_();
            }

            public void m_142406_(Player player, ItemStack stack) {
                access.m_39292_((level, blockPos) -> level.m_5594_((Player)null, blockPos, (SoundEvent)ACSoundRegistry.SPELUNKERY_TABLE_TABLET_REMOVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f));
                super.m_142406_(player, stack);
            }

            public void m_269060_(ItemStack stack) {
                super.m_269060_(stack);
                if (!stack.m_41619_()) {
                    access.m_39292_((level, blockPos) -> level.m_5594_((Player)null, blockPos, (SoundEvent)ACSoundRegistry.SPELUNKERY_TABLE_TABLET_INSERT.get(), SoundSource.BLOCKS, 1.0f, 1.0f));
                }
            }
        });
        this.m_38897_(new Slot(this.container, 1, 70, 143){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42516_);
            }

            public int m_6641_() {
                return 1;
            }

            public boolean m_8010_(Player player) {
                return SpelunkeryTableMenu.this.container.m_8020_(0).m_41619_();
            }

            public void m_142406_(Player player, ItemStack stack) {
                access.m_39292_((level, blockPos) -> level.m_5594_((Player)null, blockPos, (SoundEvent)ACSoundRegistry.SPELUNKERY_TABLE_PAPER_REMOVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f));
                super.m_142406_(player, stack);
            }

            public void m_269060_(ItemStack stack) {
                super.m_269060_(stack);
                if (!stack.m_41619_()) {
                    access.m_39292_((level, blockPos) -> level.m_5594_((Player)null, blockPos, (SoundEvent)ACSoundRegistry.SPELUNKERY_TABLE_PAPER_INSERT.get(), SoundSource.BLOCKS, 1.0f, 1.0f));
                }
            }
        });
        this.m_38897_(new Slot((Container)this.resultContainer, 2, 142, 143){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                access.m_39292_((level, blockPos) -> level.m_5594_((Player)null, blockPos, (SoundEvent)ACSoundRegistry.SPELUNKERY_TABLE_CODEX_REMOVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f));
                stack.m_41720_().m_7836_(stack, player.m_9236_(), player);
                super.m_142406_(player, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 24 + j * 18, 174 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 24 + k * 18, 232));
        }
    }

    public boolean m_6875_(Player player) {
        return SpelunkeryTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ACBlockRegistry.SPELUNKERY_TABLE.get()));
    }

    public void m_6199_(Container container) {
    }

    private void setupResultSlot(ResourceKey<Biome> biomeResourceKey, Player player) {
        this.access.m_39292_((p_39170_, p_39171_) -> {
            ItemStack itemstack;
            ItemStack itemInFinalSlot = this.resultContainer.m_8020_(2);
            ItemStack itemStack = itemstack = biomeResourceKey == null ? new ItemStack((ItemLike)Items.f_42516_) : CaveInfoItem.create((Item)ACItemRegistry.CAVE_CODEX.get(), biomeResourceKey);
            if (itemInFinalSlot.m_41619_()) {
                this.resultContainer.m_6836_(2, itemstack);
            } else if (ItemStack.m_150942_((ItemStack)itemInFinalSlot, (ItemStack)itemstack) && itemInFinalSlot.m_41613_() + itemstack.m_41613_() < itemInFinalSlot.m_41741_()) {
                itemInFinalSlot.m_41764_(itemInFinalSlot.m_41613_() + itemstack.m_41613_());
                this.resultContainer.m_6836_(2, itemInFinalSlot);
            } else {
                player.m_36176_(itemstack, true);
            }
            this.m_38946_();
        });
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex == 2) {
                itemstack1.m_41720_().m_7836_(itemstack1, player.m_9236_(), player);
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotIndex != 1 && slotIndex != 0 ? (itemstack1.m_150930_(Items.f_42516_) ? !this.m_38903_(itemstack1, 1, 2, false) : itemstack1.m_150930_((Item)ACItemRegistry.CAVE_TABLET.get()) && !this.m_38903_(itemstack1, 0, 1, false)) : !this.m_38903_(itemstack1, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((p_39152_, p_39153_) -> {
            this.m_150411_(player, this.container);
            this.m_150411_(player, (Container)this.resultContainer);
        });
    }

    public void onMessageFromScreen(Player player, boolean pass) {
        ItemStack copyOf = this.m_38853_(0).m_7993_().m_41777_();
        this.m_38853_(0).m_7993_().m_41774_(1);
        if (pass && !copyOf.m_41619_()) {
            ResourceKey<Biome> biomeResourceKey;
            if (this.m_38853_(1).m_7993_().m_150930_(Items.f_42516_)) {
                this.m_38853_(1).m_7993_().m_41774_(1);
            }
            if ((biomeResourceKey = CaveInfoItem.getCaveBiome(copyOf)) != null) {
                this.setupResultSlot(biomeResourceKey, player);
            }
            SpelunkeryTableMenu.setTutorialComplete(player, true);
        } else {
            this.access.m_39292_(this::makeStoneParticles);
        }
    }

    public static void setTutorialComplete(Player player, boolean done) {
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = playerData.m_128469_("PlayerPersisted");
        if (data != null) {
            data.m_128379_(NEEDS_TUTORIAL_IDENTIFIER, done);
            playerData.m_128365_("PlayerPersisted", (Tag)data);
        }
    }

    public static boolean hasCompletedTutorial(Player player) {
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = playerData.m_128469_("PlayerPersisted");
        return data != null && data.m_128471_(NEEDS_TUTORIAL_IDENTIFIER);
    }

    public void makeStoneParticles(Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            AlexsCaves.sendMSGToAll(new WorldEventMessage(5, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
        }
    }

    public int getHighlightColor(Level level) {
        ItemStack stack = this.m_38853_(0).m_7993_();
        if (stack.m_41720_() == ACItemRegistry.CAVE_TABLET.get()) {
            return CaveInfoItem.getBiomeColorOf(level, stack, true);
        }
        return -1;
    }
}

