/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.util.TephraExplosion;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class TephraEntity
extends Projectile {
    private static final EntityDataAccessor<Optional<UUID>> ARC_TOWARDS_ENTITY_UUID = SynchedEntityData.m_135353_(TephraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> MAX_SCALE = SynchedEntityData.m_135353_(TephraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(TephraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private float prevScale;
    private boolean playedSpawnSound = false;
    private int dieIn = -1;
    private int clipFor = 5;

    public TephraEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public TephraEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.TEPHRA.get(), level);
    }

    public TephraEntity(Level level, LivingEntity shooter) {
        this((EntityType)ACEntityRegistry.TEPHRA.get(), level);
        float f = shooter instanceof Player ? 0.3f : 0.1f;
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - (double)f, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ARC_TOWARDS_ENTITY_UUID, Optional.empty());
        this.m_20088_().m_135372_(MAX_SCALE, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(SCALE, (Object)Float.valueOf(0.1f));
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevScale = this.getScale();
        if (!this.playedSpawnSound) {
            this.playedSpawnSound = true;
            this.m_5496_((SoundEvent)ACSoundRegistry.TEPHRA_WHISTLE.get(), 8.0f, Mth.m_14036_((float)(2.0f - this.getMaxScale() * 0.5f), (float)0.5f, (float)2.0f));
        }
        if (!this.m_9236_().f_46443_) {
            Entity arcTowards = this.getArcingTowards();
            if (arcTowards != null && this.f_19797_ > 3 && this.dieIn == -1 && this.m_20270_(arcTowards) > 1.5f && this.f_19797_ < 20) {
                Vec3 arcVec = arcTowards.m_20182_().m_82520_(0.0, 0.3 * (double)arcTowards.m_20206_(), 0.0).m_82546_(this.m_20182_()).m_82541_();
                this.m_20256_(this.m_20184_().m_82549_(arcVec.m_82490_((double)0.1f)));
            }
            this.setScale(Mth.m_14121_((float)this.getScale(), (float)this.getMaxScale(), (float)0.1f));
        } else {
            for (int j = 0; j < 1 + this.f_19796_.m_188503_(2); ++j) {
                Vec3 delta = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f)).m_82490_((double)0.025f);
                this.m_9236_().m_6485_((ParticleOptions)ACParticleRegistry.TEPHRA.get(), true, this.m_20208_(this.getScale()) + this.m_20184_().f_82479_, this.m_20187_() + this.m_20184_().f_82480_, this.m_20262_(this.getScale()) + this.m_20184_().f_82481_, delta.f_82479_, delta.f_82480_, delta.f_82481_);
            }
        }
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        if (this.m_9236_().m_45556_(this.m_20191_()).noneMatch(BlockBehaviour.BlockStateBase::m_60795_) && !this.m_20072_()) {
            this.m_146870_();
        } else {
            this.m_20256_(vec3.m_82490_((double)0.9f));
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.1f, 0.0));
            }
            if (this.m_9236_().f_46443_) {
                if (this.lSteps > 0) {
                    double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                    double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                    double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                    this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                    this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                    --this.lSteps;
                    this.m_6034_(d5, d6, d7);
                } else {
                    this.m_20090_();
                }
            } else {
                this.m_6034_(d0, d1, d2);
            }
        }
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        if (this.dieIn > 0) {
            --this.dieIn;
            if (this.dieIn == 0) {
                this.m_146870_();
            }
        }
        if (this.clipFor > 0) {
            --this.clipFor;
            this.f_19794_ = true;
        } else {
            this.f_19794_ = false;
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!(this.m_9236_().f_46443_ || this.m_150171_(hitResult.m_82443_()) || this.f_19794_)) {
            this.explode();
        }
    }

    private void explode() {
        Explosion.BlockInteraction blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) ? (this.m_9236_().m_46469_().m_46207_(GameRules.f_254692_) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY) : Explosion.BlockInteraction.KEEP;
        TephraExplosion explosion = new TephraExplosion(this.m_9236_(), (Entity)this, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1.0f + this.getMaxScale(), blockinteraction);
        explosion.explode();
        explosion.finalizeExplosion(true);
        this.m_146870_();
    }

    public float getMaxScale() {
        return ((Float)this.f_19804_.m_135370_(MAX_SCALE)).floatValue();
    }

    public void setMaxScale(float scale) {
        this.f_19804_.m_135381_(MAX_SCALE, (Object)Float.valueOf(scale));
    }

    public float getScale() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
    }

    public float getLerpedScale(float partialTicks) {
        return this.prevScale + (this.getScale() - this.prevScale) * partialTicks;
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        if (!this.m_9236_().f_46443_ && !this.f_19794_) {
            this.explode();
        }
    }

    public Entity getArcingTowards() {
        UUID id = ((Optional)this.f_19804_.m_135370_(ARC_TOWARDS_ENTITY_UUID)).orElse(null);
        return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setScale(tag.m_128457_("Scale"));
        this.setMaxScale(tag.m_128457_("MaxScale"));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128350_("Scale", this.getScale());
        compoundTag.m_128350_("MaxScale", this.getMaxScale());
    }

    public void setArcingTowards(@Nullable UUID arcingTowards) {
        this.f_19804_.m_135381_(ARC_TOWARDS_ENTITY_UUID, Optional.ofNullable(arcingTowards));
    }
}

