/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.util.KeybindUsingMount;
import com.github.alexmodguy.alexscaves.server.message.MountedEntityKeyMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class SubmarineEntity
extends Entity
implements KeybindUsingMount {
    private static final EntityDataAccessor<Float> RIGHT_PROPELLER_ROT = SynchedEntityData.m_135353_(SubmarineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> LEFT_PROPELLER_ROT = SynchedEntityData.m_135353_(SubmarineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BACK_PROPELLER_ROT = SynchedEntityData.m_135353_(SubmarineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ACCELERATION = SynchedEntityData.m_135353_(SubmarineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> LIGHTS = SynchedEntityData.m_135353_(SubmarineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAXED = SynchedEntityData.m_135353_(SubmarineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> OXIDIZATION_LEVEL = SynchedEntityData.m_135353_(SubmarineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DAMAGE_LEVEL = SynchedEntityData.m_135353_(SubmarineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DANGER_ALERT_TICKS = SynchedEntityData.m_135353_(SubmarineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final float TOP_SPEED = 0.65f;
    private float prevLeftPropellerRot;
    private float prevRightPropellerRot;
    private float prevBackPropellerRot;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private int controlUpTicks = 0;
    private int controlDownTicks = 0;
    private int turnRightTicks = 0;
    private int turnLeftTicks = 0;
    private int floodlightToggleCooldown = 0;
    private double damageSustained = 0.0;
    private int oxidizeTime = 24000 * (2 + this.f_19796_.m_188503_(2));
    public int submergedTicks = 0;
    public int shakeTime = 0;
    private float prevSonarFlashAmount;
    private float sonarFlashAmount;
    private int creakTime;
    private boolean wereLightsOn;

    public SubmarineEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public SubmarineEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)ACEntityRegistry.SUBMARINE.get(), world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RIGHT_PROPELLER_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LEFT_PROPELLER_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BACK_PROPELLER_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ACCELERATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIGHTS, (Object)false);
        this.f_19804_.m_135372_(WAXED, (Object)false);
        this.f_19804_.m_135372_(OXIDIZATION_LEVEL, (Object)0);
        this.f_19804_.m_135372_(DAMAGE_LEVEL, (Object)0);
        this.f_19804_.m_135372_(DANGER_ALERT_TICKS, (Object)0);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setOxidizationLevel(tag.m_128451_("Oxidization"));
        this.setDamageLevel(tag.m_128451_("DamageLevel"));
        this.setWaxed(tag.m_128471_("Waxed"));
        this.setLightsOn(tag.m_128471_("LightsOn"));
        if (tag.m_128441_("OxidizeTime")) {
            this.oxidizeTime = tag.m_128451_("OxidizeTime");
        }
        if (tag.m_128441_("DamageSustained")) {
            this.damageSustained = tag.m_128451_("DamageSustained");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("Oxidization", this.getOxidizationLevel());
        tag.m_128405_("DamageLevel", this.getDamageLevel());
        tag.m_128379_("Waxed", this.isWaxed());
        tag.m_128379_("LightsOn", this.areLightsOn());
        tag.m_128405_("OxidizeTime", this.oxidizeTime);
        tag.m_128347_("DamageSustained", this.damageSustained);
    }

    public void m_8119_() {
        super.m_8119_();
        float leftPropellerRot = this.getLeftPropellerRot();
        float rightPropellerRot = this.getRightPropellerRot();
        float backPropellerRot = this.getBackPropellerRot();
        if (this.controlDownTicks > 0 || this.getDamageLevel() >= 4 && !this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
            --this.controlDownTicks;
        } else if (this.controlUpTicks > 0 && this.getWaterHeight() > 1.5f) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.08, 0.0));
            --this.controlUpTicks;
        }
        if (this.f_19797_ % 200 == 0 && this.damageSustained > 0.0) {
            this.damageSustained -= 1.0;
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = Mth.m_14177_((float)this.m_146908_());
        this.prevSonarFlashAmount = this.sonarFlashAmount;
        if (this.getDangerAlertTicks() > 0 && this.sonarFlashAmount < 1.0f) {
            this.sonarFlashAmount += 0.25f;
        }
        if (this.getDangerAlertTicks() <= 0 && this.sonarFlashAmount > 0.0f) {
            this.sonarFlashAmount -= 0.25f;
        }
        if (this.getDangerAlertTicks() > 0 && this.getDamageLevel() <= 3 && this.m_20160_() && this.f_19797_ % 20 == 0) {
            this.m_216990_((SoundEvent)ACSoundRegistry.SUBMARINE_SONAR.get());
        }
        if (this.getDamageLevel() > 0 && this.m_20160_() && this.creakTime-- <= 0) {
            this.creakTime = 500 - this.getDamageLevel() * 120 + this.f_19796_.m_188503_(60);
            this.m_216990_((SoundEvent)ACSoundRegistry.SUBMARINE_CREAK.get());
        }
        float acceleration = this.getAcceleration();
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
            Player player = AlexsCaves.PROXY.getClientSidePlayer();
            if (player != null && player.m_20365_((Entity)this)) {
                if (AlexsCaves.PROXY.isKeyDown(0) && this.controlUpTicks < 2) {
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 0));
                    this.controlUpTicks = 10;
                }
                if (AlexsCaves.PROXY.isKeyDown(1) && this.controlDownTicks < 2) {
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 1));
                    this.controlDownTicks = 10;
                }
                if (AlexsCaves.PROXY.isKeyDown(2) && this.floodlightToggleCooldown <= 0) {
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 2));
                    this.floodlightToggleCooldown = 5;
                }
            }
            if (this.m_20160_() && this.m_20072_() && this.m_6084_()) {
                AlexsCaves.PROXY.playWorldSound(this, (byte)15);
            }
        } else {
            if (acceleration < 0.0f) {
                this.setAcceleration(Math.min(0.0f, acceleration + 0.01f));
            }
            if (acceleration > 0.0f) {
                this.setAcceleration(Math.max(0.0f, acceleration - 0.01f));
            }
            if (Math.abs(acceleration) > 0.0f) {
                Vec3 vec3 = new Vec3(0.0, 0.0, (double)(Mth.m_14036_((float)acceleration, (float)-0.25f, (float)0.65f) * 0.2f)).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                this.m_20256_(this.m_20184_().m_82549_(vec3));
            }
            if (this.m_20072_()) {
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82542_((double)0.8f, (double)0.8f, (double)0.8f));
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.5, 0.0));
                this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_((double)0.9f));
                this.m_20256_(this.m_20184_().m_82542_((double)0.1f, (double)0.3f, (double)0.1f));
            }
            if (!this.isWaxed() && this.getOxidizationLevel() < 3) {
                if (this.oxidizeTime > 0) {
                    --this.oxidizeTime;
                } else {
                    this.resetOxidizeTime();
                    this.setOxidizationLevel(this.getOxidizationLevel() + 1);
                }
            }
            if (this.getDangerAlertTicks() > 0) {
                this.setDangerAlertTicks(this.getDangerAlertTicks() - 1);
            }
        }
        float xRotSet = Mth.m_14036_((float)(-((float)this.m_20184_().f_82480_) * 2.0f), (float)-1.0f, (float)1.0f) * -57.295776f * (float)Math.signum((double)this.getAcceleration() + 0.01);
        float rot = acceleration * 30.0f + Math.signum(acceleration) * 15.0f;
        this.setBackPropellerRot(backPropellerRot + rot);
        this.setLeftPropellerRot(leftPropellerRot + rot + (float)(this.turnLeftTicks > 0 ? 5 * this.turnLeftTicks : 0));
        this.setRightPropellerRot(rightPropellerRot + rot + (float)(this.turnRightTicks > 0 ? 5 * this.turnRightTicks : 0));
        if (this.getWaterHeight() >= 1.5f) {
            if (Math.abs(this.getAcceleration()) > 0.05f) {
                Vec3 bubblesAt = new Vec3(0.0, (double)0.3f, -2.0).m_82496_((float)Math.toRadians(this.m_146909_())).m_82524_((float)Math.toRadians(-this.m_146908_()));
                for (int i = 0; i < 1 + this.f_19796_.m_188503_(4); ++i) {
                    float offsetX = 0.5f - this.f_19796_.m_188501_();
                    float offsetY = 0.5f - this.f_19796_.m_188501_();
                    float offsetZ = 0.5f - this.f_19796_.m_188501_();
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123774_, this.m_20185_() + (double)offsetX + bubblesAt.f_82479_, this.m_20227_(0.5) + (double)offsetY + bubblesAt.f_82480_, this.m_20189_() + (double)offsetZ + bubblesAt.f_82481_, 0.0, 0.0, 0.0);
                }
            }
            if (this.submergedTicks < 10) {
                ++this.submergedTicks;
            }
        } else if (this.submergedTicks > 0) {
            this.submergedTicks = 0;
        }
        if (this.floodlightToggleCooldown > 0) {
            --this.floodlightToggleCooldown;
        }
        if (this.turnLeftTicks > 0) {
            --this.turnLeftTicks;
        }
        if (this.turnRightTicks > 0) {
            --this.turnRightTicks;
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.wereLightsOn != this.areLightsOn()) {
            this.m_216990_(this.wereLightsOn ? (SoundEvent)ACSoundRegistry.SUBMARINE_LIGHT_OFF.get() : (SoundEvent)ACSoundRegistry.SUBMARINE_LIGHT_ON.get());
            this.wereLightsOn = this.areLightsOn();
        }
        this.m_146926_(ACMath.approachRotation(this.m_146909_(), Mth.m_14036_((float)(this.getDamageLevel() >= 4 ? 0.0f : xRotSet), (float)-50.0f, (float)50.0f), 2.0f));
        this.prevLeftPropellerRot = leftPropellerRot;
        this.prevRightPropellerRot = rightPropellerRot;
        this.prevBackPropellerRot = backPropellerRot;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor(this);
        super.m_142687_(removalReason);
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lSteps > 0) {
            this.lSteps = 0;
            this.m_19890_(this.lx, this.ly, this.lz, (float)this.lyr, (float)this.lxr);
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public boolean areLightsOn() {
        return (Boolean)this.f_19804_.m_135370_(LIGHTS);
    }

    public void setLightsOn(boolean bool) {
        this.f_19804_.m_135381_(LIGHTS, (Object)bool);
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(WAXED);
    }

    public void setWaxed(boolean waxed) {
        this.f_19804_.m_135381_(WAXED, (Object)waxed);
    }

    public int getOxidizationLevel() {
        return (Integer)this.f_19804_.m_135370_(OXIDIZATION_LEVEL);
    }

    public void setOxidizationLevel(int level) {
        this.f_19804_.m_135381_(OXIDIZATION_LEVEL, (Object)level);
    }

    public int getDamageLevel() {
        return (Integer)this.f_19804_.m_135370_(DAMAGE_LEVEL);
    }

    public void setDamageLevel(int level) {
        this.f_19804_.m_135381_(DAMAGE_LEVEL, (Object)level);
    }

    public int getDangerAlertTicks() {
        return (Integer)this.f_19804_.m_135370_(DANGER_ALERT_TICKS);
    }

    public void setDangerAlertTicks(int ticks) {
        this.f_19804_.m_135381_(DANGER_ALERT_TICKS, (Object)ticks);
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return type.supportsBoating(null);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_6000_(double x, double y, double z) {
        boolean prev = super.m_6000_(x, y, z);
        return prev || this.m_20160_() && this.m_146895_() != null && this.m_146895_().m_6000_(x, y, z);
    }

    /*
     * Unable to fully structure code
     */
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (!this.m_20365_(passenger) || !(passenger instanceof LivingEntity)) ** GOTO lbl-1000
        living = (LivingEntity)passenger;
        if (!this.m_146899_()) {
            this.clampRotation(living);
            if (passenger instanceof Player) {
                this.tickController((Player)passenger);
            }
            f1 = -(this.m_146909_() / 40.0f);
            seatOffset = new Vec3(0.0, -0.20000000298023224, (double)(0.8f + f1)).m_82496_((float)Math.toRadians(this.m_146909_())).m_82524_((float)Math.toRadians(-this.m_146908_()));
            d0 = this.m_20186_() + (double)(this.m_20206_() * 0.5f) + seatOffset.f_82480_ + passenger.m_6049_();
            moveFunction.m_20372_(passenger, this.m_20185_() + seatOffset.f_82479_, d0, this.m_20189_() + seatOffset.f_82481_);
            living.m_20301_(Math.min(living.m_20146_() + 2, living.m_6062_()));
        } else lbl-1000:
        // 2 sources

        {
            super.m_19956_(passenger, moveFunction);
        }
        if (this.getDamageLevel() >= 4) {
            passenger.m_8127_();
        }
    }

    public void m_7822_(byte b) {
        if (b == 45) {
            for (int i = 0; i < 5; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20208_(0.9), this.m_20187_(), this.m_20262_(0.9), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.15f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f));
            }
        } else if (b == 46) {
            for (int i = 0; i < 5; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175829_, this.m_20208_(0.9), this.m_20187_(), this.m_20262_(0.9), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.15f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f));
            }
        } else if (b == 47) {
            Block particleState = Blocks.f_152504_;
            switch (this.getOxidizationLevel()) {
                case 1: {
                    particleState = Blocks.f_152503_;
                    break;
                }
                case 2: {
                    particleState = Blocks.f_152502_;
                    break;
                }
                case 3: {
                    particleState = Blocks.f_152501_;
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, particleState.m_49966_()), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.15f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f));
            }
            this.shakeTime = 20;
        } else if (b == 48) {
            this.shakeTime = 10;
        } else {
            super.m_7822_(b);
        }
    }

    private void tickController(Player passenger) {
        if (passenger.f_20900_ != 0.0f) {
            float turn = -Math.signum(passenger.f_20900_);
            if (turn > 0.0f) {
                this.turnLeftTicks = 5;
            } else {
                this.turnRightTicks = 5;
            }
            this.m_146922_(this.m_146908_() + turn * 2.5f);
        }
        if (passenger.f_20902_ != 0.0f) {
            float back = -Math.signum(passenger.f_20902_);
            if (back < 0.0f) {
                this.setAcceleration(Mth.m_14121_((float)this.getAcceleration(), (float)1.0f, (float)0.02f));
            } else {
                this.setAcceleration(Mth.m_14121_((float)this.getAcceleration(), (float)-0.5f, (float)0.02f));
            }
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.canPerformAction(ToolActions.AXE_SCRAPE) && (this.getOxidizationLevel() > 0 || this.isWaxed())) {
            player.m_6674_(hand);
            if (!player.m_7500_()) {
                itemStack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
            }
            if (this.isWaxed()) {
                this.m_5496_(SoundEvents.f_144060_, 1.0f, 1.0f);
                this.setWaxed(false);
            } else {
                this.setOxidizationLevel(this.getOxidizationLevel() - 1);
                this.m_5496_(SoundEvents.f_144059_, 1.0f, 1.0f);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)46);
            this.resetOxidizeTime();
            return InteractionResult.CONSUME;
        }
        if (itemStack.m_150930_(Items.f_42784_) && !this.isWaxed()) {
            player.m_6674_(hand);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_144178_, 1.0f, 1.0f);
            this.setWaxed(true);
            this.m_9236_().m_7605_((Entity)this, (byte)45);
            return InteractionResult.CONSUME;
        }
        if (itemStack.m_150930_(Items.f_151052_) && this.getDamageLevel() > 0) {
            player.m_6674_(hand);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            this.m_5496_((SoundEvent)ACSoundRegistry.SUBMARINE_REPAIR.get(), 1.0f, 1.0f);
            this.setDamageLevel(Math.max(this.getDamageLevel() - 1, 0));
            this.damageSustained = 0.0;
            return InteractionResult.CONSUME;
        }
        if (!this.m_9236_().f_46443_ && this.getDamageLevel() < 4) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
        super.m_8038_(level, lightningBolt);
        if (this.getOxidizationLevel() > 0 && !this.isWaxed()) {
            this.setOxidizationLevel(0);
            this.resetOxidizeTime();
            this.m_9236_().m_7605_((Entity)this, (byte)46);
        }
    }

    private void resetOxidizeTime() {
        this.oxidizeTime = 24000 * (2 + this.f_19796_.m_188503_(2));
    }

    protected void clampRotation(LivingEntity livingEntity) {
        livingEntity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(livingEntity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        livingEntity.f_19859_ += f1 - f;
        livingEntity.f_20884_ += f1 - f;
        livingEntity.m_146922_(livingEntity.m_146908_() + f1 - f);
        livingEntity.m_5616_(livingEntity.m_146908_());
    }

    public float getLeftPropellerRot() {
        return ((Float)this.f_19804_.m_135370_(LEFT_PROPELLER_ROT)).floatValue();
    }

    public void setLeftPropellerRot(float f) {
        this.f_19804_.m_135381_(LEFT_PROPELLER_ROT, (Object)Float.valueOf(f));
    }

    public float getLeftPropellerRot(float partialTick) {
        return this.prevLeftPropellerRot + (this.getLeftPropellerRot() - this.prevLeftPropellerRot) * partialTick;
    }

    public float getRightPropellerRot() {
        return ((Float)this.f_19804_.m_135370_(RIGHT_PROPELLER_ROT)).floatValue();
    }

    public void setRightPropellerRot(float f) {
        this.f_19804_.m_135381_(RIGHT_PROPELLER_ROT, (Object)Float.valueOf(f));
    }

    public float getRightPropellerRot(float partialTick) {
        return this.prevRightPropellerRot + (this.getRightPropellerRot() - this.prevRightPropellerRot) * partialTick;
    }

    public float getBackPropellerRot() {
        return ((Float)this.f_19804_.m_135370_(BACK_PROPELLER_ROT)).floatValue();
    }

    public void setBackPropellerRot(float f) {
        this.f_19804_.m_135381_(BACK_PROPELLER_ROT, (Object)Float.valueOf(f));
    }

    public float getBackPropellerRot(float partialTick) {
        return this.prevBackPropellerRot + (this.getBackPropellerRot() - this.prevBackPropellerRot) * partialTick;
    }

    public float getAcceleration() {
        return ((Float)this.f_19804_.m_135370_(ACCELERATION)).floatValue();
    }

    public void setAcceleration(float f) {
        this.f_19804_.m_135381_(ACCELERATION, (Object)Float.valueOf(f));
    }

    public boolean m_5829_() {
        return !this.m_213877_();
    }

    public boolean m_6094_() {
        return !this.m_213877_();
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_142391_() {
        return !this.m_213877_();
    }

    public float m_6143_() {
        return this.m_20160_() ? -this.m_20205_() * 0.5f : 0.0f;
    }

    public boolean m_6097_() {
        return !this.m_213877_();
    }

    public float getWaterHeight() {
        return (float)this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get());
    }

    @Override
    public void onKeyPacket(Entity keyPresser, int type) {
        if (keyPresser.m_20365_((Entity)this)) {
            if (type == 0) {
                this.controlUpTicks = 10;
            }
            if (type == 1) {
                this.controlDownTicks = 10;
            }
            if (type == 2) {
                this.setLightsOn(!this.areLightsOn());
                this.floodlightToggleCooldown = 5;
            }
        }
    }

    public void m_6845_(boolean b) {
        if (!this.m_20160_()) {
            super.m_6845_(b);
        }
    }

    public void m_20321_(boolean b) {
        if (!this.m_20160_()) {
            super.m_6845_(b);
        }
        this.m_183634_();
    }

    public boolean m_6673_(DamageSource damageSource) {
        return super.m_6673_(damageSource) || damageSource.m_276093_(DamageTypes.f_268722_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268434_) || damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268671_);
    }

    public boolean m_6469_(DamageSource damageSource, float damageValue) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        this.damageSustained += (double)damageValue;
        boolean flag = false;
        this.m_9236_().m_7605_((Entity)this, (byte)48);
        if (this.damageSustained >= 10.0) {
            this.damageSustained = 0.0;
            this.m_9236_().m_7605_((Entity)this, (byte)47);
            if (this.getDamageLevel() >= 4) {
                if (!this.m_213877_()) {
                    for (int i = 0; i < 2 + this.f_19796_.m_188503_(3); ++i) {
                        this.m_19998_((ItemLike)Items.f_151052_);
                    }
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                flag = true;
                this.m_216990_((SoundEvent)ACSoundRegistry.SUBMARINE_DESTROY.get());
            } else {
                this.setDamageLevel(this.getDamageLevel() + 1);
            }
        }
        if (!flag) {
            this.m_216990_((SoundEvent)ACSoundRegistry.SUBMARINE_HIT.get());
        }
        return true;
    }

    public float getSonarFlashAmount(float partialTicks) {
        float f = this.prevSonarFlashAmount + (this.sonarFlashAmount - this.prevSonarFlashAmount) * partialTicks;
        float f1 = (float)((double)f * (Math.cos(((float)this.f_19797_ + partialTicks) * 0.4f) + 1.0) * 0.5);
        return 1.0f - f + f1;
    }

    public static void alertSubmarineMountOf(LivingEntity living) {
        SubmarineEntity submarine;
        Entity entity;
        if (living.m_6084_() && (entity = living.m_20202_()) instanceof SubmarineEntity && (submarine = (SubmarineEntity)entity).getDamageLevel() <= 3) {
            submarine.setDangerAlertTicks(100);
        }
    }
}

