/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ConversionCrucibleBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.BiomeTreatItem;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDummyBiomeSource;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.server.generation.SurfaceRulesManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableInt;

public class ConversionCrucibleBlockEntity
extends BlockEntity {
    private static final Map<Optional<Holder.Reference<Biome>>, Integer> BIOME_COLORS = new HashMap<Optional<Holder.Reference<Biome>>, Integer>();
    public static final int MAX_FILL_AMOUNT = 10;
    public static final int MAX_CONVERSION_TIME = 100;
    private static final int PLAINS_FOG_COLOR = 12638463;
    private final List<RecursiveBlockPlacement> recursiveBlockPlacements = new ArrayList<RecursiveBlockPlacement>();
    public int tickCount;
    private float prevConversionProgress;
    private float conversionProgress;
    private float prevSplashProgress;
    private float splashProgress;
    private float prevItemDisplayProgress;
    private float itemDisplayProgress;
    private int filledLevel;
    private int biomeColor = -1;
    private int splashTimer;
    private int conversionTime = 0;
    private ResourceKey<Biome> convertingToBiome;
    private ItemStack displayStack = ItemStack.f_41583_;
    private ItemStack wantStack = ItemStack.f_41583_;
    private BlockState topBlockForBiome = Blocks.f_50440_.m_49966_();
    private BlockState middleBlockForBiome = Blocks.f_50493_.m_49966_();
    private BlockState bottomBlockForBiome = Blocks.f_50069_.m_49966_();
    private int witchModeDuration = 0;
    private int witchRainbowColor;
    private int witchFillTextIndex;

    public ConversionCrucibleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.CONVERSION_CRUCIBLE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ConversionCrucibleBlockEntity entity) {
        entity.prevConversionProgress = entity.conversionProgress;
        entity.prevSplashProgress = entity.splashProgress;
        entity.prevItemDisplayProgress = entity.itemDisplayProgress;
        if (entity.biomeColor == -1 && entity.convertingToBiome != null) {
            Registry registry = level.m_9598_().m_175515_(Registries.f_256952_);
            Optional biomeHolder = registry.m_203636_(entity.convertingToBiome);
            entity.biomeColor = biomeHolder.isPresent() ? ConversionCrucibleBlockEntity.calculateBiomeColor(biomeHolder) : 0;
        }
        if (entity.wantStack.m_150930_(entity.displayStack.m_41720_()) && !entity.wantStack.m_41619_()) {
            if (entity.itemDisplayProgress < 5.0f) {
                entity.itemDisplayProgress += 1.0f;
            }
        } else if (entity.itemDisplayProgress > 0.0f) {
            entity.itemDisplayProgress -= 1.0f;
        }
        if (entity.splashTimer > 0) {
            --entity.splashTimer;
            if (entity.splashProgress < 5.0f) {
                entity.splashProgress += 1.0f;
            }
        } else if (entity.splashProgress > 0.0f) {
            entity.splashProgress -= 1.0f;
        }
        if (entity.getFilledLevel() >= 10 && entity.convertingToBiome != null && !entity.isWitchMode()) {
            entity.displayStack = ItemStack.f_41583_;
            entity.wantStack = ItemStack.f_41583_;
            if (entity.conversionTime < 100) {
                if (entity.conversionTime % 10 == 0 && entity.conversionTime >= 20 && !level.f_46443_) {
                    entity.updateTopAndBottomBlocks();
                    entity.recursivelySpreadBiomeBlocks(new ArrayList<BlockPos>(), entity.m_58899_().m_7495_(), 10, 10);
                }
                if (entity.conversionTime == 0) {
                    entity.f_58857_.m_247517_(null, entity.m_58899_(), (SoundEvent)ACSoundRegistry.CONVERSION_CRUCIBLE_CONVERT.get(), SoundSource.BLOCKS);
                }
                ++entity.conversionTime;
            } else {
                entity.convertBiome();
                entity.markUpdated();
                entity.conversionTime = 0;
                entity.setFilledLevel(0);
            }
            entity.conversionProgress = (float)entity.conversionTime / 100.0f * 20.0f;
        } else if (entity.conversionProgress > 0.0f) {
            entity.conversionProgress -= 1.0f;
        }
        if (entity.itemDisplayProgress == 0.0f) {
            entity.displayStack = entity.wantStack;
        }
        if (entity.isWitchMode() && entity.splashProgress == 0.0f) {
            entity.witchFillTextIndex = entity.filledLevel;
        }
        ++entity.tickCount;
        if (level.f_46443_) {
            entity.spawnConversionParticles(entity.conversionTime > 98 || entity.getFilledLevel() == 0);
            if (entity.getFilledLevel() > 0 && level.f_46441_.m_188501_() < 0.33f) {
                int intcolor = entity.getConvertingToColor();
                float r = (float)((intcolor & 0xFF0000) >> 16) / 255.0f;
                float g = (float)((intcolor & 0xFF00) >> 8) / 255.0f;
                float b = (float)((intcolor & 0xFF) >> 0) / 255.0f;
                level.m_6485_((ParticleOptions)ACParticleRegistry.SMALL_COLORED_DUST.get(), true, (double)((float)entity.m_58899_().m_123341_() + 0.25f + level.f_46441_.m_188501_() * 0.5f), (double)((float)entity.m_58899_().m_123342_() + 0.2f + (float)entity.getFilledLevel() * 0.1f), (double)((float)entity.m_58899_().m_123343_() + 0.25f + level.f_46441_.m_188501_() * 0.5f), (double)r, (double)g, (double)b);
            }
        } else {
            if (entity.tickCount % 5 == 0) {
                boolean flag = false;
                for (ItemEntity item : entity.getItemsAtAndAbove(level, pos)) {
                    if (entity.getConvertingToBiome() == null && item.m_32055_().m_150930_((Item)ACItemRegistry.BIOME_TREAT.get()) && BiomeTreatItem.getCaveBiome(item.m_32055_()) != null) {
                        entity.setConvertingToBiome(BiomeTreatItem.getCaveBiome(item.m_32055_()));
                        entity.setFilledLevel(1);
                        entity.rerollWantedItem();
                        item.m_32055_().m_41774_(1);
                        flag = true;
                        continue;
                    }
                    if (!item.m_32055_().m_150930_(entity.wantStack.m_41720_())) continue;
                    flag = true;
                    entity.consumeItem(item.m_32055_());
                    break;
                }
                if (flag) {
                    entity.markUpdated();
                }
            }
            if (!entity.recursiveBlockPlacements.isEmpty()) {
                Iterator<RecursiveBlockPlacement> iterator = entity.recursiveBlockPlacements.iterator();
                while (iterator.hasNext()) {
                    RecursiveBlockPlacement recursiveBlockPlacement = iterator.next();
                    recursiveBlockPlacement.setPlaceIn(recursiveBlockPlacement.getPlaceIn() - 1);
                    if (recursiveBlockPlacement.getPlaceIn() > 0) continue;
                    if (!level.m_8055_(recursiveBlockPlacement.getPos()).m_204336_(ACTagRegistry.UNMOVEABLE)) {
                        level.m_46597_(recursiveBlockPlacement.getPos(), recursiveBlockPlacement.getToPlace());
                    }
                    iterator.remove();
                }
            }
            if (entity.witchModeDuration > 0) {
                --entity.witchModeDuration;
                if (entity.witchModeDuration == 0) {
                    entity.convertingToBiome = null;
                    entity.biomeColor = -1;
                    entity.rerollWantedItem();
                    entity.displayStack = ItemStack.f_41583_;
                    entity.wantStack = ItemStack.f_41583_;
                    entity.filledLevel = 0;
                    entity.markUpdated();
                }
            }
        }
        entity.witchRainbowColor = Color.HSBtoRGB((float)(entity.tickCount % 100) / 100.0f, 1.0f, 1.0f);
    }

    private List<ItemEntity> getItemsAtAndAbove(Level level, BlockPos pos) {
        return ConversionCrucibleBlock.getSuckShape().m_83299_().stream().flatMap(aabb -> level.m_6443_(ItemEntity.class, aabb.m_82386_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    public void spawnConversionParticles(boolean explosion) {
        float progressLerp = this.getConversionProgress(1.0f);
        if (progressLerp > 0.0f) {
            float diameter = this.getConversionAreaWidth() * progressLerp;
            int intcolor = this.getConvertingToColor();
            float r = (float)((intcolor & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((intcolor & 0xFF00) >> 8) / 255.0f;
            float b = (float)((intcolor & 0xFF) >> 0) / 255.0f;
            for (int i = 0; i < (explosion ? 35 : 3); ++i) {
                float z;
                float x = (this.f_58857_.f_46441_.m_188501_() - 0.5f) * diameter;
                if (!(Math.sqrt(x * x + (z = (this.f_58857_.f_46441_.m_188501_() - 0.5f) * diameter) * z) < (double)(diameter * 0.5f))) continue;
                this.f_58857_.m_6485_(explosion ? (ParticleOptions)ACParticleRegistry.CONVERSION_CRUCIBLE_EXPLOSION.get() : (ParticleOptions)ACParticleRegistry.COLORED_DUST.get(), true, (double)((float)this.m_58899_().m_123341_() + 0.5f + x), (double)((float)this.m_58899_().m_123342_() + this.f_58857_.f_46441_.m_188501_() * 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f + z), (double)r, (double)g, (double)b);
            }
        }
    }

    private void updateTopAndBottomBlocks() {
        this.topBlockForBiome = Blocks.f_50440_.m_49966_();
        this.middleBlockForBiome = Blocks.f_50493_.m_49966_();
        this.bottomBlockForBiome = Blocks.f_50069_.m_49966_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.convertingToBiome != null) {
                try {
                    Registry registry = serverLevel.m_9598_().m_175515_(Registries.f_256952_);
                    Optional biomeHolder = registry.m_203636_(this.convertingToBiome);
                    ChunkAccess chunkaccess = serverLevel.m_46865_(this.m_58899_());
                    WorldGenRegion worldGenRegion = new WorldGenRegion(serverLevel, List.of(chunkaccess), ChunkStatus.f_62319_, 0);
                    ResourceKey dimensionType = NoiseGeneratorSettings.f_64432_;
                    if (biomeHolder.isPresent()) {
                        if (((Holder.Reference)biomeHolder.get()).m_203656_(BiomeTags.f_207612_)) {
                            dimensionType = NoiseGeneratorSettings.f_64434_;
                        } else if (((Holder.Reference)biomeHolder.get()).m_203656_(BiomeTags.f_215818_)) {
                            dimensionType = NoiseGeneratorSettings.f_64435_;
                        }
                        this.topBlockForBiome = ConversionCrucibleBlockEntity.getFallbackTopBlock((Holder<Biome>)((Holder)biomeHolder.get()));
                        this.middleBlockForBiome = ConversionCrucibleBlockEntity.getFallbackMiddleBlock((Holder<Biome>)((Holder)biomeHolder.get()));
                        this.bottomBlockForBiome = ConversionCrucibleBlockEntity.getFallbackBottomBlock((Holder<Biome>)((Holder)biomeHolder.get()));
                    }
                    Holder.Reference settings = serverLevel.m_9598_().m_175515_(Registries.f_256932_).m_246971_(dimensionType);
                    NoiseBasedChunkGenerator noiseBasedChunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)new ACDummyBiomeSource(), (Holder)settings);
                    NoiseChunk noisechunk = chunkaccess.m_223012_(chunkAccess -> noiseBasedChunkGenerator.m_224256_(chunkAccess, serverLevel.m_215010_(), Blender.m_190202_((WorldGenRegion)worldGenRegion), serverLevel.m_7726_().m_214994_()));
                    SurfaceRules.RuleSource ruleSource = SurfaceRulesManager.mergeOverworldRules((SurfaceRules.RuleSource)((NoiseGeneratorSettings)noiseBasedChunkGenerator.m_224341_().m_203334_()).f_188871_());
                    WorldGenerationContext worldGenerationContext = new WorldGenerationContext((ChunkGenerator)noiseBasedChunkGenerator, (LevelHeightAccessor)serverLevel);
                    Function<BlockPos, Holder> biomeRef = blockPos -> (Holder)biomeHolder.get();
                    SurfaceRules.Context surfacerulesContext = new SurfaceRules.Context(serverLevel.m_7726_().m_214994_().m_224580_(), serverLevel.m_7726_().m_214994_(), chunkaccess, noisechunk, biomeRef, registry, worldGenerationContext);
                    SurfaceRules.SurfaceRule rule = (SurfaceRules.SurfaceRule)ruleSource.apply((Object)surfacerulesContext);
                    int x = this.m_58899_().m_123341_();
                    int z = this.m_58899_().m_123343_();
                    int topHeight = serverLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z) + 1;
                    surfacerulesContext.m_189569_(x, z);
                    surfacerulesContext.m_189576_(1, 1, topHeight, x, topHeight, z);
                    BlockState grass = rule.m_183550_(x, topHeight, z);
                    if (grass != null && !grass.m_60713_(Blocks.f_50752_)) {
                        this.topBlockForBiome = grass;
                    }
                    surfacerulesContext.m_189576_(1, 1, topHeight + 1, x, topHeight, z);
                    BlockState dirt = rule.m_183550_(x, topHeight, z);
                    if (dirt != null && !dirt.m_60713_(Blocks.f_50752_)) {
                        this.middleBlockForBiome = dirt;
                    }
                    surfacerulesContext.m_189576_(1, 1, topHeight + 20, x, topHeight, z);
                    BlockState stone = rule.m_183550_(x, topHeight, z);
                    if (stone != null && !stone.m_60713_(Blocks.f_50752_)) {
                        this.bottomBlockForBiome = stone;
                    }
                }
                catch (Exception e) {
                    AlexsCaves.LOGGER.warn("Encountered error finding the surface blocks of a biome");
                }
            }
        }
    }

    private boolean isBiomeBlock(BlockState blockState) {
        return blockState.m_60713_(this.topBlockForBiome.m_60734_()) || blockState.m_60713_(this.bottomBlockForBiome.m_60734_()) || blockState.m_60713_(this.middleBlockForBiome.m_60734_());
    }

    public void recursivelySpreadBiomeBlocks(List<BlockPos> crossed, BlockPos to, int maxDistance, int distanceIn) {
        if (distanceIn > 0) {
            if (!this.isBiomeBlock(this.f_58857_.m_8055_(to))) {
                BlockState blockState = this.f_58857_.m_8055_(to.m_7494_()).m_247087_() ? this.topBlockForBiome : (this.f_58857_.m_8055_(to.m_6630_(2)).m_247087_() ? this.middleBlockForBiome : this.bottomBlockForBiome);
                this.recursiveBlockPlacements.add(new RecursiveBlockPlacement(2 * (maxDistance - distanceIn), to, blockState));
            }
            crossed.add(to);
            --distanceIn;
            ArrayList<BlockPos> possibles = new ArrayList<BlockPos>();
            for (Direction direction : Direction.values()) {
                BlockPos offset = to.m_121945_(direction);
                BlockState state = this.f_58857_.m_8055_(offset);
                if (state.m_247087_() || crossed.contains(offset) || state.m_204336_(ACTagRegistry.UNMOVEABLE) || this.f_58857_.m_7702_(offset) != null || direction == Direction.DOWN && this.f_58857_.f_46441_.m_188503_(3) != 0) continue;
                possibles.add(offset);
            }
            if (possibles.size() > 0) {
                this.recursivelySpreadBiomeBlocks(crossed, (BlockPos)Util.m_214621_(possibles, (RandomSource)this.f_58857_.f_46441_), maxDistance, distanceIn);
            }
        }
    }

    public void convertBiome() {
        Optional biomeHolder = this.f_58857_.m_9598_().m_175515_(Registries.f_256952_).m_203636_(this.convertingToBiome);
        if (biomeHolder.isEmpty()) {
            return;
        }
        AABB aabb = new AABB(this.m_58899_().m_7918_(-32, -32, -32), this.m_58899_().m_7918_(32, 32, 32));
        for (Player player : this.f_58857_.m_6443_(Player.class, aabb, EntitySelector.f_20408_)) {
            ACAdvancementTriggerRegistry.CONVERT_BIOME.triggerForEntity((Entity)player);
            if (!((Holder.Reference)biomeHolder.get()).m_203656_(BiomeTags.f_207612_) || !this.f_58857_.m_6042_().f_63862_()) continue;
            ACAdvancementTriggerRegistry.CONVERT_NETHER_BIOME.triggerForEntity((Entity)player);
        }
        int width = (int)Math.ceil(this.getConversionAreaWidth() * 0.5f) + 1;
        ArrayList<ChunkAccess> list = new ArrayList<ChunkAccess>();
        BoundingBox biomeConversionBox = new BoundingBox(this.m_58899_().m_123341_() - width, this.m_58899_().m_123342_() - width, this.m_58899_().m_123343_() - width, this.m_58899_().m_123341_() + width, this.m_58899_().m_123342_() + width, this.m_58899_().m_123343_() + width);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int k = SectionPos.m_123171_((int)biomeConversionBox.m_162398_()); k <= SectionPos.m_123171_((int)biomeConversionBox.m_162401_()); ++k) {
                for (int l = SectionPos.m_123171_((int)biomeConversionBox.m_162395_()); l <= SectionPos.m_123171_((int)biomeConversionBox.m_162399_()); ++l) {
                    ChunkAccess chunkaccess = serverLevel.m_6522_(l, k, ChunkStatus.f_62326_, false);
                    if (chunkaccess == null) continue;
                    list.add(chunkaccess);
                }
            }
            MutableInt mutableint = new MutableInt(0);
            for (ChunkAccess chunkaccess1 : list) {
                chunkaccess1.m_183442_(ConversionCrucibleBlockEntity.makeResolver(mutableint, chunkaccess1, biomeConversionBox, width, (Holder<Biome>)((Holder)biomeHolder.get())), serverLevel.m_7726_().m_214994_().m_224579_());
                chunkaccess1.m_8092_(true);
            }
            serverLevel.m_7726_().f_8325_.m_274524_(list);
        }
    }

    private static BiomeResolver makeResolver(MutableInt biomeCounter, ChunkAccess chunkAccess, BoundingBox boundingBox, int width, Holder<Biome> biomeHolder) {
        return (quartX, quartY, quartZ, sampler) -> {
            int i = QuartPos.m_175402_((int)quartX);
            int j = QuartPos.m_175402_((int)quartY);
            int k = QuartPos.m_175402_((int)quartZ);
            Holder holder = chunkAccess.m_203495_(quartX, quartY, quartZ);
            if (boundingBox.m_260866_(i, j, k)) {
                biomeCounter.increment();
                return biomeHolder;
            }
            return holder;
        };
    }

    public void setConvertingToBiome(ResourceKey<Biome> resourceKey) {
        this.convertingToBiome = resourceKey;
        this.biomeColor = -1;
    }

    public ResourceKey<Biome> getConvertingToBiome() {
        return this.convertingToBiome;
    }

    public float getConversionProgress(float partialTicks) {
        return (this.prevConversionProgress + (this.conversionProgress - this.prevConversionProgress) * partialTicks) * 0.05f;
    }

    public float getSplashProgress(float partialTicks) {
        return (this.prevSplashProgress + (this.splashProgress - this.prevSplashProgress) * partialTicks) * 0.2f;
    }

    public float getItemDisplayProgress(float partialTicks) {
        return (this.prevItemDisplayProgress + (this.itemDisplayProgress - this.prevItemDisplayProgress) * partialTicks) * 0.2f;
    }

    public int getConvertingToColor() {
        return this.isWitchMode() ? this.witchRainbowColor : this.biomeColor;
    }

    public float getConversionAreaWidth() {
        return 10.0f;
    }

    public int getFilledLevel() {
        return this.filledLevel;
    }

    public void setFilledLevel(int filledLevel) {
        this.filledLevel = filledLevel;
    }

    public ItemStack getDisplayItem() {
        return this.displayStack;
    }

    public ItemStack getWantItem() {
        return this.wantStack;
    }

    public boolean isWitchMode() {
        return this.witchModeDuration > 0;
    }

    public void setWitchModeDuration(int duration) {
        this.witchModeDuration = duration;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadAdditional(compound);
    }

    public void loadAdditional(CompoundTag compound) {
        if (compound.m_128441_("WantStack")) {
            this.wantStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("WantStack"));
        }
        if (compound.m_128441_("DisplayStack")) {
            this.displayStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("DisplayStack"));
        }
        if (compound.m_128441_("ConvertingToBiome")) {
            this.convertingToBiome = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(compound.m_128461_("ConvertingToBiome")));
        }
        this.filledLevel = compound.m_128451_("FilledLevel");
        this.biomeColor = compound.m_128451_("BiomeColor");
        this.splashTimer = compound.m_128451_("SplashTimer");
        this.conversionTime = compound.m_128451_("ConversionTime");
        this.witchModeDuration = compound.m_128451_("WitchModeDuration");
    }

    public void m_183515_(CompoundTag compound) {
        CompoundTag stackTag;
        super.m_183515_(compound);
        if (this.wantStack != null && !this.wantStack.m_41619_()) {
            stackTag = new CompoundTag();
            this.wantStack.m_41739_(stackTag);
            compound.m_128365_("WantStack", (Tag)stackTag);
        }
        if (this.displayStack != null && !this.displayStack.m_41619_()) {
            stackTag = new CompoundTag();
            this.displayStack.m_41739_(stackTag);
            compound.m_128365_("DisplayStack", (Tag)stackTag);
        }
        if (this.convertingToBiome != null) {
            compound.m_128359_("ConvertingToBiome", this.convertingToBiome.m_135782_().toString());
        }
        compound.m_128405_("FilledLevel", this.filledLevel);
        compound.m_128405_("BiomeColor", this.biomeColor);
        compound.m_128405_("SplashTimer", this.splashTimer);
        compound.m_128405_("ConversionTime", this.conversionTime);
        compound.m_128405_("WitchModeDuration", this.witchModeDuration);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public AABB getRenderBoundingBox() {
        int f = 16;
        return new AABB(this.f_58858_.m_7918_(-f, 0, -f), this.f_58858_.m_7918_(f, 3, f));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            CompoundTag compound = packet.m_131708_();
            this.displayStack = ItemStack.f_41583_;
            this.wantStack = ItemStack.f_41583_;
            this.loadAdditional(compound);
        }
    }

    public void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void consumeItem(ItemStack copy) {
        copy.m_41774_(1);
        this.setFilledLevel(Math.min(this.getFilledLevel() + 1, this.isWitchMode() ? 6 : 10));
        this.rerollWantedItem();
        this.splashTimer = 10;
    }

    @Nullable
    public Component getDisplayText() {
        if (this.getDisplayItem().m_41619_() || this.isWitchMode()) {
            return null;
        }
        return this.getDisplayItem().m_41786_();
    }

    public static BlockState getFallbackTopBlock(Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return Blocks.f_50134_.m_49966_();
        }
        if (biome.m_203656_(BiomeTags.f_215818_)) {
            return Blocks.f_50259_.m_49966_();
        }
        return Blocks.f_50440_.m_49966_();
    }

    public static BlockState getFallbackMiddleBlock(Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return Blocks.f_50134_.m_49966_();
        }
        if (biome.m_203656_(BiomeTags.f_215818_)) {
            return Blocks.f_50259_.m_49966_();
        }
        return Blocks.f_50493_.m_49966_();
    }

    public static BlockState getFallbackBottomBlock(Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return Blocks.f_50134_.m_49966_();
        }
        if (biome.m_203656_(BiomeTags.f_215818_)) {
            return Blocks.f_50259_.m_49966_();
        }
        return Blocks.f_50069_.m_49966_();
    }

    public static ItemStack getFinalSacrificeForBiome(Holder<Biome> biome) {
        if (biome.m_203565_(ACBiomeRegistry.MAGNETIC_CAVES)) {
            return new ItemStack((ItemLike)ACBlockRegistry.HEART_OF_IRON.get());
        }
        if (biome.m_203565_(ACBiomeRegistry.PRIMORDIAL_CAVES)) {
            return new ItemStack((ItemLike)ACItemRegistry.TECTONIC_SHARD.get());
        }
        if (biome.m_203565_(ACBiomeRegistry.TOXIC_CAVES)) {
            return new ItemStack((ItemLike)ACBlockRegistry.NUCLEAR_BOMB.get());
        }
        if (biome.m_203565_(ACBiomeRegistry.ABYSSAL_CHASM)) {
            return new ItemStack((ItemLike)ACBlockRegistry.ENIGMATIC_ENGINE.get());
        }
        if (biome.m_203565_(ACBiomeRegistry.FORLORN_HOLLOWS)) {
            return new ItemStack((ItemLike)ACItemRegistry.PURE_DARKNESS.get());
        }
        if (biome.m_203565_(ACBiomeRegistry.CANDY_CAVITY)) {
            return new ItemStack((ItemLike)ACItemRegistry.SWEET_TOOTH.get());
        }
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return new ItemStack((ItemLike)Items.f_42418_);
        }
        if (biome.m_203656_(BiomeTags.f_215818_)) {
            return new ItemStack((ItemLike)Items.f_42735_);
        }
        return new ItemStack((ItemLike)Items.f_42415_);
    }

    public void rerollWantedItem() {
        this.updateTopAndBottomBlocks();
        this.f_58857_.m_247517_(null, this.m_58899_(), this.getFilledLevel() >= 10 ? (SoundEvent)ACSoundRegistry.CONVERSION_CRUCIBLE_ACTIVATE.get() : (SoundEvent)ACSoundRegistry.CONVERSION_CRUCIBLE_ADD.get(), SoundSource.BLOCKS);
        if (this.isWitchMode()) {
            this.wantStack = new ItemStack((ItemLike)ACItemRegistry.LICOWITCH_RADIANT_ESSENCE.get());
        } else if (this.getFilledLevel() > 8) {
            Registry registry = this.f_58857_.m_9598_().m_175515_(Registries.f_256952_);
            Optional biomeHolder = registry.m_203636_(this.convertingToBiome);
            this.wantStack = biomeHolder.isPresent() ? ConversionCrucibleBlockEntity.getFinalSacrificeForBiome((Holder<Biome>)((Holder)biomeHolder.get())) : new ItemStack((ItemLike)Items.f_42415_);
        } else {
            int choice = this.f_58857_.f_46441_.m_188503_(2);
            switch (choice) {
                case 0: {
                    this.wantStack = new ItemStack((ItemLike)this.topBlockForBiome.m_60734_().m_5456_());
                    break;
                }
                case 1: {
                    this.wantStack = new ItemStack((ItemLike)this.middleBlockForBiome.m_60734_().m_5456_());
                    break;
                }
                case 2: {
                    this.wantStack = new ItemStack((ItemLike)this.bottomBlockForBiome.m_60734_().m_5456_());
                }
            }
        }
    }

    public static int calculateBiomeColor(Optional<Holder.Reference<Biome>> holder) {
        int color;
        if (BIOME_COLORS.containsKey(holder)) {
            return BIOME_COLORS.get(holder);
        }
        int fogColor = ((Biome)holder.get().get()).m_47539_();
        if (ACBiomeRegistry.getBiomeTabletColor((ResourceKey<Biome>)holder.get().m_205785_()) != -1) {
            color = ACBiomeRegistry.getBiomeTabletColor((ResourceKey<Biome>)holder.get().m_205785_());
        } else if (fogColor == 12638463) {
            color = ((Biome)holder.get().get()).m_47464_(0.0, 0.0);
        } else {
            fogColor = 0xFF000000 | fogColor;
            float[] hsb = Color.RGBtoHSB(fogColor >> 16 & 0xFF, fogColor >> 8 & 0xFF, fogColor & 0xFF, null);
            float saturationModifier = 1.0f;
            float brightnessModifier = 3.0f;
            color = Color.HSBtoRGB(hsb[0], Mth.m_14036_((float)(hsb[1] * saturationModifier), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(hsb[2] * brightnessModifier), (float)0.0f, (float)1.0f));
        }
        BIOME_COLORS.put(holder, color);
        return color;
    }

    private class RecursiveBlockPlacement {
        private int placeIn;
        private final BlockPos pos;
        private final BlockState toPlace;

        public RecursiveBlockPlacement(int placeIn, BlockPos pos, BlockState toPlace) {
            this.placeIn = placeIn;
            this.pos = pos;
            this.toPlace = toPlace;
        }

        public int getPlaceIn() {
            return this.placeIn;
        }

        public void setPlaceIn(int placeIn) {
            this.placeIn = placeIn;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getToPlace() {
            return this.toPlace;
        }
    }
}

