/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.misc;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockColorFinder {
    public static final Object2IntMap<String> TEXTURES_TO_COLOR = new Object2IntOpenHashMap();

    public static int getBlockColor(BlockState blockState, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos) {
        String blockName = blockState.toString();
        int colorizer = -1;
        if (!blockState.m_60713_((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get())) {
            try {
                colorizer = Minecraft.m_91087_().m_91298_().m_92577_(blockState, level, pos, 0);
            }
            catch (Exception e) {
                AlexsCaves.LOGGER.warn("Another mod did not use block colorizers correctly.");
            }
        }
        if (TEXTURES_TO_COLOR.containsKey((Object)blockName)) {
            if (colorizer == -1) {
                return TEXTURES_TO_COLOR.getInt((Object)blockName);
            }
            return colorizer;
        }
        int color = 0xFFFFFF;
        if (colorizer == -1) {
            try {
                Color texColour = BlockColorFinder.getAverageColour(BlockColorFinder.getTextureAtlas(blockState));
                color = texColour.getRGB();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            color = colorizer;
        }
        TEXTURES_TO_COLOR.put((Object)blockName, color);
        return color;
    }

    private static Color getAverageColour(TextureAtlasSprite image) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float count = 0.0f;
        int uMax = image.m_245424_().m_246492_();
        int vMax = image.m_245424_().m_245330_();
        for (float i = 0.0f; i < (float)uMax; i += 1.0f) {
            for (float j = 0.0f; j < (float)vMax; j += 1.0f) {
                int alpha = image.getPixelRGBA(0, (int)i, (int)j) >> 24 & 0xFF;
                if (alpha == 0) continue;
                red += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 0 & 0xFF);
                green += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 8 & 0xFF);
                blue += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 16 & 0xFF);
                count += 1.0f;
            }
        }
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static TextureAtlasSprite getTextureAtlas(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state).m_6160_();
    }
}

